/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeSection;
import org.hyperledger.besu.evm.code.EOFLayout;

public class CodeV1
implements Code {
    private final Supplier<Hash> codeHash;
    EOFLayout eofLayout;

    CodeV1(EOFLayout layout) {
        this.eofLayout = layout;
        this.codeHash = Suppliers.memoize(() -> Hash.hash((Bytes)this.eofLayout.getContainer()));
    }

    @Override
    public int getSize() {
        return this.eofLayout.getContainer().size();
    }

    @Override
    public CodeSection getCodeSection(int section) {
        Preconditions.checkArgument((section >= 0 ? 1 : 0) != 0, (Object)"Section number is positive");
        Preconditions.checkArgument((section < this.eofLayout.getCodeSectionCount() ? 1 : 0) != 0, (Object)"Section index is valid");
        return this.eofLayout.getCodeSection(section);
    }

    @Override
    public int getCodeSectionCount() {
        return this.eofLayout.getCodeSectionCount();
    }

    @Override
    public Bytes getBytes() {
        return this.eofLayout.getContainer();
    }

    @Override
    public Hash getCodeHash() {
        return this.codeHash.get();
    }

    @Override
    public boolean isJumpDestInvalid(int jumpDestination) {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getEofVersion() {
        return this.eofLayout.getVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeV1 codeV1 = (CodeV1)o;
        return this.codeHash.equals(codeV1.codeHash) && Objects.equals(this.eofLayout, codeV1.eofLayout);
    }

    public int hashCode() {
        return Objects.hash(this.codeHash, this.eofLayout);
    }
}

