/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.internal;

import java.util.Objects;
import org.hyperledger.besu.evm.internal.FlexStack;

public class ReturnStack
extends FlexStack<ReturnStackItem> {
    static final int MAX_RETURN_STACK = 1024;

    public ReturnStack() {
        super(1024, ReturnStackItem.class);
    }

    public static final class ReturnStackItem {
        final int codeSectionIndex;
        final int pc;
        final int stackHeight;

        public ReturnStackItem(int codeSectionIndex, int pc, int stackHeight) {
            this.codeSectionIndex = codeSectionIndex;
            this.pc = pc;
            this.stackHeight = stackHeight;
        }

        public int getCodeSectionIndex() {
            return this.codeSectionIndex;
        }

        public int getPC() {
            return this.pc;
        }

        public int getStackHeight() {
            return this.stackHeight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReturnStackItem that = (ReturnStackItem)o;
            return this.codeSectionIndex == that.codeSectionIndex && this.pc == that.pc && this.stackHeight == that.stackHeight;
        }

        public int hashCode() {
            return Objects.hash(this.codeSectionIndex, this.pc, this.stackHeight);
        }

        public String toString() {
            return "ReturnStackItem{codeSectionIndex=" + this.codeSectionIndex + ", pc=" + this.pc + ", stackHeight=" + this.stackHeight + "}";
        }
    }
}

