/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class RelativeJumpVectorOperation
extends AbstractFixedCostOperation {
    public static final int OPCODE = 226;

    public RelativeJumpVectorOperation(GasCalculator gasCalculator) {
        super(226, "RJUMPV", 0, 0, gasCalculator, 4L);
    }

    @Override
    protected Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        int offsetCase;
        Bytes code = frame.getCode().getBytes();
        try {
            offsetCase = frame.popStackItem().toInt();
            if (offsetCase < 0) {
                offsetCase = Integer.MAX_VALUE;
            }
        }
        catch (ArithmeticException | IllegalArgumentException ae) {
            offsetCase = Integer.MAX_VALUE;
        }
        int vectorSize = RelativeJumpVectorOperation.getVectorSize(code, frame.getPC() + 1);
        return new Operation.OperationResult(this.gasCost, null, 1 + 2 * vectorSize + (offsetCase >= vectorSize ? 0 : Words.readBigEndianI16(frame.getPC() + 2 + offsetCase * 2, code.toArrayUnsafe())) + 1);
    }

    public static int getVectorSize(Bytes code, int offsetCountByteIndex) {
        return code.get(offsetCountByteIndex) & 0xFF;
    }
}

