/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.ThrottleBucket;
import com.hedera.hapi.node.transaction.ThrottleDefinitions;
import com.hedera.hapi.node.transaction.ThrottleGroup;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.HapiThrottleUtils;
import com.hedera.node.app.hapi.utils.sysfiles.validation.ExpectedCustomThrottles;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ThrottleParser {
    public static final Set<HederaFunctionality> EXPECTED_OPS = ExpectedCustomThrottles.ACTIVE_OPS.stream().map(protoOp -> HederaFunctionality.fromProtobufOrdinal((int)protoOp.getNumber())).collect(Collectors.toCollection(() -> EnumSet.noneOf(HederaFunctionality.class)));

    @Inject
    public ThrottleParser() {
    }

    public ValidatedThrottles parse(@NonNull Bytes bytes) {
        try {
            ThrottleDefinitions throttleDefinitions = (ThrottleDefinitions)ThrottleDefinitions.PROTOBUF.parse(bytes.toReadableSequentialData());
            this.validate(throttleDefinitions);
            ResponseCodeEnum successStatus = this.allExpectedOperations(throttleDefinitions) ? ResponseCodeEnum.SUCCESS : ResponseCodeEnum.SUCCESS_BUT_MISSING_EXPECTED_OPERATION;
            return new ValidatedThrottles(throttleDefinitions, successStatus);
        }
        catch (ParseException e) {
            throw new HandleException(ResponseCodeEnum.UNPARSEABLE_THROTTLE_DEFINITIONS);
        }
    }

    private void validate(ThrottleDefinitions throttleDefinitions) {
        this.checkForZeroOpsPerSec(throttleDefinitions);
        this.checkForRepeatedOperations(throttleDefinitions);
        this.validateLeastCommonMultipleDoesNotOverflow(throttleDefinitions);
    }

    private boolean allExpectedOperations(ThrottleDefinitions throttleDefinitions) {
        EnumSet<HederaFunctionality> customizedOps = EnumSet.noneOf(HederaFunctionality.class);
        for (ThrottleBucket bucket : throttleDefinitions.throttleBuckets()) {
            for (ThrottleGroup group : bucket.throttleGroups()) {
                customizedOps.addAll(group.operations());
            }
        }
        return customizedOps.containsAll(EXPECTED_OPS);
    }

    private void checkForZeroOpsPerSec(ThrottleDefinitions throttleDefinitions) {
        for (ThrottleBucket bucket : throttleDefinitions.throttleBuckets()) {
            for (ThrottleGroup group : bucket.throttleGroups()) {
                if (group.milliOpsPerSec() != 0L) continue;
                throw new HandleException(ResponseCodeEnum.THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC);
            }
        }
    }

    private void checkForRepeatedOperations(ThrottleDefinitions throttleDefinitions) {
        for (ThrottleBucket bucket : throttleDefinitions.throttleBuckets()) {
            HashSet seenSoFar = new HashSet();
            for (ThrottleGroup group : bucket.throttleGroups()) {
                List functions = group.operations();
                if (!Collections.disjoint(seenSoFar, functions)) {
                    throw new HandleException(ResponseCodeEnum.OPERATION_REPEATED_IN_BUCKET_GROUPS);
                }
                seenSoFar.addAll(functions);
            }
        }
    }

    private void validateLeastCommonMultipleDoesNotOverflow(ThrottleDefinitions throttleDefinitions) {
        try {
            for (ThrottleBucket bucket : throttleDefinitions.throttleBuckets()) {
                long lcm = this.leastCommonMultiple(bucket.throttleGroups());
                long unscaledCapacity = lcm * 1000000L * 1000L / 1000L;
                if (!CommonUtils.productWouldOverflow((long)unscaledCapacity, (long)bucket.burstPeriodMs())) continue;
                throw new ArithmeticException();
            }
        }
        catch (ArithmeticException e) {
            throw new HandleException(ResponseCodeEnum.THROTTLE_GROUP_LCM_OVERFLOW);
        }
    }

    private long leastCommonMultiple(List<ThrottleGroup> throttleGroups) {
        long lcm = throttleGroups.get(0).milliOpsPerSec();
        int n = throttleGroups.size();
        for (int i = 1; i < n; ++i) {
            lcm = HapiThrottleUtils.lcm((long)lcm, (long)throttleGroups.get(i).milliOpsPerSec());
        }
        return lcm;
    }

    public record ValidatedThrottles(@NonNull ThrottleDefinitions throttleDefinitions, @NonNull ResponseCodeEnum successStatus) {
        public ValidatedThrottles {
            Objects.requireNonNull(successStatus);
            Objects.requireNonNull(throttleDefinitions);
        }
    }
}

