/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.token.CryptoDeleteTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.CryptoFeeBuilder;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.service.token.records.CryptoDeleteStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.app.spi.workflows.record.DeleteCapableTransactionStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoDeleteHandler
implements TransactionHandler {
    private final CryptoFeeBuilder usageEstimator = new CryptoFeeBuilder();

    @Inject
    public CryptoDeleteHandler() {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        CryptoDeleteTransactionBody op = txn.cryptoDeleteOrThrow();
        if (!op.hasDeleteAccountID() || !op.hasTransferAccountID()) {
            throw new PreCheckException(ResponseCodeEnum.ACCOUNT_ID_DOES_NOT_EXIST);
        }
        if (op.deleteAccountIDOrThrow().equals((Object)op.transferAccountIDOrThrow())) {
            throw new PreCheckException(ResponseCodeEnum.TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        CryptoDeleteTransactionBody op = context.body().cryptoDeleteOrThrow();
        AccountID deleteAccountId = op.deleteAccountIDOrElse(AccountID.DEFAULT);
        AccountID transferAccountId = op.transferAccountIDOrElse(AccountID.DEFAULT);
        context.requireKeyOrThrow(deleteAccountId, ResponseCodeEnum.INVALID_ACCOUNT_ID).requireKeyIfReceiverSigRequired(transferAccountId, ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID);
    }

    public void handle(@NonNull HandleContext context) {
        Objects.requireNonNull(context);
        CryptoDeleteTransactionBody op = context.body().cryptoDeleteOrThrow();
        ((TokenServiceApi)context.storeFactory().serviceApi(TokenServiceApi.class)).deleteAndTransfer(op.deleteAccountIDOrThrow(), op.transferAccountIDOrThrow(), context.expiryValidator(), (DeleteCapableTransactionStreamBuilder)context.savepointStack().getBaseBuilder(CryptoDeleteStreamBuilder.class));
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody body = feeContext.body();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageEstimator.getCryptoDeleteTxFeeMatrices(CommonPbjConverters.fromPbj((TransactionBody)body), sigValueObj));
    }
}

