/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.collections.trie;

import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;

public class BytesTrieSet<E extends Bytes>
extends AbstractSet<E> {
    Node<E> root;
    int size = 0;
    final int byteLength;

    public BytesTrieSet(int byteLength) {
        this.byteLength = byteLength;
    }

    @Override
    public Iterator<E> iterator() {
        var result = new Iterator<E>(){
            final Deque<NodeWalker<E>> stack = new ArrayDeque();
            E next;
            E last;

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.next;
                this.advance();
                return this.last;
            }

            @Override
            public void remove() {
                BytesTrieSet.this.remove(this.last);
            }

            void advance() {
                while (!this.stack.isEmpty()) {
                    NodeWalker thisStep = this.stack.peek();
                    NodeWalker nextStep = thisStep.nextNodeWalker();
                    if (nextStep == null) {
                        this.stack.pop();
                        if (thisStep.thisNode() == null) continue;
                        this.next = thisStep.thisNode();
                        return;
                    }
                    this.stack.push(nextStep);
                }
                this.next = null;
            }
        };
        if (this.root != null) {
            result.stack.add(new NodeWalker<E>(this.root));
        }
        result.advance();
        return result;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Bytes)) {
            throw new IllegalArgumentException("Expected Bytes, got " + (o == null ? "null" : o.getClass().getName()));
        }
        Bytes bytes = (Bytes)o;
        byte[] array = bytes.toArrayUnsafe();
        if (array.length != this.byteLength) {
            throw new IllegalArgumentException("Byte array is size " + array.length + " but set is size " + this.byteLength);
        }
        if (this.root == null) {
            return false;
        }
        int level = 0;
        Node<E> current = this.root;
        while (current != null) {
            if (current.leafObject != null) {
                return Arrays.compare(current.leafArray, array) == 0;
            }
            current = current.children[array[level] & 0xFF];
            ++level;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Bytes)) {
            throw new IllegalArgumentException("Expected Bytes, got " + (o == null ? "null" : o.getClass().getName()));
        }
        Bytes bytes = (Bytes)o;
        byte[] array = bytes.toArrayUnsafe();
        if (array.length != this.byteLength) {
            throw new IllegalArgumentException("Byte array is size " + array.length + " but set is size " + this.byteLength);
        }
        if (this.root == null) {
            return false;
        }
        if (this.root.leafObject != null) {
            if (Arrays.compare(array, this.root.leafArray) == 0) {
                this.root = null;
                --this.size;
                return true;
            }
            return false;
        }
        int level = 0;
        Node<E> current = this.root;
        int index;
        Node next;
        while ((next = current.children[index = array[level] & 0xFF]) != null) {
            if (next.leafObject != null) {
                if (Arrays.compare(array, next.leafArray) == 0) {
                    current.children[index] = null;
                    --this.size;
                    return true;
                }
                return false;
            }
            current = next;
            ++level;
        }
        return false;
    }

    @Override
    public boolean add(E bytes) {
        byte[] array = bytes.toArrayUnsafe();
        if (array.length != this.byteLength) {
            throw new IllegalArgumentException("Byte array is size " + array.length + " but set is size " + this.byteLength);
        }
        if (this.root == null) {
            this.root = new Node<E>(array, bytes, null);
            ++this.size;
            return true;
        }
        if (this.root.leafObject != null) {
            if (Arrays.compare(array, this.root.leafArray) == 0) {
                return false;
            }
            Node<E> oldRoot = this.root;
            this.root = new Node<Object>(null, null, new Node[256]);
            this.root.children[oldRoot.leafArray[0] & 0xFF] = oldRoot;
        }
        int level = 0;
        Node<E> current = this.root;
        while (true) {
            int index;
            Node<Object> next;
            if ((next = current.children[index = array[level] & 0xFF]) == null) {
                current.children[index] = next = new Node<E>(array, bytes, null);
                ++this.size;
                return true;
            }
            if (next.leafObject != null) {
                if (Arrays.compare(array, next.leafArray) == 0) {
                    return false;
                }
                Node<Object> newLeaf = new Node<Object>(null, null, new Node[256]);
                newLeaf.children[next.leafArray[level + 1] & 0xFF] = next;
                current.children[index] = newLeaf;
                next = newLeaf;
            }
            ++level;
            current = next;
        }
    }

    @Override
    public void clear() {
        this.root = null;
    }

    record Node<E extends Bytes>(byte[] leafArray, E leafObject, Node<E>[] children) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node node = (Node)o;
            return Arrays.equals(this.leafArray, node.leafArray) && Objects.equals(this.leafObject, node.leafObject) && Arrays.equals(this.children, node.children);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.leafObject);
            result = 31 * result + Arrays.hashCode(this.leafArray);
            result = 31 * result + Arrays.hashCode(this.children);
            return result;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("Node{");
            sb.append("leaf=");
            if (this.leafObject == null) {
                sb.append("null");
            } else {
                sb.append('[');
                System.out.println(this.leafObject.toHexString());
                sb.append(']');
            }
            sb.append(", children=");
            if (this.children == null) {
                sb.append("null");
            } else {
                sb.append('[');
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) continue;
                    sb.append(i == 0 ? "" : ", ").append(i).append("=").append(this.children[i]);
                }
                sb.append(']');
            }
            sb.append('}');
            return sb.toString();
        }
    }

    static class NodeWalker<E extends Bytes> {
        final Node<E> node;
        int lastRead;

        NodeWalker(Node<E> node) {
            this.node = node;
            this.lastRead = -1;
        }

        NodeWalker<E> nextNodeWalker() {
            if (this.node.children == null) {
                return null;
            }
            while (this.lastRead < 255) {
                ++this.lastRead;
                Node child = this.node.children[this.lastRead];
                if (child == null) continue;
                return new NodeWalker(child);
            }
            return null;
        }

        E thisNode() {
            return this.node.leafObject;
        }
    }
}

