/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.converter;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.config.api.converter.ConfigConverter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SemanticVersionConverter
implements ConfigConverter<SemanticVersion> {
    private static final int MAX_VERSION_LENGTH = 100;
    private static final Pattern SEMVER_SPEC_REGEX = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    @Nullable
    public SemanticVersion convert(@NonNull String value) throws IllegalArgumentException, NullPointerException {
        if (value.length() > 100) {
            throw new IllegalArgumentException("Semantic version '" + value + "' is too long");
        }
        Matcher matcher = SEMVER_SPEC_REGEX.matcher(value);
        if (matcher.matches()) {
            SemanticVersion.Builder builder = SemanticVersion.newBuilder().major(Integer.parseInt(matcher.group(1))).minor(Integer.parseInt(matcher.group(2))).patch(Integer.parseInt(matcher.group(3)));
            if (matcher.group(4) != null) {
                builder.pre(matcher.group(4));
            }
            if (matcher.group(5) != null) {
                builder.build(matcher.group(5));
            }
            return builder.build();
        }
        throw new IllegalArgumentException("'" + value + "' is not a valid semantic version");
    }
}

