/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.Key;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class SpecificCryptoVerificationStrategy
implements VerificationStrategy {
    private final Key qualifyingKey;

    public SpecificCryptoVerificationStrategy(@NonNull Key qualifyingKey) {
        Objects.requireNonNull(qualifyingKey);
        if (!qualifyingKey.hasEd25519() && !qualifyingKey.hasEcdsaSecp256k1()) {
            throw new IllegalArgumentException("Qualifying key must be a cryptographic key");
        }
        this.qualifyingKey = qualifyingKey;
    }

    @Override
    public VerificationStrategy.Decision decideForPrimitive(@NonNull Key key) {
        Objects.requireNonNull(key);
        return this.qualifyingKey.equals((Object)key) ? VerificationStrategy.Decision.DELEGATE_TO_CRYPTOGRAPHIC_VERIFICATION : VerificationStrategy.Decision.INVALID;
    }
}

