/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.dispatcher;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.file.SystemDeleteTransactionBody;
import com.hedera.hapi.node.file.SystemUndeleteTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.spi.fees.CalculatorState;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.app.spi.workflows.WarmupContext;
import com.hedera.node.app.workflows.dispatcher.TransactionHandlers;
import com.hedera.node.config.data.FeesConfig;
import com.hederahashgraph.api.proto.java.ExchangeRate;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.hapi.fees.FeeResult;

@Singleton
public class TransactionDispatcher {
    public static final String TYPE_NOT_SUPPORTED = "This transaction type is not supported";
    public static final String SYSTEM_DELETE_WITHOUT_ID_CASE = "SystemDelete without IdCase";
    public static final String SYSTEM_UNDELETE_WITHOUT_ID_CASE = "SystemUndelete without IdCase";
    protected final TransactionHandlers handlers;
    protected final FeeManager feeManager;

    @Inject
    public TransactionDispatcher(@NonNull TransactionHandlers handlers, @NonNull FeeManager feeManager) {
        this.handlers = Objects.requireNonNull(handlers);
        this.feeManager = Objects.requireNonNull(feeManager);
    }

    public void dispatchPureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context, "The supplied argument 'context' cannot be null!");
        try {
            TransactionHandler handler = this.getHandler(context.body());
            handler.pureChecks(context);
        }
        catch (UnsupportedOperationException ex) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
    }

    public void dispatchPreHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context, "The supplied argument 'context' cannot be null!");
        try {
            TransactionHandler handler = this.getHandler(context.body());
            handler.preHandle(context);
        }
        catch (UnsupportedOperationException ex) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
    }

    public void dispatchWarmup(@NonNull WarmupContext context) {
        Objects.requireNonNull(context, "The supplied argument 'context' cannot be null!");
        try {
            TransactionHandler handler = this.getHandler(context.body());
            handler.warm(context);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @NonNull
    public Fees dispatchComputeFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext, "feeContext must not be null!");
        try {
            TransactionHandler handler = this.getHandler(feeContext.body());
            if (this.shouldUseSimpleFees(feeContext)) {
                FeeResult feeResult = Objects.requireNonNull(this.feeManager.getSimpleFeeCalculator()).calculateTxFee(feeContext.body(), (CalculatorState)feeContext);
                return TransactionDispatcher.feeResultToFees(feeResult, CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.ExchangeRate)feeContext.activeRate()));
            }
            return handler.calculateFees(feeContext);
        }
        catch (UnsupportedOperationException ex) {
            throw new HandleException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
    }

    private boolean shouldUseSimpleFees(FeeContext feeContext) {
        if (!((FeesConfig)feeContext.configuration().getConfigData(FeesConfig.class)).simpleFeesEnabled()) {
            return false;
        }
        return switch ((TransactionBody.DataOneOfType)feeContext.body().data().kind()) {
            case TransactionBody.DataOneOfType.CRYPTO_DELETE, TransactionBody.DataOneOfType.CRYPTO_CREATE_ACCOUNT, TransactionBody.DataOneOfType.SCHEDULE_CREATE, TransactionBody.DataOneOfType.SCHEDULE_SIGN, TransactionBody.DataOneOfType.SCHEDULE_DELETE -> true;
            default -> false;
        };
    }

    private static long tinycentsToTinybars(long amount, ExchangeRate rate) {
        int hbarEquiv = rate.getHbarEquiv();
        if (CommonUtils.productWouldOverflow((long)amount, (long)hbarEquiv)) {
            return FeeBuilder.getTinybarsFromTinyCents((ExchangeRate)rate, (long)amount);
        }
        return amount * (long)hbarEquiv / (long)rate.getCentEquiv();
    }

    private static Fees feeResultToFees(FeeResult feeResult, ExchangeRate rate) {
        return new Fees(TransactionDispatcher.tinycentsToTinybars(feeResult.node, rate), TransactionDispatcher.tinycentsToTinybars(feeResult.network, rate), TransactionDispatcher.tinycentsToTinybars(feeResult.service, rate));
    }

    public void dispatchHandle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context, "The supplied argument 'context' cannot be null!");
        try {
            TransactionHandler handler = this.getHandler(context.body());
            handler.handle(context);
        }
        catch (UnsupportedOperationException ex) {
            throw new HandleException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
    }

    @NonNull
    private TransactionHandler getHandler(@NonNull TransactionBody txBody) {
        return switch ((TransactionBody.DataOneOfType)txBody.data().kind()) {
            case TransactionBody.DataOneOfType.CONSENSUS_CREATE_TOPIC -> this.handlers.consensusCreateTopicHandler();
            case TransactionBody.DataOneOfType.CONSENSUS_UPDATE_TOPIC -> this.handlers.consensusUpdateTopicHandler();
            case TransactionBody.DataOneOfType.CONSENSUS_DELETE_TOPIC -> this.handlers.consensusDeleteTopicHandler();
            case TransactionBody.DataOneOfType.CONSENSUS_SUBMIT_MESSAGE -> this.handlers.consensusSubmitMessageHandler();
            case TransactionBody.DataOneOfType.CONTRACT_CREATE_INSTANCE -> this.handlers.contractCreateHandler();
            case TransactionBody.DataOneOfType.CONTRACT_UPDATE_INSTANCE -> this.handlers.contractUpdateHandler();
            case TransactionBody.DataOneOfType.CONTRACT_CALL -> this.handlers.contractCallHandler();
            case TransactionBody.DataOneOfType.CONTRACT_DELETE_INSTANCE -> this.handlers.contractDeleteHandler();
            case TransactionBody.DataOneOfType.ETHEREUM_TRANSACTION -> this.handlers.ethereumTransactionHandler();
            case TransactionBody.DataOneOfType.LAMBDA_SSTORE -> this.handlers.lambdaSStoreHandler();
            case TransactionBody.DataOneOfType.HOOK_DISPATCH -> this.handlers.hookDispatchHandler();
            case TransactionBody.DataOneOfType.CRYPTO_CREATE_ACCOUNT -> this.handlers.cryptoCreateHandler();
            case TransactionBody.DataOneOfType.CRYPTO_UPDATE_ACCOUNT -> this.handlers.cryptoUpdateHandler();
            case TransactionBody.DataOneOfType.CRYPTO_TRANSFER -> this.handlers.cryptoTransferHandler();
            case TransactionBody.DataOneOfType.CRYPTO_DELETE -> this.handlers.cryptoDeleteHandler();
            case TransactionBody.DataOneOfType.CRYPTO_APPROVE_ALLOWANCE -> this.handlers.cryptoApproveAllowanceHandler();
            case TransactionBody.DataOneOfType.CRYPTO_DELETE_ALLOWANCE -> this.handlers.cryptoDeleteAllowanceHandler();
            case TransactionBody.DataOneOfType.CRYPTO_ADD_LIVE_HASH -> this.handlers.cryptoAddLiveHashHandler();
            case TransactionBody.DataOneOfType.CRYPTO_DELETE_LIVE_HASH -> this.handlers.cryptoDeleteLiveHashHandler();
            case TransactionBody.DataOneOfType.FILE_CREATE -> this.handlers.fileCreateHandler();
            case TransactionBody.DataOneOfType.FILE_UPDATE -> this.handlers.fileUpdateHandler();
            case TransactionBody.DataOneOfType.FILE_DELETE -> this.handlers.fileDeleteHandler();
            case TransactionBody.DataOneOfType.FILE_APPEND -> this.handlers.fileAppendHandler();
            case TransactionBody.DataOneOfType.FREEZE -> this.handlers.freezeHandler();
            case TransactionBody.DataOneOfType.NODE_CREATE -> this.handlers.nodeCreateHandler();
            case TransactionBody.DataOneOfType.NODE_DELETE -> this.handlers.nodeDeleteHandler();
            case TransactionBody.DataOneOfType.NODE_UPDATE -> this.handlers.nodeUpdateHandler();
            case TransactionBody.DataOneOfType.UNCHECKED_SUBMIT -> this.handlers.networkUncheckedSubmitHandler();
            case TransactionBody.DataOneOfType.SCHEDULE_CREATE -> this.handlers.scheduleCreateHandler();
            case TransactionBody.DataOneOfType.SCHEDULE_SIGN -> this.handlers.scheduleSignHandler();
            case TransactionBody.DataOneOfType.SCHEDULE_DELETE -> this.handlers.scheduleDeleteHandler();
            case TransactionBody.DataOneOfType.TOKEN_CREATION -> this.handlers.tokenCreateHandler();
            case TransactionBody.DataOneOfType.TOKEN_UPDATE -> this.handlers.tokenUpdateHandler();
            case TransactionBody.DataOneOfType.TOKEN_MINT -> this.handlers.tokenMintHandler();
            case TransactionBody.DataOneOfType.TOKEN_BURN -> this.handlers.tokenBurnHandler();
            case TransactionBody.DataOneOfType.TOKEN_DELETION -> this.handlers.tokenDeleteHandler();
            case TransactionBody.DataOneOfType.TOKEN_WIPE -> this.handlers.tokenAccountWipeHandler();
            case TransactionBody.DataOneOfType.TOKEN_FREEZE -> this.handlers.tokenFreezeAccountHandler();
            case TransactionBody.DataOneOfType.TOKEN_UNFREEZE -> this.handlers.tokenUnfreezeAccountHandler();
            case TransactionBody.DataOneOfType.TOKEN_GRANT_KYC -> this.handlers.tokenGrantKycToAccountHandler();
            case TransactionBody.DataOneOfType.TOKEN_REVOKE_KYC -> this.handlers.tokenRevokeKycFromAccountHandler();
            case TransactionBody.DataOneOfType.TOKEN_ASSOCIATE -> this.handlers.tokenAssociateToAccountHandler();
            case TransactionBody.DataOneOfType.TOKEN_DISSOCIATE -> this.handlers.tokenDissociateFromAccountHandler();
            case TransactionBody.DataOneOfType.TOKEN_FEE_SCHEDULE_UPDATE -> this.handlers.tokenFeeScheduleUpdateHandler();
            case TransactionBody.DataOneOfType.TOKEN_PAUSE -> this.handlers.tokenPauseHandler();
            case TransactionBody.DataOneOfType.TOKEN_UNPAUSE -> this.handlers.tokenUnpauseHandler();
            case TransactionBody.DataOneOfType.TOKEN_UPDATE_NFTS -> this.handlers.tokenUpdateNftsHandler();
            case TransactionBody.DataOneOfType.TOKEN_REJECT -> this.handlers.tokenRejectHandler();
            case TransactionBody.DataOneOfType.TOKEN_CLAIM_AIRDROP -> this.handlers.tokenClaimAirdropHandler();
            case TransactionBody.DataOneOfType.TOKEN_AIRDROP -> this.handlers.tokenAirdropHandler();
            case TransactionBody.DataOneOfType.TOKEN_CANCEL_AIRDROP -> this.handlers.tokenCancelAirdropHandler();
            case TransactionBody.DataOneOfType.UTIL_PRNG -> this.handlers.utilPrngHandler();
            case TransactionBody.DataOneOfType.ATOMIC_BATCH -> this.handlers.atomicBatchHandler();
            case TransactionBody.DataOneOfType.HISTORY_PROOF_KEY_PUBLICATION -> this.handlers.historyProofKeyPublicationHandler();
            case TransactionBody.DataOneOfType.HISTORY_PROOF_SIGNATURE -> this.handlers.historyProofSignatureHandler();
            case TransactionBody.DataOneOfType.HISTORY_PROOF_VOTE -> this.handlers.historyProofVoteHandler();
            case TransactionBody.DataOneOfType.HINTS_KEY_PUBLICATION -> this.handlers.hintsKeyPublicationHandler();
            case TransactionBody.DataOneOfType.HINTS_PARTIAL_SIGNATURE -> this.handlers.hintsPartialSignatureHandler();
            case TransactionBody.DataOneOfType.HINTS_PREPROCESSING_VOTE -> this.handlers.hintsPreprocessingVoteHandler();
            case TransactionBody.DataOneOfType.CRS_PUBLICATION -> this.handlers.crsPublicationHandler();
            case TransactionBody.DataOneOfType.SYSTEM_DELETE -> {
                switch ((SystemDeleteTransactionBody.IdOneOfType)txBody.systemDeleteOrThrow().id().kind()) {
                    case CONTRACT_ID: {
                        yield this.handlers.contractSystemDeleteHandler();
                    }
                    case FILE_ID: {
                        yield this.handlers.fileSystemDeleteHandler();
                    }
                }
                throw new UnsupportedOperationException(SYSTEM_DELETE_WITHOUT_ID_CASE);
            }
            case TransactionBody.DataOneOfType.SYSTEM_UNDELETE -> {
                switch ((SystemUndeleteTransactionBody.IdOneOfType)txBody.systemUndeleteOrThrow().id().kind()) {
                    case CONTRACT_ID: {
                        yield this.handlers.contractSystemUndeleteHandler();
                    }
                    case FILE_ID: {
                        yield this.handlers.fileSystemUndeleteHandler();
                    }
                }
                throw new UnsupportedOperationException(SYSTEM_UNDELETE_WITHOUT_ID_CASE);
            }
            default -> throw new UnsupportedOperationException(TYPE_NOT_SUPPORTED);
        };
    }
}

