/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.node.app.hapi.utils.EthSigsUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HexFormat;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class BlocklistParser {
    private static final Logger log = LogManager.getLogger(BlocklistParser.class);

    public List<BlockedInfo> parse(@NonNull String blocklistResourceName) {
        List<String> fileLines = this.readFileLines(blocklistResourceName);
        if (fileLines.isEmpty()) {
            return Collections.emptyList();
        }
        return BlocklistParser.parseBlockList(fileLines);
    }

    private List<String> readFileLines(@NonNull String blocklistResourceName) {
        try {
            return BlocklistParser.readPrivateKeyBlocklist(blocklistResourceName);
        }
        catch (Exception e) {
            log.error("Failed to read blocklist resource {}", (Object)blocklistResourceName, (Object)e);
            return Collections.emptyList();
        }
    }

    private static List<BlockedInfo> parseBlockList(List<String> fileLines) {
        List<BlockedInfo> blocklist;
        try {
            String columnHeaderLine = fileLines.get(0);
            List<String> blocklistLines = fileLines.subList(1, fileLines.size());
            int columnCount = columnHeaderLine.split(",").length;
            blocklist = blocklistLines.stream().map(line -> BlocklistParser.parseCSVLine(line, columnCount)).toList();
        }
        catch (IllegalArgumentException iae) {
            log.error("Failed to parse blocklist", (Throwable)iae);
            return Collections.emptyList();
        }
        return blocklist;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private static List<String> readPrivateKeyBlocklist(@NonNull String fileName) {
        try (InputStream inputStream = BlocklistParser.class.getClassLoader().getResourceAsStream(fileName);){
            List<String> list;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(inputStream)));){
                list = reader.lines().toList();
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load blocklist", e);
        }
    }

    @NonNull
    private static BlockedInfo parseCSVLine(@NonNull String line, int columnCount) {
        byte[] privateKeyBytes;
        String[] parts = line.split(",", -1);
        if (parts.length != columnCount) {
            throw new IllegalArgumentException("Invalid line in blocklist resource: " + line);
        }
        try {
            privateKeyBytes = HexFormat.of().parseHex(parts[0]);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Failed to decode line " + line, iae);
        }
        byte[] publicKeyBytes = BlocklistParser.ecdsaPrivateToPublicKey(privateKeyBytes);
        byte[] evmAddressBytes = EthSigsUtils.recoverAddressFromPubKey((byte[])publicKeyBytes);
        return new BlockedInfo(Bytes.wrap((byte[])evmAddressBytes), parts[1]);
    }

    private static byte[] ecdsaPrivateToPublicKey(byte[] privateKeyBytes) {
        X9ECParameters ecdsaSecp256K1Curve = SECNamedCurves.getByName((String)"secp256k1");
        ECDomainParameters ecdsaSecp256K1Domain = new ECDomainParameters(ecdsaSecp256K1Curve.getCurve(), ecdsaSecp256K1Curve.getG(), ecdsaSecp256K1Curve.getN(), ecdsaSecp256K1Curve.getH());
        BigInteger privateKeyData = new BigInteger(1, privateKeyBytes);
        ECPoint q = ecdsaSecp256K1Domain.getG().multiply(privateKeyData);
        ECPublicKeyParameters publicParams = new ECPublicKeyParameters(q, ecdsaSecp256K1Domain);
        return publicParams.getQ().getEncoded(true);
    }

    public record BlockedInfo(@NonNull Bytes evmAddress, @NonNull String memo) {
    }
}

