/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.ethereum;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.rlp.RLPList;
import com.esaulpaugh.headlong.util.Integers;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.util.BigIntegers;

public record EthTxData(byte[] rawTx, EthTransactionType type, byte[] chainId, long nonce, byte[] gasPrice, byte[] maxPriorityGas, byte[] maxGas, long gasLimit, byte[] to, BigInteger value, byte[] callData, byte[] accessList, Object[] accessListAsRlp, int recId, byte[] v, byte[] r, byte[] s) {
    public static final BigInteger WEIBARS_IN_A_TINYBAR = BigInteger.valueOf(10000000000L);
    static final int SECP256K1_FLAGS_TYPE_COMPRESSION = 2;
    static final int SECP256K1_FLAGS_BIT_COMPRESSION = 256;
    static final int SECP256K1_EC_COMPRESSED = 258;
    static final BigInteger LEGACY_V_BYTE_SIGNATURE_0 = BigInteger.valueOf(27L);
    static final BigInteger LEGACY_V_BYTE_SIGNATURE_1 = BigInteger.valueOf(28L);
    public static final byte[] DETERMINISTIC_DEPLOYER_TRANSACTION = HexFormat.of().parseHex("f8a58085174876e800830186a08080b853604580600e600039806000f350fe7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffe03601600081602082378035828234f58015156039578182fd5b8082525050506014600cf31ba02222222222222222222222222222222222222222222222222222222222222222a02222222222222222222222222222222222222222222222222222222222222222");

    public static EthTxData populateEthTxData(byte[] data) {
        try {
            Iterator decoder = RLPDecoder.RLP_STRICT.sequenceIterator(data);
            RLPItem rlpItem = (RLPItem)decoder.next();
            if (rlpItem.isList()) {
                return EthTxData.populateLegacyEthTxData(rlpItem, data);
            }
            return switch (EthTxData.asByte(rlpItem)) {
                case 1 -> EthTxData.populateEip2390EthTxData((RLPItem)decoder.next(), data);
                case 2 -> EthTxData.populateEip1559EthTxData((RLPItem)decoder.next(), data);
                case 3 -> null;
                default -> null;
            };
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            return null;
        }
    }

    public EthTxData replaceCallData(byte[] newCallData) {
        return new EthTxData(null, this.type, this.chainId, this.nonce, this.gasPrice, this.maxPriorityGas, this.maxGas, this.gasLimit, this.to, this.value, newCallData, this.accessList, null, this.recId, this.v, this.r, this.s);
    }

    @VisibleForTesting
    EthTxData replaceValue(@NonNull BigInteger replacementValue) {
        return new EthTxData(null, this.type, this.chainId, this.nonce, this.gasPrice, this.maxPriorityGas, this.maxGas, this.gasLimit, this.to, replacementValue, this.callData, this.accessList, null, this.recId, this.v, this.r, this.s);
    }

    public byte[] encodeTx() {
        if (this.accessList != null && this.accessList.length > 0) {
            throw new IllegalStateException("Re-encoding access list is unsupported");
        }
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> RLPEncoder.list((Object[])new Object[]{Integers.toBytes((long)this.nonce), this.gasPrice, Integers.toBytes((long)this.gasLimit), this.to, Integers.toBytesUnsigned((BigInteger)this.value), this.callData, this.v, this.r, this.s});
            case 1 -> RLPEncoder.sequence((Object[])new Object[]{Integers.toBytes((int)1), List.of(this.chainId, Integers.toBytes((long)this.nonce), this.gasPrice, Integers.toBytes((long)this.gasLimit), this.to, Integers.toBytesUnsigned((BigInteger)this.value), this.callData, List.of(), Integers.toBytes((int)this.recId), this.r, this.s)});
            case 2 -> RLPEncoder.sequence((Object[])new Object[]{Integers.toBytes((int)2), List.of(this.chainId, Integers.toBytes((long)this.nonce), this.maxPriorityGas, this.maxGas, Integers.toBytes((long)this.gasLimit), this.to, Integers.toBytesUnsigned((BigInteger)this.value), this.callData, List.of(), Integers.toBytes((int)this.recId), this.r, this.s)});
        };
    }

    public long getAmount() {
        return this.value.divide(WEIBARS_IN_A_TINYBAR).longValueExact();
    }

    public BigInteger getMaxGasAsBigInteger(long tinybarGasPrice) {
        long multiple = 1L;
        if (this.type == EthTransactionType.LEGACY_ETHEREUM && Arrays.equals(this.rawTx, DETERMINISTIC_DEPLOYER_TRANSACTION)) {
            multiple = tinybarGasPrice;
        }
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new BigInteger(1, this.gasPrice).multiply(BigInteger.valueOf(multiple));
            case 1 -> new BigInteger(1, this.gasPrice);
            case 2 -> new BigInteger(1, this.maxGas);
        };
    }

    public long effectiveOfferedGasPriceInTinybars(long weibarGasPrice) {
        return BigInteger.valueOf(Long.MAX_VALUE).min(this.getMaxGasAsBigInteger(weibarGasPrice).divide(WEIBARS_IN_A_TINYBAR)).longValueExact();
    }

    public long effectiveTinybarValue() {
        return BigInteger.valueOf(Long.MAX_VALUE).min(this.value.divide(WEIBARS_IN_A_TINYBAR)).longValueExact();
    }

    public byte[] getEthereumHash() {
        return new Keccak.Digest256().digest(this.rawTx == null ? this.encodeTx() : this.rawTx);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EthTxData ethTxData = (EthTxData)other;
        return this.nonce == ethTxData.nonce && this.gasLimit == ethTxData.gasLimit && this.recId == ethTxData.recId && Arrays.equals(this.rawTx, ethTxData.rawTx) && this.type == ethTxData.type && Arrays.equals(this.chainId, ethTxData.chainId) && Arrays.equals(this.gasPrice, ethTxData.gasPrice) && Arrays.equals(this.maxPriorityGas, ethTxData.maxPriorityGas) && Arrays.equals(this.maxGas, ethTxData.maxGas) && Arrays.equals(this.to, ethTxData.to) && Objects.equals(this.value, ethTxData.value) && Arrays.equals(this.callData, ethTxData.callData) && Arrays.equals(this.accessList, ethTxData.accessList) && Arrays.deepEquals(this.accessListAsRlp, ethTxData.accessListAsRlp) && Arrays.equals(this.v, ethTxData.v) && Arrays.equals(this.r, ethTxData.r) && Arrays.equals(this.s, ethTxData.s);
    }

    @Override
    public int hashCode() {
        int result = Arrays.hashCode(this.rawTx);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.chainId);
        result = 31 * result + (int)(this.nonce ^ this.nonce >>> 32);
        result = 31 * result + Arrays.hashCode(this.gasPrice);
        result = 31 * result + Arrays.hashCode(this.maxPriorityGas);
        result = 31 * result + Arrays.hashCode(this.maxGas);
        result = 31 * result + (int)(this.gasLimit ^ this.gasLimit >>> 32);
        result = 31 * result + Arrays.hashCode(this.to);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.callData);
        result = 31 * result + Arrays.hashCode(this.accessList);
        result = 31 * result + this.recId;
        result = 31 * result + Arrays.hashCode(this.v);
        result = 31 * result + Arrays.hashCode(this.r);
        result = 31 * result + Arrays.hashCode(this.s);
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rawTx", this.rawTx == null ? null : Hex.encodeHexString((byte[])this.rawTx)).add("type", (Object)this.type).add("chainId", this.chainId == null ? null : Hex.encodeHexString((byte[])this.chainId)).add("nonce", this.nonce).add("gasPrice", this.gasPrice == null ? null : Hex.encodeHexString((byte[])this.gasPrice)).add("maxPriorityGas", this.maxPriorityGas == null ? null : Hex.encodeHexString((byte[])this.maxPriorityGas)).add("maxGas", this.maxGas == null ? null : Hex.encodeHexString((byte[])this.maxGas)).add("gasLimit", this.gasLimit).add("to", this.to == null ? null : Hex.encodeHexString((byte[])this.to)).add("value", (Object)this.value).add("callData", (Object)Hex.encodeHexString((byte[])this.callData)).add("accessList", this.accessList == null ? null : Hex.encodeHexString((byte[])this.accessList)).add("recId", this.recId).add("v", this.v == null ? null : Hex.encodeHexString((byte[])this.v)).add("r", (Object)Hex.encodeHexString((byte[])this.r)).add("s", (Object)Hex.encodeHexString((byte[])this.s)).toString();
    }

    public boolean hasCallData() {
        return this.callData != null && this.callData.length > 0;
    }

    public boolean hasToAddress() {
        return this.to != null && this.to.length > 0;
    }

    public boolean matchesChainId(byte[] hederaChainId) {
        return this.chainId == null || this.chainId.length == 0 || Arrays.compare(this.chainId, hederaChainId) == 0;
    }

    @VisibleForTesting
    public EthTxData replaceTo(byte[] newTo) {
        return new EthTxData(null, this.type, this.chainId, this.nonce, this.gasPrice, this.maxPriorityGas, this.maxGas, this.gasLimit, newTo, this.value, this.callData, this.accessList, null, this.recId, this.v, this.r, this.s);
    }

    @VisibleForTesting
    public EthTxData replaceRecId(int newRecId) {
        return new EthTxData(null, this.type, this.chainId, this.nonce, this.gasPrice, this.maxPriorityGas, this.maxGas, this.gasLimit, this.to, this.value, this.callData, this.accessList, null, newRecId, this.v, this.r, this.s);
    }

    @VisibleForTesting
    public EthTxData replaceR(byte[] newR) {
        return new EthTxData(null, this.type, this.chainId, this.nonce, this.gasPrice, this.maxPriorityGas, this.maxGas, this.gasLimit, this.to, this.value, this.callData, this.accessList, this.accessListAsRlp, this.recId, this.v, newR, this.s);
    }

    @VisibleForTesting
    public EthTxData replaceS(byte[] newS) {
        return new EthTxData(null, this.type, this.chainId, this.nonce, this.gasPrice, this.maxPriorityGas, this.maxGas, this.gasLimit, this.to, this.value, this.callData, this.accessList, this.accessListAsRlp, this.recId, this.v, this.r, newS);
    }

    private static EthTxData populateLegacyEthTxData(RLPItem rlpItem, byte[] rawTx) {
        int recId;
        List rlpList = rlpItem.asRLPList().elements();
        if (rlpList.size() != 9) {
            return null;
        }
        byte[] chainId = null;
        byte[] val = ((RLPItem)rlpList.get(6)).asBytes();
        BigInteger vBI = new BigInteger(1, val);
        int n = recId = vBI.testBit(0) ? 0 : 1;
        if (vBI.compareTo(BigInteger.valueOf(34L)) > 0) {
            chainId = BigIntegers.asUnsignedByteArray((BigInteger)vBI.subtract(BigInteger.valueOf(35L)).shiftRight(1));
        } else if (EthTxData.isLegacyUnprotectedEtx(vBI)) {
            chainId = new byte[]{};
        }
        return new EthTxData(rawTx, EthTransactionType.LEGACY_ETHEREUM, chainId, EthTxData.asLong((RLPItem)rlpList.get(0)), ((RLPItem)rlpList.get(1)).asBytes(), null, null, EthTxData.asLong((RLPItem)rlpList.get(2)), ((RLPItem)rlpList.get(3)).data(), ((RLPItem)rlpList.get(4)).asBigInt(), ((RLPItem)rlpList.get(5)).data(), null, null, recId, val, ((RLPItem)rlpList.get(7)).data(), ((RLPItem)rlpList.get(8)).data());
    }

    private static EthTxData populateEip1559EthTxData(RLPItem rlpItem, byte[] rawTx) {
        if (!rlpItem.isList()) {
            return null;
        }
        List rlpList = rlpItem.asRLPList().elements();
        if (rlpList.size() != 12) {
            return null;
        }
        return new EthTxData(rawTx, EthTransactionType.EIP1559, ((RLPItem)rlpList.get(0)).data(), EthTxData.asLong((RLPItem)rlpList.get(1)), null, ((RLPItem)rlpList.get(2)).data(), ((RLPItem)rlpList.get(3)).data(), EthTxData.asLong((RLPItem)rlpList.get(4)), ((RLPItem)rlpList.get(5)).data(), ((RLPItem)rlpList.get(6)).asBigInt(), ((RLPItem)rlpList.get(7)).data(), ((RLPItem)rlpList.get(8)).data(), rlpList.get(8) != null && ((RLPItem)rlpList.get(8)).isList() ? EthTxData.encodeRlpList(((RLPItem)rlpList.get(8)).asRLPList()) : new Object[]{}, EthTxData.asByte((RLPItem)rlpList.get(9)), null, ((RLPItem)rlpList.get(10)).data(), ((RLPItem)rlpList.get(11)).data());
    }

    private static EthTxData populateEip2390EthTxData(RLPItem rlpItem, byte[] rawTx) {
        if (!rlpItem.isList()) {
            return null;
        }
        List rlpList = rlpItem.asRLPList().elements();
        if (rlpList.size() != 11) {
            return null;
        }
        return new EthTxData(rawTx, EthTransactionType.EIP2930, ((RLPItem)rlpList.get(0)).data(), EthTxData.asLong((RLPItem)rlpList.get(1)), ((RLPItem)rlpList.get(2)).data(), null, null, EthTxData.asLong((RLPItem)rlpList.get(3)), ((RLPItem)rlpList.get(4)).data(), ((RLPItem)rlpList.get(5)).asBigInt(), ((RLPItem)rlpList.get(6)).data(), ((RLPItem)rlpList.get(7)).data(), ((RLPItem)rlpList.get(7)).isList() ? EthTxData.encodeRlpList(((RLPItem)rlpList.get(7)).asRLPList()) : new Object[]{}, EthTxData.asByte((RLPItem)rlpList.get(8)), null, ((RLPItem)rlpList.get(9)).data(), ((RLPItem)rlpList.get(10)).data());
    }

    private static boolean isLegacyUnprotectedEtx(@NonNull BigInteger vBI) {
        return vBI.compareTo(LEGACY_V_BYTE_SIGNATURE_0) == 0 || vBI.compareTo(LEGACY_V_BYTE_SIGNATURE_1) == 0;
    }

    private static byte asByte(@NonNull RLPItem rlpItem) {
        BigInteger v = rlpItem.asBigInt(false);
        if (v.compareTo(BigInteger.ZERO) < 0) {
            EthTxData.throwOutOfRange();
        }
        if (v.compareTo(BigInteger.valueOf(127L)) > 0) {
            EthTxData.throwOutOfRange();
        }
        return v.byteValueExact();
    }

    private static long asLong(@NonNull RLPItem rlpItem) {
        BigInteger v = rlpItem.asBigInt(false);
        if (v.compareTo(BigInteger.ZERO) < 0) {
            EthTxData.throwOutOfRange();
        }
        if (v.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            EthTxData.throwOutOfRange();
        }
        return v.longValueExact();
    }

    private static void throwOutOfRange() {
        class OutOfRangeException
        extends IllegalArgumentException {
            public OutOfRangeException() {
                super("EthTxData has RLPItem out of range");
            }
        }
        throw new OutOfRangeException();
    }

    private static Object[] encodeRlpList(RLPList rlpList) {
        return rlpList.elements().stream().map(rlpItem -> rlpItem.isList() ? (Object[])EthTxData.encodeRlpList(rlpItem.asRLPList()) : rlpItem.data()).toArray();
    }

    public static enum EthTransactionType {
        LEGACY_ETHEREUM,
        EIP2930,
        EIP1559;

    }
}

