/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.bytes.MutableBytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CallDataLoadOperation
extends AbstractFixedCostOperation {
    public CallDataLoadOperation(GasCalculator gasCalculator) {
        super(53, "CALLDATALOAD", 1, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Bytes startWord = frame.popStackItem().trimLeadingZeros();
        if (startWord.size() > 4) {
            frame.pushStackItem(Bytes.EMPTY);
            return this.successResponse;
        }
        int offset = startWord.toInt();
        if (offset < 0) {
            frame.pushStackItem(Bytes.EMPTY);
            return this.successResponse;
        }
        Bytes data = frame.getInputData();
        MutableBytes32 res = MutableBytes32.create();
        if (offset < data.size()) {
            Bytes toCopy = data.slice(offset, Math.min(32, data.size() - offset));
            toCopy.copyTo((MutableBytes)res, 0);
            frame.pushStackItem((Bytes)res.copy());
        } else {
            frame.pushStackItem(Bytes.EMPTY);
        }
        return this.successResponse;
    }
}

