/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer.customfees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FractionalFee;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AdjustmentUtils;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessmentResult;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFeeExemptions;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFixedFeeAssessor;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CustomFractionalFeeAssessor {
    private final CustomFixedFeeAssessor fixedFeeAssessor;

    @Inject
    public CustomFractionalFeeAssessor(CustomFixedFeeAssessor fixedFeeAssessor) {
        this.fixedFeeAssessor = fixedFeeAssessor;
    }

    public void assessFractionalFees(@NonNull Token token, @NonNull AccountID sender, @NonNull AssessmentResult result) {
        TokenID denom = token.tokenIdOrThrow();
        Map<TokenID, Map<AccountID, Long>> nonMutableInputTokenTransfers = result.getImmutableInputTokenAdjustments();
        Long initialAdjustment = nonMutableInputTokenTransfers.get(denom).get(sender);
        HandleException.validateTrue((initialAdjustment < 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE);
        long unitsLeft = -initialAdjustment.longValue();
        Map<AccountID, Long> creditsForToken = AdjustmentUtils.getFungibleTokenCredits(nonMutableInputTokenTransfers.get(denom));
        for (CustomFee fee : token.customFees()) {
            long nonExemptCredits;
            long totalDebits;
            Map<AccountID, Long> filteredOriginalCredits;
            AccountID collector = fee.feeCollectorAccountId();
            if (!((CustomFee.FeeOneOfType)fee.fee().kind()).equals((Object)CustomFee.FeeOneOfType.FRACTIONAL_FEE) || sender.equals((Object)collector) || (filteredOriginalCredits = this.filteredByExemptCredits(creditsForToken, token, fee)).isEmpty()) continue;
            FractionalFee fractionalFee = fee.fractionalFeeOrThrow();
            if (fractionalFee.netOfTransfers()) {
                long assessedAmount = this.netOfTransferAmountOwed(-initialAdjustment.longValue(), fractionalFee);
                CustomFee addedFee = AdjustmentUtils.asFixedFee(assessedAmount, denom, fee.feeCollectorAccountId(), fee.allCollectorsAreExempt());
                this.fixedFeeAssessor.assessFixedFee(token, sender, addedFee, result);
                continue;
            }
            try {
                totalDebits = AdjustmentUtils.getNonExemptTokenDebits(nonMutableInputTokenTransfers.get(denom), token, fee).values().stream().mapToLong(Long::longValue).reduce(0L, Math::addExact);
                nonExemptCredits = filteredOriginalCredits.values().stream().mapToLong(Long::longValue).reduce(0L, Math::addExact);
            }
            catch (Exception e) {
                throw new HandleException(ResponseCodeEnum.CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE);
            }
            NonNetAssessment nonNetAssessment = this.assessNonNetOfTransferForDebit(-initialAdjustment.longValue(), totalDebits, nonExemptCredits, fractionalFee);
            long assessedAmount = nonNetAssessment.amount();
            Map<AccountID, Long> map = result.getMutableInputBalanceAdjustments().computeIfAbsent(denom, AdjustmentUtils.ADJUSTMENTS_MAP_FACTORY);
            Map<AccountID, Long> filteredRemainingCredits = this.filteredByExemptCredits(map, token, fee);
            ReclaimResult reclaimResult = this.reclaim(assessedAmount, filteredRemainingCredits);
            long unreclaimedAmount = reclaimResult.unreclaimedAmount();
            if (nonNetAssessment.isMinimum() && unreclaimedAmount > 0L) {
                throw new HandleException(ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE);
            }
            if (unreclaimedAmount == assessedAmount) continue;
            long collectedAmount = assessedAmount - unreclaimedAmount;
            HandleException.validateTrue(((unitsLeft -= collectedAmount) >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE);
            map.putAll(filteredRemainingCredits);
            map.merge(collector, collectedAmount, AdjustmentUtils::addExactOrThrow);
            result.getMutableInputBalanceAdjustments().put(denom, map);
            Set<AccountID> finalEffPayerNums = filteredOriginalCredits.keySet();
            AccountID[] finalEffPayerNumsArray = new AccountID[finalEffPayerNums.size()];
            result.addItemizedAssessedFee(AssessedCustomFee.newBuilder().effectivePayerAccountId(finalEffPayerNums.toArray(finalEffPayerNumsArray)).feeCollectorAccountId(collector).tokenId(denom).amount(collectedAmount).build(), reclaimResult.paidByPayer());
        }
    }

    private Map<AccountID, Long> filteredByExemptCredits(@NonNull Map<AccountID, Long> adjustments, @NonNull Token token, @NonNull CustomFee fee) {
        LinkedHashMap<AccountID, Long> filteredCredits = new LinkedHashMap<AccountID, Long>();
        for (Map.Entry<AccountID, Long> entry : adjustments.entrySet()) {
            AccountID account = entry.getKey();
            Long amount = entry.getValue();
            if (amount <= 0L || CustomFeeExemptions.isPayerExempt(token, fee, account)) continue;
            filteredCredits.put(account, amount);
        }
        return filteredCredits;
    }

    public NonNetAssessment assessNonNetOfTransferForDebit(long activeDebit, long totalDebits, long nonExemptCredits, @NonNull FractionalFee fractionalFee) {
        long nominalFee;
        long numerator = fractionalFee.fractionalAmountOrThrow().numerator();
        long denominator = fractionalFee.fractionalAmountOrThrow().denominator();
        boolean isMinimum = false;
        try {
            nominalFee = AdjustmentUtils.safeFractionMultiply(numerator, denominator, nonExemptCredits);
        }
        catch (ArithmeticException e) {
            throw new HandleException(ResponseCodeEnum.CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE);
        }
        long effectiveFee = Math.max(nominalFee, fractionalFee.minimumAmount());
        if (effectiveFee > nominalFee) {
            isMinimum = true;
        }
        if (fractionalFee.maximumAmount() > 0L) {
            effectiveFee = Math.min(effectiveFee, fractionalFee.maximumAmount());
        }
        return new NonNetAssessment(AdjustmentUtils.safeFractionMultiply(activeDebit, totalDebits, effectiveFee), isMinimum);
    }

    private long netOfTransferAmountOwed(long givenUnits, @NonNull FractionalFee fractionalFee) {
        long numerator = fractionalFee.fractionalAmountOrThrow().numerator();
        long denominator = fractionalFee.fractionalAmountOrThrow().denominator();
        long nominalFee = 0L;
        try {
            nominalFee = AdjustmentUtils.safeFractionMultiply(numerator, denominator, givenUnits);
        }
        catch (ArithmeticException e) {
            throw new HandleException(ResponseCodeEnum.CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE);
        }
        long effectiveFee = Math.max(nominalFee, fractionalFee.minimumAmount());
        if (fractionalFee.maximumAmount() > 0L) {
            effectiveFee = Math.min(effectiveFee, fractionalFee.maximumAmount());
        }
        return effectiveFee;
    }

    private ReclaimResult reclaim(long amount, @NonNull Map<AccountID, Long> credits) {
        long availableToReclaim = 0L;
        try {
            availableToReclaim = credits.values().stream().mapToLong(Long::longValue).reduce(0L, Math::addExact);
        }
        catch (ArithmeticException e) {
            throw new HandleException(ResponseCodeEnum.CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE);
        }
        long amountToReclaim = Math.min(amount, availableToReclaim);
        long amountReclaimed = 0L;
        LinkedHashMap<AccountID, Long> paidByPayer = new LinkedHashMap<AccountID, Long>();
        for (Map.Entry<AccountID, Long> entry : credits.entrySet()) {
            AccountID account = entry.getKey();
            long creditAmount = entry.getValue();
            try {
                long toReclaimHere = AdjustmentUtils.safeFractionMultiply(creditAmount, availableToReclaim, amountToReclaim);
                if (toReclaimHere == 0L) continue;
                credits.put(account, creditAmount - toReclaimHere);
                amountReclaimed += toReclaimHere;
                paidByPayer.merge(account, -toReclaimHere, Math::addExact);
            }
            catch (ArithmeticException e) {
                throw new HandleException(ResponseCodeEnum.CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE);
            }
        }
        if (amountReclaimed < amountToReclaim) {
            long leftToReclaim = amountToReclaim - amountReclaimed;
            for (Map.Entry<AccountID, Long> entry : credits.entrySet()) {
                AccountID account = entry.getKey();
                long creditAmount = entry.getValue();
                long toReclaimHere = Math.min(creditAmount, leftToReclaim);
                if (toReclaimHere != 0L) {
                    credits.put(account, creditAmount - toReclaimHere);
                    amountReclaimed += toReclaimHere;
                    leftToReclaim -= toReclaimHere;
                    paidByPayer.merge(account, -toReclaimHere, Math::addExact);
                }
                if (leftToReclaim != 0L) continue;
                break;
            }
        }
        long unreclaimed = amount - amountReclaimed;
        return new ReclaimResult(unreclaimed, paidByPayer);
    }

    public record NonNetAssessment(long amount, boolean isMinimum) {
    }

    private record ReclaimResult(long unreclaimedAmount, Map<AccountID, Long> paidByPayer) {
    }
}

