/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app;

import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.ThrottleDefinitions;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.DaggerHederaInjectionComponent;
import com.hedera.node.app.HederaInjectionComponent;
import com.hedera.node.app.HederaVirtualMapState;
import com.hedera.node.app.blocks.BlockHashSigner;
import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.blocks.BlockStreamService;
import com.hedera.node.app.blocks.InitialStateHash;
import com.hedera.node.app.blocks.impl.BoundaryStateChangeListener;
import com.hedera.node.app.blocks.impl.ImmediateStateChangeListener;
import com.hedera.node.app.config.BootstrapConfigProviderImpl;
import com.hedera.node.app.config.ConfigProviderImpl;
import com.hedera.node.app.fees.FeeService;
import com.hedera.node.app.hints.HintsService;
import com.hedera.node.app.hints.impl.ReadableHintsStoreImpl;
import com.hedera.node.app.hints.impl.WritableHintsStoreImpl;
import com.hedera.node.app.history.HistoryService;
import com.hedera.node.app.history.impl.ReadableHistoryStoreImpl;
import com.hedera.node.app.history.impl.WritableHistoryStoreImpl;
import com.hedera.node.app.info.CurrentPlatformStatusImpl;
import com.hedera.node.app.info.StateNetworkInfo;
import com.hedera.node.app.metrics.StoreMetricsServiceImpl;
import com.hedera.node.app.quiescence.QuiescenceUtils;
import com.hedera.node.app.records.BlockRecordService;
import com.hedera.node.app.records.schemas.V0490BlockRecordSchema;
import com.hedera.node.app.service.addressbook.impl.AddressBookServiceImpl;
import com.hedera.node.app.service.consensus.impl.ConsensusServiceImpl;
import com.hedera.node.app.service.contract.impl.ContractServiceImpl;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.entityid.impl.AppEntityIdFactory;
import com.hedera.node.app.service.entityid.impl.EntityIdServiceImpl;
import com.hedera.node.app.service.entityid.impl.ReadableEntityIdStoreImpl;
import com.hedera.node.app.service.entityid.impl.WritableEntityIdStoreImpl;
import com.hedera.node.app.service.file.impl.FileServiceImpl;
import com.hedera.node.app.service.networkadmin.impl.FreezeServiceImpl;
import com.hedera.node.app.service.networkadmin.impl.NetworkServiceImpl;
import com.hedera.node.app.service.roster.impl.RosterServiceImpl;
import com.hedera.node.app.service.schedule.impl.ScheduleServiceImpl;
import com.hedera.node.app.service.token.impl.TokenServiceImpl;
import com.hedera.node.app.service.util.impl.UtilServiceImpl;
import com.hedera.node.app.services.AppContextImpl;
import com.hedera.node.app.services.ServiceMigrator;
import com.hedera.node.app.services.ServicesRegistry;
import com.hedera.node.app.signature.AppSignatureVerifier;
import com.hedera.node.app.signature.impl.SignatureExpanderImpl;
import com.hedera.node.app.signature.impl.SignatureVerifierImpl;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.migrate.StartupNetworks;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.state.ConsensusStateEventHandlerImpl;
import com.hedera.node.app.state.recordcache.RecordCacheService;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.throttle.AppThrottleFactory;
import com.hedera.node.app.throttle.CongestionThrottleService;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.app.tss.TssBaseServiceImpl;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.handle.HandleWorkflow;
import com.hedera.node.app.workflows.ingest.IngestWorkflow;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import com.hedera.node.app.workflows.query.QueryWorkflow;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.Utils;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.NetworkAdminConfig;
import com.hedera.node.config.data.QuiescenceConfig;
import com.hedera.node.config.data.TssConfig;
import com.hedera.node.config.data.VersionConfig;
import com.hedera.node.config.types.StreamMode;
import com.hedera.node.internal.network.Network;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.common.notification.Listener;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.listeners.ReconnectCompleteListener;
import com.swirlds.platform.listeners.ReconnectCompleteNotification;
import com.swirlds.platform.listeners.StateWriteToDiskCompleteListener;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.service.PlatformStateService;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.system.state.notifications.AsyncFatalIssListener;
import com.swirlds.platform.system.state.notifications.StateHashedListener;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.StateChangeListener;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.InstantSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.TimestampedTransaction;
import org.hiero.consensus.model.transaction.Transaction;
import org.hiero.consensus.roster.ReadableRosterStore;
import org.hiero.consensus.roster.RosterUtils;
import org.hiero.consensus.transaction.TransactionLimits;
import org.hiero.consensus.transaction.TransactionPoolNexus;

public final class Hedera
implements SwirldMain<MerkleNodeState>,
AppContext.Gossip,
Consumer<PlatformEvent> {
    private static final Logger logger = LogManager.getLogger(Hedera.class);
    private static final java.time.Duration SHUTDOWN_TIMEOUT = java.time.Duration.ofSeconds(10L);
    public static final String APP_NAME = "com.hedera.services.ServicesMain";
    public static final String SWIRLD_NAME = "123";
    private final ServicesRegistry servicesRegistry;
    private final ServiceMigrator serviceMigrator;
    private final SemanticVersion version;
    private final SemanticVersion hapiVersion;
    private final AppContext appContext;
    private final ContractServiceImpl contractServiceImpl;
    private final ScheduleServiceImpl scheduleServiceImpl;
    private final HintsService hintsService;
    private final HistoryService historyService;
    private final UtilServiceImpl utilServiceImpl;
    private final TokenServiceImpl tokenServiceImpl;
    private final FileServiceImpl fileServiceImpl;
    private final BlockStreamService blockStreamService;
    private final PlatformStateFacade platformStateFacade;
    private final BlockHashSignerFactory blockHashSignerFactory;
    private final BootstrapConfigProviderImpl bootstrapConfigProvider;
    private final StreamMode streamMode;
    private final StartupNetworksFactory startupNetworksFactory;
    private final ConsensusStateEventHandler<MerkleNodeState> consensusStateEventHandler;
    private final TransactionLimits transactionLimits;
    private final TransactionPoolNexus transactionPool;
    private Platform platform;
    private PlatformStatus platformStatus = PlatformStatus.STARTING_UP;
    private ConfigProviderImpl configProvider;
    private HederaInjectionComponent daggerApp;
    @Nullable
    private MerkleNodeState initState;
    private final Metrics metrics;
    private final BoundaryStateChangeListener boundaryStateChangeListener;
    private final ImmediateStateChangeListener immediateStateChangeListener = new ImmediateStateChangeListener();
    private final Supplier<MerkleNodeState> stateRootSupplier;
    private final BiPredicate<Round, State> onSealConsensusRound;
    private final boolean quiescenceEnabled;
    @Nullable
    private CompletableFuture<Bytes> initialStateHashFuture;
    @Nullable
    private List<StateChanges.Builder> migrationStateChanges;
    @Nullable
    private StartupNetworks startupNetworks;
    @Nullable
    private Supplier<Network> genesisNetworkSupplier;
    @NonNull
    private StoreMetricsServiceImpl storeMetricsService;
    private boolean onceOnlyServiceInitializationPostDaggerHasHappened = false;

    public Hedera(@NonNull ConstructableRegistry constructableRegistry, @NonNull ServicesRegistry.Factory registryFactory, @NonNull ServiceMigrator migrator, @NonNull InstantSource instantSource, @NonNull StartupNetworksFactory startupNetworksFactory, @NonNull HintsServiceFactory hintsServiceFactory, @NonNull HistoryServiceFactory historyServiceFactory, @NonNull BlockHashSignerFactory blockHashSignerFactory, @NonNull Metrics metrics, @NonNull PlatformStateFacade platformStateFacade, @NonNull Supplier<MerkleNodeState> baseSupplier) {
        Objects.requireNonNull(registryFactory);
        Objects.requireNonNull(constructableRegistry);
        Objects.requireNonNull(hintsServiceFactory);
        Objects.requireNonNull(historyServiceFactory);
        this.metrics = Objects.requireNonNull(metrics);
        this.serviceMigrator = Objects.requireNonNull(migrator);
        this.startupNetworksFactory = Objects.requireNonNull(startupNetworksFactory);
        this.blockHashSignerFactory = Objects.requireNonNull(blockHashSignerFactory);
        this.storeMetricsService = new StoreMetricsServiceImpl(metrics);
        this.platformStateFacade = Objects.requireNonNull(platformStateFacade);
        logger.info("\n{}\n\nWelcome to Hedera! Developed with \u2764\ufe0f by the Open Source Community.\nhttps://github.com/hashgraph/hedera-services\n\n", (Object)"****************        ****************************************************************************************\n************                ************                                                                       *\n*********                      *********                                                                       *\n******                            ******                                                                       *\n****                                ****      ___           ___           ___           ___           ___      *\n***        \u0126\u0126\u0126\u0126          \u0126\u0126\u0126\u0126        ***     /\\  \\         /\\  \\         /\\  \\         /\\  \\         /\\  \\     *\n**         \u0126\u0126\u0126\u0126          \u0126\u0126\u0126\u0126         **    /::\\  \\       /::\\  \\       /::\\  \\       /::\\  \\       /::\\  \\    *\n*          \u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126          *   /:/\\:\\  \\     /:/\\:\\  \\     /:/\\:\\  \\     /:/\\:\\  \\     /:/\\:\\  \\   *\n           \u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126             /::\\~\\:\\  \\   /:/  \\:\\__\\   /::\\~\\:\\  \\   /::\\~\\:\\  \\   /::\\~\\:\\  \\  *\n           \u0126\u0126\u0126\u0126          \u0126\u0126\u0126\u0126            /:/\\:\\ \\:\\__\\ /:/__/ \\:|__| /:/\\:\\ \\:\\__\\ /:/\\:\\ \\:\\__\\ /:/\\:\\ \\:\\__\\ *\n           \u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126            \\:\\~\\:\\ \\/__/ \\:\\  \\ /:/  / \\:\\~\\:\\ \\/__/ \\/_|::\\/:/  / \\/__\\:\\/:/  / *\n*          \u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126\u0126          *  \\:\\ \\:\\__\\    \\:\\  /:/  /   \\:\\ \\:\\__\\      |:|::/  /       \\::/  /  *\n**         \u0126\u0126\u0126\u0126          \u0126\u0126\u0126\u0126         **   \\:\\ \\/__/     \\:\\/:/  /     \\:\\ \\/__/      |:|\\/__/        /:/  /   *\n***        \u0126\u0126\u0126\u0126          \u0126\u0126\u0126\u0126        ***    \\:\\__\\        \\::/__/       \\:\\__\\        |:|  |         /:/  /    *\n****                                ****     \\/__/         ~~            \\/__/         \\|__|         \\/__/     *\n******                            ******                                                                       *\n*********                      *********                                                                       *\n************                ************                                                                       *\n****************        ****************************************************************************************");
        this.bootstrapConfigProvider = new BootstrapConfigProviderImpl();
        VersionedConfiguration bootstrapConfig = this.bootstrapConfigProvider.getConfiguration();
        this.hapiVersion = ((VersionConfig)bootstrapConfig.getConfigData(VersionConfig.class)).hapiVersion();
        this.quiescenceEnabled = ((QuiescenceConfig)bootstrapConfig.getConfigData(QuiescenceConfig.class)).enabled();
        VersionConfig versionConfig = (VersionConfig)bootstrapConfig.getConfigData(VersionConfig.class);
        this.version = versionConfig.servicesVersion().copyBuilder().build("" + ((HederaConfig)bootstrapConfig.getConfigData(HederaConfig.class)).configVersion()).build();
        this.streamMode = ((BlockStreamConfig)bootstrapConfig.getConfigData(BlockStreamConfig.class)).streamMode();
        this.servicesRegistry = registryFactory.create(constructableRegistry, (Configuration)bootstrapConfig);
        logger.info("Creating Hedera Consensus Node {} with HAPI {}", new org.apache.logging.log4j.util.Supplier[]{() -> HapiUtils.toString((SemanticVersion)this.version), () -> HapiUtils.toString((SemanticVersion)this.hapiVersion)});
        this.fileServiceImpl = new FileServiceImpl();
        Supplier<Configuration> configSupplier = () -> this.configProvider().getConfiguration();
        this.appContext = new AppContextImpl(instantSource, new AppSignatureVerifier((HederaConfig)bootstrapConfig.getConfigData(HederaConfig.class), new SignatureExpanderImpl(), new SignatureVerifierImpl()), this, configSupplier, () -> this.daggerApp.networkInfo().selfNodeInfo(), () -> this.metrics, new AppThrottleFactory(configSupplier, () -> this.daggerApp.workingStateAccessor().getState(), () -> this.daggerApp.throttleServiceManager().activeThrottleDefinitionsOrThrow(), ThrottleAccumulator::new), () -> this.daggerApp.appFeeCharging(), (EntityIdFactory)new AppEntityIdFactory((Configuration)bootstrapConfig));
        this.boundaryStateChangeListener = new BoundaryStateChangeListener(this.storeMetricsService, configSupplier);
        this.hintsService = hintsServiceFactory.apply(this.appContext, (Configuration)bootstrapConfig);
        this.historyService = historyServiceFactory.apply(this.appContext, (Configuration)bootstrapConfig);
        this.utilServiceImpl = new UtilServiceImpl(this.appContext, (txnBytes, config) -> this.daggerApp.transactionChecker().parseSignedAndCheck(txnBytes, ((HederaConfig)config.getConfigData(HederaConfig.class)).transactionMaxBytes()).txBody());
        this.tokenServiceImpl = new TokenServiceImpl(this.appContext);
        this.contractServiceImpl = new ContractServiceImpl(this.appContext, metrics);
        this.scheduleServiceImpl = new ScheduleServiceImpl(this.appContext);
        this.blockStreamService = new BlockStreamService();
        this.transactionLimits = new TransactionLimits(((HederaConfig)bootstrapConfig.getConfigData(HederaConfig.class)).nodeTransactionMaxBytes(), ((HederaConfig)bootstrapConfig.getConfigData(HederaConfig.class)).maxTransactionBytesPerEvent());
        this.transactionPool = new TransactionPoolNexus(this.transactionLimits, ((HederaConfig)bootstrapConfig.getConfigData(HederaConfig.class)).throttleTransactionQueueSize(), metrics, instantSource);
        Set.of(new EntityIdServiceImpl(), new ConsensusServiceImpl(), this.contractServiceImpl, this.fileServiceImpl, this.hintsService, this.historyService, new TssBaseServiceImpl(), new FreezeServiceImpl(), this.scheduleServiceImpl, new TokenServiceImpl(this.appContext), this.utilServiceImpl, new RecordCacheService(), new BlockRecordService(), this.blockStreamService, new FeeService(), new CongestionThrottleService(), new NetworkServiceImpl(), new AddressBookServiceImpl(), new RosterServiceImpl(this::canAdoptRoster, this::onAdoptRoster, () -> (State)Objects.requireNonNull(this.initState), platformStateFacade), PlatformStateService.PLATFORM_STATE_SERVICE).forEach(this.servicesRegistry::register);
        this.consensusStateEventHandler = new ConsensusStateEventHandlerImpl(this);
        boolean blockStreamsEnabled = this.isBlockStreamEnabled();
        this.stateRootSupplier = blockStreamsEnabled ? () -> this.withListeners((MerkleNodeState)baseSupplier.get()) : baseSupplier;
        this.onSealConsensusRound = blockStreamsEnabled ? this::manageBlockEndRound : (round, state) -> true;
    }

    public SemanticVersion getSemanticVersion() {
        return this.version;
    }

    @NonNull
    public MerkleNodeState newStateRoot() {
        return this.stateRootSupplier.get();
    }

    public Function<VirtualMap, MerkleNodeState> stateRootFromVirtualMap(@NonNull Metrics metrics, @NonNull Time time) {
        return virtualMap -> new HederaVirtualMapState((VirtualMap)virtualMap, metrics, time);
    }

    public ConsensusStateEventHandler<MerkleNodeState> newConsensusStateEvenHandler() {
        return this.consensusStateEventHandler;
    }

    public void reportUnhealthyDuration(@NonNull java.time.Duration duration) {
        this.transactionPool.reportUnhealthyDuration(duration);
    }

    @Override
    public void accept(@NonNull PlatformEvent event) {
        Objects.requireNonNull(event);
        if (this.quiescenceEnabled && this.daggerApp != null) {
            ArrayList transactions = new ArrayList(1000);
            event.forEachTransaction(transactions::add);
            int maxBytes = ((HederaConfig)this.configProvider.getConfiguration().getConfigData(HederaConfig.class)).nodeTransactionMaxBytes();
            ((Stream)transactions.stream().parallel()).forEach(tx -> {
                TransactionInfo txInfo = null;
                try {
                    txInfo = this.daggerApp.transactionChecker().parseSignedAndCheck(tx.getApplicationTransaction(), maxBytes);
                }
                catch (PreCheckException preCheckException) {
                    // empty catch block
                }
                tx.setMetadata((Object)PreHandleResult.shortCircuitingTransaction(txInfo));
            });
            this.daggerApp.quiescenceController().staleEvent((Event)event);
            if (event.getCreatorId().equals((Object)this.platform.getSelfId())) {
                this.daggerApp.txPipelineTracker().countLanded(transactions.iterator());
            }
        }
    }

    public void newPlatformStatus(@NonNull PlatformStatus platformStatus) {
        this.platformStatus = platformStatus;
        this.transactionPool.updatePlatformStatus(platformStatus);
        if (this.daggerApp != null) {
            this.daggerApp.quiescenceController().platformStatusUpdate(platformStatus);
        }
        logger.info("HederaNode#{} is {}", (Object)this.platform.getSelfId(), (Object)platformStatus.name());
        boolean streamToBlockNodes = ((BlockStreamConfig)this.configProvider.getConfiguration().getConfigData(BlockStreamConfig.class)).streamToBlockNodes();
        switch (platformStatus) {
            case ACTIVE: {
                MerkleNodeState merkleNodeState;
                this.startGrpcServer();
                if (this.initState == null || !((merkleNodeState = this.initState) instanceof VirtualMapState)) break;
                VirtualMapState virtualMapState = (VirtualMapState)merkleNodeState;
                virtualMapState.disableStartupMode();
                break;
            }
            case FREEZE_COMPLETE: {
                logger.info("Platform status is now FREEZE_COMPLETE");
                this.shutdownGrpcServer();
                this.closeRecordStreams();
                if (!streamToBlockNodes || !this.isNotEmbedded()) break;
                logger.info("FREEZE_COMPLETE - Shutting down connections to Block Nodes");
                this.daggerApp.blockNodeConnectionManager().shutdown();
                break;
            }
            case CATASTROPHIC_FAILURE: {
                logger.error("Platform status is now CATASTROPHIC_FAILURE");
                this.shutdownGrpcServer();
                if (streamToBlockNodes && this.isNotEmbedded()) {
                    logger.info("CATASTROPHIC_FAILURE - Shutting down connections to Block Nodes");
                    this.daggerApp.blockNodeConnectionManager().shutdown();
                }
                this.blockStreamManager().awaitFatalShutdown(SHUTDOWN_TIMEOUT);
                break;
            }
        }
    }

    public void initializeStatesApi(@NonNull MerkleNodeState state, @NonNull InitTrigger trigger, @NonNull Configuration platformConfig) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(platformConfig);
        this.configProvider = new ConfigProviderImpl(trigger == InitTrigger.GENESIS, this.metrics);
        this.genesisNetworkSupplier = () -> this.startupNetworks().genesisNetworkOrThrow(platformConfig);
        SemanticVersion deserializedVersion = this.platformStateFacade.creationSemanticVersionOf((State)state);
        logger.info("Initializing Hedera state version {} in {} mode with trigger {} and previous version {}", (Object)this.version, (Object)((HederaConfig)this.configProvider.getConfiguration().getConfigData(HederaConfig.class)).activeProfile(), (Object)trigger, (Object)(deserializedVersion == null ? "<NONE>" : deserializedVersion));
        if (trigger != InitTrigger.GENESIS) {
            Objects.requireNonNull(deserializedVersion, "Deserialized version cannot be null for trigger " + String.valueOf(trigger));
            this.withListeners(state);
        }
        if (HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(this.version, deserializedVersion) < 0) {
            logger.fatal("Fatal error, state source version {} is higher than node software version {}", (Object)deserializedVersion, (Object)this.version);
            throw new IllegalStateException("Cannot downgrade from " + String.valueOf(deserializedVersion) + " to " + String.valueOf(this.version));
        }
        try {
            this.migrateSchemas(state, deserializedVersion, trigger, platformConfig);
            this.logConfiguration();
        }
        catch (Throwable t) {
            logger.fatal("Critical failure during schema migration", t);
            throw new IllegalStateException("Critical failure during migration", t);
        }
        logger.info("Platform state includes freeze time={} and last frozen={}", (Object)this.platformStateFacade.freezeTimeOf((State)state), (Object)this.platformStateFacade.lastFrozenTimeOf((State)state));
    }

    public void onStateInitialized(@NonNull MerkleNodeState state, @NonNull Platform platform, @NonNull InitTrigger trigger) {
        if (this.platform != null && this.platform != platform) {
            logger.fatal("Fatal error, platform should never change once set");
            throw new IllegalStateException("Platform should never change once set");
        }
        this.platform = Objects.requireNonNull(platform);
        if (state.getReadableStates("EntityIdService").isEmpty()) {
            this.initializeStatesApi(state, trigger, platform.getContext().getConfiguration());
        }
        this.initializeDagger((State)state, trigger);
        if (!this.onceOnlyServiceInitializationPostDaggerHasHappened) {
            this.contractServiceImpl.createMetrics();
            this.onceOnlyServiceInitializationPostDaggerHasHappened = true;
            try {
                this.contractServiceImpl.nativeLibVerifier().verifyNativeLibs();
            }
            catch (IllegalStateException e) {
                this.shutdown();
                System.exit(1);
            }
        }
    }

    private void migrateSchemas(@NonNull MerkleNodeState state, @Nullable SemanticVersion deserializedVersion, @NonNull InitTrigger trigger, @NonNull Configuration platformConfig) {
        boolean isUpgrade = HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(this.version, deserializedVersion) > 0;
        logger.info("{} from Services version {} @ current {} with trigger {}", new org.apache.logging.log4j.util.Supplier[]{() -> isUpgrade ? "Upgrading" : (deserializedVersion == null ? "Starting" : "Restarting"), () -> HapiUtils.toString((SemanticVersion)deserializedVersion), () -> HapiUtils.toString((SemanticVersion)this.version), () -> trigger});
        this.blockStreamService.resetMigratedLastBlockHash();
        this.startupNetworks = this.startupNetworksFactory.apply(this.configProvider);
        PlatformStateService.PLATFORM_STATE_SERVICE.setAppVersionFn(config -> ((VersionConfig)platformConfig.getConfigData(VersionConfig.class)).servicesVersion());
        this.initState = state;
        List<StateChanges.Builder> migrationChanges = this.serviceMigrator.doMigrations(state, this.servicesRegistry, deserializedVersion, this.version, (Configuration)this.configProvider.getConfiguration(), platformConfig, this.startupNetworks, this.storeMetricsService, this.configProvider, this.platformStateFacade);
        this.initState = null;
        this.migrationStateChanges = new ArrayList<StateChanges.Builder>(migrationChanges);
        this.immediateStateChangeListener.reset(null);
        this.boundaryStateChangeListener.reset();
        if (this.streamMode != StreamMode.BLOCKS && isUpgrade && trigger != InitTrigger.RECONNECT && trigger != InitTrigger.GENESIS) {
            this.unmarkMigrationRecordsStreamed((State)state);
            this.migrationStateChanges.add(StateChanges.newBuilder().stateChanges(this.boundaryStateChangeListener.allStateChanges()));
            this.boundaryStateChangeListener.reset();
        }
        logger.info("Migration complete");
    }

    public void init(@NonNull Platform platform, @NonNull NodeId nodeId) {
        if (this.platform != platform) {
            throw new IllegalArgumentException("Platform must be the same instance");
        }
        this.assertEnvSanityChecks(nodeId);
        logger.info("Initializing Hedera app with HederaNode#{}", (Object)nodeId);
        Locale.setDefault(Locale.US);
        logger.info("Locale to set to US en");
    }

    public void submit(@NonNull TransactionBody body) {
        HederaFunctionality function;
        Objects.requireNonNull(body);
        if (this.platformStatus != PlatformStatus.ACTIVE) {
            throw new IllegalStateException(String.valueOf(ResponseCodeEnum.PLATFORM_NOT_ACTIVE));
        }
        try {
            function = HapiUtils.functionOf((TransactionBody)body);
        }
        catch (UnknownHederaFunctionality e) {
            throw new IllegalArgumentException(String.valueOf(ResponseCodeEnum.UNKNOWN));
        }
        try {
            VersionedConfiguration config = this.configProvider.getConfiguration();
            NetworkAdminConfig adminConfig = (NetworkAdminConfig)config.getConfigData(NetworkAdminConfig.class);
            Set allowList = adminConfig.nodeTransactionsAllowList().functionalitySet();
            if (!allowList.contains(function)) {
                throw new IllegalArgumentException(String.valueOf(ResponseCodeEnum.NOT_SUPPORTED));
            }
            Bytes payload = SignedTransaction.PROTOBUF.toBytes((Object)StreamBuilder.nodeSignedTxWith((TransactionBody)body));
            Objects.requireNonNull(this.daggerApp).submissionManager().submit(body, payload);
            if (this.quiescenceEnabled && QuiescenceUtils.isRelevantTransaction(body)) {
                this.daggerApp.txPipelineTracker().incrementInFlight();
            }
        }
        catch (PreCheckException e) {
            ResponseCodeEnum reason = e.responseCode();
            if (reason == ResponseCodeEnum.DUPLICATE_TRANSACTION) {
                throw new IllegalArgumentException(String.valueOf(ResponseCodeEnum.DUPLICATE_TRANSACTION));
            }
            throw new IllegalStateException(String.valueOf(reason));
        }
    }

    public Signature sign(byte[] ledgerId) {
        return this.platform.sign(ledgerId);
    }

    public boolean isAvailable() {
        return this.daggerApp != null && this.daggerApp.currentPlatformStatus().get() == PlatformStatus.ACTIVE;
    }

    private void closeRecordStreams() {
        this.daggerApp.blockRecordManager().close();
    }

    private boolean isUTF8(@NonNull Charset defaultCharset) {
        if (!StandardCharsets.UTF_8.equals(defaultCharset)) {
            logger.error("Default charset is {}, not UTF-8", (Object)defaultCharset);
            return false;
        }
        return true;
    }

    private boolean sha384DigestIsAvailable() {
        try {
            MessageDigest.getInstance("SHA-384");
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)e);
            return false;
        }
    }

    public void run() {
        logger.info("Starting the Hedera node");
    }

    public void shutdown() {
        logger.info("Shutting down Hedera node");
        this.shutdownGrpcServer();
        if (this.daggerApp != null) {
            logger.debug("Shutting down the Block Node Connection Manager");
            this.daggerApp.blockNodeConnectionManager().shutdown();
            logger.debug("Shutting down the state");
            State state = this.daggerApp.workingStateAccessor().getState();
            if (state instanceof HederaVirtualMapState) {
                HederaVirtualMapState msr = (HederaVirtualMapState)state;
                msr.close();
            }
            logger.debug("Shutting down the block manager");
            this.daggerApp.blockRecordManager().close();
        }
        this.platform = null;
        this.daggerApp = null;
    }

    public void onPreHandle(@NonNull Event event, @NonNull State state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTxnCallback) {
        ReadableStoreFactory readableStoreFactory = new ReadableStoreFactory(state);
        NodeInfo creatorInfo = this.daggerApp.networkInfo().nodeInfo(event.getCreatorId().id());
        BiConsumer<StateSignatureTransaction, Bytes> shortCircuitTxnCallback = (txn, ignored) -> {
            ScopedSystemTransaction scopedTxn = new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), txn);
            stateSignatureTxnCallback.accept(scopedTxn);
        };
        ArrayList<Transaction> transactions = new ArrayList<Transaction>(1000);
        event.forEachTransaction(transactions::add);
        this.daggerApp.preHandleWorkflow().preHandle(readableStoreFactory, creatorInfo, transactions.stream(), shortCircuitTxnCallback);
        if (this.quiescenceEnabled) {
            this.daggerApp.quiescenceController().onPreHandle(transactions);
            if (event.getCreatorId().equals((Object)this.platform.getSelfId())) {
                this.daggerApp.txPipelineTracker().countLanded(event.transactionIterator());
            }
        }
    }

    public void onNewRecoveredState() {
        this.daggerApp.blockRecordManager().close();
    }

    public void onHandleConsensusRound(@NonNull Round round, @NonNull MerkleNodeState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTxnCallback) {
        this.daggerApp.workingStateAccessor().setState((State)state);
        this.daggerApp.handleWorkflow().handleRound((State)state, round, stateSignatureTxnCallback);
    }

    public boolean onSealConsensusRound(@NonNull Round round, @NonNull State state) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(round);
        return this.onSealConsensusRound.test(round, state);
    }

    void startGrpcServer() {
        if (this.isNotEmbedded() && !this.daggerApp.grpcServerManager().isRunning()) {
            this.daggerApp.grpcServerManager().start();
        }
    }

    public void shutdownGrpcServer() {
        if (this.isNotEmbedded()) {
            this.daggerApp.grpcServerManager().stop();
        }
    }

    public void setInitialStateHash(@NonNull Hash stateHash) {
        Objects.requireNonNull(stateHash);
        this.initialStateHashFuture = CompletableFuture.completedFuture(stateHash.getBytes());
    }

    @NonNull
    public StartupNetworks startupNetworks() {
        return Objects.requireNonNull(this.startupNetworks);
    }

    public IngestWorkflow ingestWorkflow() {
        return this.daggerApp.ingestWorkflow();
    }

    public QueryWorkflow queryWorkflow() {
        return this.daggerApp.queryWorkflow();
    }

    public QueryWorkflow operatorQueryWorkflow() {
        return this.daggerApp.operatorQueryWorkflow();
    }

    public HandleWorkflow handleWorkflow() {
        return this.daggerApp.handleWorkflow();
    }

    public ConfigProvider configProvider() {
        return this.configProvider;
    }

    public BootstrapConfigProviderImpl bootstrapConfigProvider() {
        return this.bootstrapConfigProvider;
    }

    public BlockStreamManager blockStreamManager() {
        return this.daggerApp.blockStreamManager();
    }

    public ThrottleDefinitions activeThrottleDefinitions() {
        return this.daggerApp.throttleServiceManager().activeThrottleDefinitionsOrThrow();
    }

    public boolean isBlockStreamEnabled() {
        return this.streamMode != StreamMode.RECORDS;
    }

    public ImmediateStateChangeListener immediateStateChangeListener() {
        return this.immediateStateChangeListener;
    }

    public BoundaryStateChangeListener boundaryStateChangeListener() {
        return this.boundaryStateChangeListener;
    }

    public boolean systemEntitiesCreated() {
        return Optional.ofNullable(this.daggerApp.systemEntitiesCreationFlag()).map(AtomicBoolean::get).orElse(true);
    }

    @NonNull
    public Supplier<Network> genesisNetworkSupplierOrThrow() {
        return Objects.requireNonNull(this.genesisNetworkSupplier);
    }

    public Bytes encodeSystemTransaction(@NonNull StateSignatureTransaction stateSignatureTransaction) {
        AccountID nodeAccountID = ((NodeInfo)this.appContext.selfNodeInfoSupplier().get()).accountId();
        TransactionID.Builder transactionID = TransactionID.newBuilder().transactionValidStart(Timestamp.DEFAULT).accountID(nodeAccountID);
        TransactionBody.Builder transactionBody = TransactionBody.newBuilder().transactionID(transactionID).nodeAccountID(nodeAccountID).transactionValidDuration(Duration.DEFAULT).stateSignatureTransaction(stateSignatureTransaction);
        SignedTransaction signedTx = SignedTransaction.newBuilder().bodyBytes(TransactionBody.PROTOBUF.toBytes((Object)transactionBody.build())).sigMap(SignatureMap.DEFAULT).build();
        return SignedTransaction.PROTOBUF.toBytes((Object)signedTx);
    }

    public void submitStateSignature(@NonNull StateSignatureTransaction stateSignatureTransaction) {
        this.transactionPool.submitPriorityTransaction(this.encodeSystemTransaction(stateSignatureTransaction));
    }

    @NonNull
    public List<TimestampedTransaction> getTransactionsForEvent() {
        return this.transactionPool.getTransactionsForEvent();
    }

    public boolean hasBufferedSignatureTransactions() {
        return this.transactionPool.hasBufferedSignatureTransactions();
    }

    @NonNull
    public TransactionLimits getTransactionLimits() {
        return this.transactionLimits;
    }

    private void initializeDagger(@NonNull State state, @NonNull InitTrigger trigger) {
        NotificationEngine notifications = this.platform.getNotificationEngine();
        boolean blockStreamEnabled = this.isBlockStreamEnabled();
        if (this.daggerApp != null) {
            this.shutdownGrpcServer();
            notifications.unregister(ReconnectCompleteListener.class, (Listener)this.daggerApp.reconnectListener());
            notifications.unregister(StateWriteToDiskCompleteListener.class, (Listener)this.daggerApp.stateWriteToDiskListener());
            notifications.unregister(AsyncFatalIssListener.class, (Listener)this.daggerApp.fatalIssListener());
            if (blockStreamEnabled) {
                notifications.unregister(StateHashedListener.class, (Listener)this.daggerApp.blockStreamManager());
                this.daggerApp.blockNodeConnectionManager().shutdown();
            }
        }
        if (trigger == InitTrigger.RECONNECT) {
            this.initialStateHashFuture = new CompletableFuture();
            notifications.register(ReconnectCompleteListener.class, (Listener)new ReadReconnectStartingStateHash(notifications));
        }
        Objects.requireNonNull(this.initialStateHashFuture);
        long roundNum = Objects.requireNonNull((PlatformState)state.getReadableStates("PlatformStateService").getSingleton(V0540PlatformStateSchema.PLATFORM_STATE_STATE_ID).get()).consensusSnapshotOrThrow().round();
        InitialStateHash initialStateHash = new InitialStateHash(this.initialStateHashFuture, roundNum);
        ReadableRosterStore rosterStore = new ReadableStoreFactory(state).getStore(ReadableRosterStore.class);
        Roster currentRoster = Objects.requireNonNull(rosterStore.getActiveRoster());
        StateNetworkInfo networkInfo = new StateNetworkInfo(this.platform.getSelfId().id(), state, currentRoster, this.configProvider, () -> Objects.requireNonNull(this.genesisNetworkSupplier).get());
        this.hintsService.initCurrentRoster(currentRoster);
        BlockHashSigner blockHashSigner = this.blockHashSignerFactory.apply(this.hintsService, this.historyService, this.configProvider);
        this.daggerApp = DaggerHederaInjectionComponent.builder().configProviderImpl(this.configProvider).bootstrapConfigProviderImpl(this.bootstrapConfigProvider).fileServiceImpl(this.fileServiceImpl).contractServiceImpl(this.contractServiceImpl).utilServiceImpl(this.utilServiceImpl).tokenServiceImpl(this.tokenServiceImpl).scheduleService(this.scheduleServiceImpl).initTrigger(trigger).softwareVersion(this.version).self(networkInfo.selfNodeInfo()).platform(this.platform).transactionPool(this.transactionPool).currentPlatformStatus(new CurrentPlatformStatusImpl(this.platform)).servicesRegistry(this.servicesRegistry).instantSource(this.appContext.instantSource()).throttleFactory(this.appContext.throttleFactory()).metrics(this.metrics).immediateStateChangeListener(this.immediateStateChangeListener).boundaryStateChangeListener(this.boundaryStateChangeListener).migrationStateChanges(this.migrationStateChanges != null ? this.migrationStateChanges : new ArrayList<StateChanges.Builder>()).initialStateHash(initialStateHash).networkInfo(networkInfo).startupNetworks(this.startupNetworks).hintsService(this.hintsService).historyService(this.historyService).blockHashSigner(blockHashSigner).appContext(this.appContext).platformStateFacade(this.platformStateFacade).build();
        this.daggerApp.initializer().initialize(state, this.streamMode);
        this.logConfiguration();
        notifications.register(ReconnectCompleteListener.class, (Listener)this.daggerApp.reconnectListener());
        notifications.register(StateWriteToDiskCompleteListener.class, (Listener)this.daggerApp.stateWriteToDiskListener());
        notifications.register(AsyncFatalIssListener.class, (Listener)this.daggerApp.fatalIssListener());
        if (blockStreamEnabled) {
            notifications.register(StateHashedListener.class, (Listener)this.daggerApp.blockStreamManager());
            Bytes lastBlockHash = trigger == InitTrigger.GENESIS ? BlockStreamManager.ZERO_BLOCK_HASH : (Bytes)this.blockStreamService.migratedLastBlockHash().orElse(null);
            this.daggerApp.blockStreamManager().init(state, lastBlockHash);
            this.migrationStateChanges = null;
        }
    }

    private void logConfiguration() {
        if (logger.isInfoEnabled()) {
            VersionedConfiguration config = this.configProvider.getConfiguration();
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Active Configuration:");
            Utils.allProperties((Configuration)config).forEach((key, value) -> lines.add(key + " = " + String.valueOf(value)));
            logger.info(String.join((CharSequence)"\n", lines));
        }
    }

    private void unmarkMigrationRecordsStreamed(@NonNull State state) {
        WritableStates blockServiceState = state.getWritableStates("BlockRecordService");
        WritableSingletonState blockInfoState = blockServiceState.getSingleton(V0490BlockRecordSchema.BLOCKS_STATE_ID);
        BlockInfo currentBlockInfo = Objects.requireNonNull((BlockInfo)blockInfoState.get());
        BlockInfo nextBlockInfo = currentBlockInfo.copyBuilder().migrationRecordsStreamed(false).build();
        blockInfoState.put((Object)nextBlockInfo);
        logger.info("Unmarked post-upgrade work as done");
        ((WritableSingletonStateBase)blockInfoState).commit();
    }

    private void assertEnvSanityChecks(@NonNull NodeId nodeId) {
        Charset defaultCharset = this.daggerApp.nativeCharset().get();
        if (!this.isUTF8(defaultCharset)) {
            logger.error("Fatal precondition violation in HederaNode#{}: default charset is {} and not UTF-8\nLC_ALL={}\nLANG={}\nfile.encoding={}\n", (Object)nodeId, (Object)defaultCharset, (Object)System.getenv("LC_ALL"), (Object)System.getenv("LANG"), (Object)System.getProperty("file.encoding"));
            System.exit(1);
        }
        if (!this.sha384DigestIsAvailable()) {
            logger.error("Fatal precondition violation in HederaNode#{}: digest factory does not support SHA-384", (Object)nodeId);
            System.exit(1);
        }
    }

    private MerkleNodeState withListeners(@NonNull MerkleNodeState root) {
        root.registerCommitListener((StateChangeListener)this.boundaryStateChangeListener);
        root.registerCommitListener((StateChangeListener)this.immediateStateChangeListener);
        return root;
    }

    private boolean manageBlockEndRound(@NonNull Round round, @NonNull State state) {
        this.daggerApp.nodeRewardManager().updateJudgesOnEndRound(state);
        return this.daggerApp.blockStreamManager().endRound(state, round.getRoundNum());
    }

    private boolean isNotEmbedded() {
        return this.appContext.instantSource() == InstantSource.system();
    }

    private boolean canAdoptRoster(@NonNull Roster roster) {
        Objects.requireNonNull(this.initState);
        Bytes rosterHash = RosterUtils.hash((Roster)roster).getBytes();
        TssConfig tssConfig = (TssConfig)this.configProvider.getConfiguration().getConfigData(TssConfig.class);
        ReadableEntityIdStoreImpl entityCounters = new ReadableEntityIdStoreImpl((ReadableStates)this.initState.getWritableStates("EntityIdService"));
        return !(tssConfig.hintsEnabled() && !new ReadableHintsStoreImpl(this.initState.getReadableStates("HintsService"), (ReadableEntityCounters)entityCounters).isReadyToAdopt(rosterHash) || tssConfig.historyEnabled() && !new ReadableHistoryStoreImpl(this.initState.getReadableStates("HistoryService")).isReadyToAdopt(rosterHash));
    }

    private void onAdoptRoster(@NonNull Roster previousRoster, @NonNull Roster adoptedRoster) {
        Bytes adoptedRosterHash;
        Objects.requireNonNull(this.initState);
        TssConfig tssConfig = (TssConfig)this.configProvider.getConfiguration().getConfigData(TssConfig.class);
        if (tssConfig.historyEnabled()) {
            adoptedRosterHash = RosterUtils.hash((Roster)adoptedRoster).getBytes();
            WritableStates writableHistoryStates = this.initState.getWritableStates("HistoryService");
            WritableHistoryStoreImpl store = new WritableHistoryStoreImpl(writableHistoryStates);
            store.handoff(previousRoster, adoptedRoster, adoptedRosterHash);
            ((CommittableWritableStates)writableHistoryStates).commit();
        }
        if (tssConfig.hintsEnabled()) {
            adoptedRosterHash = RosterUtils.hash((Roster)adoptedRoster).getBytes();
            WritableStates writableHintsStates = this.initState.getWritableStates("HintsService");
            WritableStates writableEntityStates = this.initState.getWritableStates("EntityIdService");
            WritableEntityIdStoreImpl entityCounters = new WritableEntityIdStoreImpl(writableEntityStates);
            WritableHintsStoreImpl store = new WritableHintsStoreImpl(writableHintsStates, (WritableEntityCounters)entityCounters);
            this.hintsService.handoff(store, previousRoster, adoptedRoster, adoptedRosterHash, tssConfig.forceHandoffs());
            ((CommittableWritableStates)writableHintsStates).commit();
        }
    }

    @FunctionalInterface
    public static interface StartupNetworksFactory {
        @NonNull
        public StartupNetworks apply(@NonNull ConfigProvider var1);
    }

    @FunctionalInterface
    public static interface BlockHashSignerFactory {
        @NonNull
        public BlockHashSigner apply(@NonNull HintsService var1, @NonNull HistoryService var2, @NonNull ConfigProvider var3);
    }

    @FunctionalInterface
    public static interface HintsServiceFactory {
        @NonNull
        public HintsService apply(@NonNull AppContext var1, @NonNull Configuration var2);
    }

    @FunctionalInterface
    public static interface HistoryServiceFactory {
        @NonNull
        public HistoryService apply(@NonNull AppContext var1, @NonNull Configuration var2);
    }

    private class ReadReconnectStartingStateHash
    implements ReconnectCompleteListener {
        private final NotificationEngine notifications;

        private ReadReconnectStartingStateHash(NotificationEngine notifications) {
            this.notifications = Objects.requireNonNull(notifications);
        }

        public void notify(@NonNull ReconnectCompleteNotification notification) {
            Objects.requireNonNull(notification);
            Objects.requireNonNull(Hedera.this.initialStateHashFuture).complete(Objects.requireNonNull(notification.getState().getHash()).getBytes());
            this.notifications.unregister(ReconnectCompleteListener.class, (Listener)this);
        }
    }
}

