/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.store;

import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.entityid.impl.WritableEntityIdStoreImpl;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;

public class ServiceApiFactory {
    private final State state;
    private final Configuration configuration;
    private final Map<Class<?>, ServiceApiProvider<?>> apiProviders;

    public ServiceApiFactory(@NonNull State state, @NonNull Configuration configuration, @NonNull Map<Class<?>, ServiceApiProvider<?>> apiProviders) {
        this.state = Objects.requireNonNull(state);
        this.configuration = Objects.requireNonNull(configuration);
        this.apiProviders = Objects.requireNonNull(apiProviders);
    }

    public <C> C getApi(@NonNull Class<C> apiInterface) throws IllegalArgumentException {
        Objects.requireNonNull(apiInterface);
        ServiceApiProvider<?> provider = this.apiProviders.get(apiInterface);
        if (provider != null) {
            WritableStates writableStates = this.state.getWritableStates(provider.serviceName());
            WritableEntityIdStoreImpl entityCounters = new WritableEntityIdStoreImpl(this.state.getWritableStates("EntityIdService"));
            Object api = provider.newInstance(this.configuration, writableStates, (WritableEntityCounters)entityCounters);
            assert (apiInterface.isInstance(api));
            return apiInterface.cast(api);
        }
        throw new IllegalArgumentException("No provider of the given API is available");
    }
}

