/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.utils;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoCreateTransactionBody;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class SynthTxnUtils {
    public static final long THREE_MONTHS_IN_SECONDS = 7776000L;
    public static final Duration DEFAULT_AUTO_RENEW_PERIOD = Duration.newBuilder().seconds(7776000L).build();

    private SynthTxnUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static CryptoCreateTransactionBody synthAccountCreationFromHapi(@NonNull ContractID pendingId, @Nullable Bytes evmAddress, @NonNull ContractCreateTransactionBody body) {
        Objects.requireNonNull(body);
        Objects.requireNonNull(pendingId);
        CryptoCreateTransactionBody.Builder builder = CryptoCreateTransactionBody.newBuilder().maxAutomaticTokenAssociations(body.maxAutomaticTokenAssociations()).declineReward(body.declineReward()).memo(body.memo());
        if (body.hasAutoRenewPeriod()) {
            builder.autoRenewPeriod(body.autoRenewPeriodOrThrow());
        }
        if (body.hasStakedNodeId()) {
            builder.stakedNodeId(body.stakedNodeIdOrThrow().longValue());
        } else if (body.hasStakedAccountId()) {
            builder.stakedAccountId(body.stakedAccountIdOrThrow());
        }
        if (body.hasAdminKey() && !KeyUtils.isEmpty((Key)body.adminKeyOrThrow())) {
            builder.key(body.adminKeyOrThrow());
        } else {
            builder.key(Key.newBuilder().contractID(pendingId));
        }
        if (evmAddress != null) {
            builder.alias(evmAddress);
        }
        return builder.build();
    }

    public static ContractCreateTransactionBody synthContractCreationFromParent(@NonNull ContractID pendingId, @NonNull Account parent) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(pendingId);
        ContractCreateTransactionBody.Builder builder = ContractCreateTransactionBody.newBuilder().maxAutomaticTokenAssociations(parent.maxAutoAssociations()).declineReward(parent.declineReward()).memo(parent.memo()).autoRenewPeriod(Duration.newBuilder().seconds(parent.autoRenewSeconds()));
        if (SynthTxnUtils.hasNonDegenerateAutoRenewAccountId(parent)) {
            builder.autoRenewAccountId(parent.autoRenewAccountIdOrThrow());
        }
        if (parent.hasStakedNodeId()) {
            builder.stakedNodeId(parent.stakedNodeIdOrThrow().longValue());
        } else if (parent.hasStakedAccountId()) {
            builder.stakedAccountId(parent.stakedAccountIdOrThrow());
        }
        if (!parent.hasKey() || SynthTxnUtils.isSelfAdmin(parent)) {
            builder.adminKey(Key.newBuilder().contractID(pendingId));
        } else {
            Key parentAdminKey = parent.keyOrThrow();
            builder.adminKey(parentAdminKey);
        }
        return builder.build();
    }

    public static ContractCreateTransactionBody synthContractCreationForExternalization(@NonNull ContractID pendingId) {
        Objects.requireNonNull(pendingId);
        return ContractCreateTransactionBody.newBuilder().adminKey(Key.newBuilder().contractID(pendingId).build()).build();
    }

    public static boolean hasNonDegenerateAutoRenewAccountId(@NonNull Account account) {
        return account.hasAutoRenewAccountId() && account.autoRenewAccountIdOrThrow().accountNumOrElse(Long.valueOf(0L)) != 0L;
    }

    public static CryptoCreateTransactionBody synthHollowAccountCreation(@NonNull Bytes evmAddress, boolean unlimitedAutoAssociations) {
        Objects.requireNonNull(evmAddress);
        return CryptoCreateTransactionBody.newBuilder().initialBalance(0L).alias(evmAddress).maxAutomaticTokenAssociations(unlimitedAutoAssociations ? -1 : 0).key(KeyUtils.IMMUTABILITY_SENTINEL_KEY).autoRenewPeriod(DEFAULT_AUTO_RENEW_PERIOD).build();
    }

    public static ContractCreateTransactionBody synthEthTxCreation(long autoRenewPeriod, @NonNull EthTxData ethTxData) {
        Objects.requireNonNull(ethTxData);
        return ContractCreateTransactionBody.newBuilder().gas(ethTxData.gasLimit()).initialBalance(ethTxData.effectiveTinybarValue()).autoRenewPeriod(Duration.newBuilder().seconds(autoRenewPeriod)).initcode(Bytes.wrap((byte[])ethTxData.callData())).build();
    }

    private static boolean isSelfAdmin(@NonNull Account parent) {
        long adminNum = parent.keyOrThrow().contractIDOrElse(ContractID.DEFAULT).contractNumOrElse(Long.valueOf(0L));
        return parent.accountIdOrThrow().accountNumOrThrow() == adminNum;
    }
}

