/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class DataCopyOperation
extends AbstractOperation {
    public DataCopyOperation(GasCalculator gasCalculator) {
        super(211, "DATACOPY", 3, 1, gasCalculator);
    }

    protected long cost(MessageFrame frame, long memOffset, long length) {
        return this.gasCalculator().getVeryLowTierGasCost() + this.gasCalculator().extCodeCopyOperationGasCost(frame, memOffset, length);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        int memOffset = Words.clampedToInt(frame.popStackItem());
        int sourceOffset = Words.clampedToInt(frame.popStackItem());
        int length = Words.clampedToInt(frame.popStackItem());
        long cost = this.cost(frame, memOffset, length);
        if (cost > frame.getRemainingGas()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Bytes data = code.getData(sourceOffset, length);
        frame.writeMemory((long)memOffset, length, data);
        return new Operation.OperationResult(cost, null);
    }
}

