/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.crypto;

import com.google.common.base.MoreObjects;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.CryptoUpdateTransactionBody;
import com.hederahashgraph.api.proto.java.Key;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CryptoUpdateMeta {
    private final long keyBytesUsed;
    private final long msgBytesUsed;
    private final long memoSize;
    private final long effectiveNow;
    private final long expiry;
    private final boolean hasProxy;
    private final int maxAutomaticAssociations;
    private final boolean hasMaxAutomaticAssociations;
    private final int numHookCreations;
    private final int numHookDeletions;

    public CryptoUpdateMeta(Builder builder) {
        this.keyBytesUsed = builder.keyBytesUsed;
        this.msgBytesUsed = builder.msgBytesUsed;
        this.memoSize = builder.memoSize;
        this.effectiveNow = builder.effectiveNow;
        this.expiry = builder.expiry;
        this.hasProxy = builder.hasProxy;
        this.maxAutomaticAssociations = builder.maxAutomaticAssociations;
        this.hasMaxAutomaticAssociations = builder.hasMaxAutomaticAssociations;
        this.numHookCreations = builder.numHookCreations;
        this.numHookDeletions = builder.numHookDeletions;
    }

    public CryptoUpdateMeta(CryptoUpdateTransactionBody cryptoUpdateTxnBody, long transactionValidStartSecs) {
        this.keyBytesUsed = cryptoUpdateTxnBody.hasKey() ? (long)FeeBuilder.getAccountKeyStorageSize((Key)cryptoUpdateTxnBody.getKey()) : 0L;
        this.msgBytesUsed = (long)this.bytesUsedInTxn(cryptoUpdateTxnBody) + this.keyBytesUsed;
        this.memoSize = cryptoUpdateTxnBody.hasMemo() ? (long)cryptoUpdateTxnBody.getMemo().getValueBytes().size() : 0L;
        this.effectiveNow = transactionValidStartSecs;
        this.expiry = cryptoUpdateTxnBody.getExpirationTime().getSeconds();
        this.hasProxy = cryptoUpdateTxnBody.hasProxyAccountID();
        this.hasMaxAutomaticAssociations = cryptoUpdateTxnBody.hasMaxAutomaticTokenAssociations();
        this.maxAutomaticAssociations = cryptoUpdateTxnBody.getMaxAutomaticTokenAssociations().getValue();
        this.numHookCreations = cryptoUpdateTxnBody.getHookCreationDetailsCount();
        this.numHookDeletions = cryptoUpdateTxnBody.getHookIdsToDeleteCount();
    }

    public long getMsgBytesUsed() {
        return this.msgBytesUsed;
    }

    public long getKeyBytesUsed() {
        return this.keyBytesUsed;
    }

    public long getMemoSize() {
        return this.memoSize;
    }

    public long getEffectiveNow() {
        return this.effectiveNow;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public boolean hasProxy() {
        return this.hasProxy;
    }

    public int getMaxAutomaticAssociations() {
        return this.maxAutomaticAssociations;
    }

    public boolean hasMaxAutomaticAssociations() {
        return this.hasMaxAutomaticAssociations;
    }

    public int getNumHookCreations() {
        return this.numHookCreations;
    }

    public int getNumHookDeletions() {
        return this.numHookDeletions;
    }

    private int bytesUsedInTxn(CryptoUpdateTransactionBody op) {
        return 24 + op.getMemo().getValueBytes().size() + (op.hasExpirationTime() ? 8 : 0) + (op.hasAutoRenewPeriod() ? 8 : 0) + (op.hasProxyAccountID() ? 24 : 0) + (op.hasMaxAutomaticTokenAssociations() ? 4 : 0);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keyBytesUsed", this.keyBytesUsed).add("msgBytesUsed", this.msgBytesUsed).add("memoSize", this.memoSize).add("effectiveNow", this.effectiveNow).add("expiry", this.expiry).add("hasProxy", this.hasProxy).add("maxAutomaticAssociations", this.maxAutomaticAssociations).add("hasMaxAutomaticAssociations", this.hasMaxAutomaticAssociations).toString();
    }

    public static class Builder {
        private long keyBytesUsed;
        private long msgBytesUsed;
        private long memoSize;
        private long effectiveNow;
        private long expiry;
        private boolean hasProxy;
        private int maxAutomaticAssociations;
        private boolean hasMaxAutomaticAssociations;
        private int numHookCreations;
        private int numHookDeletions;

        public Builder keyBytesUsed(long keyBytesUsed) {
            this.keyBytesUsed = keyBytesUsed;
            return this;
        }

        public Builder msgBytesUsed(long msgBytesUsed) {
            this.msgBytesUsed = msgBytesUsed;
            return this;
        }

        public Builder memoSize(long memoSize) {
            this.memoSize = memoSize;
            return this;
        }

        public Builder effectiveNow(long effectiveNow) {
            this.effectiveNow = effectiveNow;
            return this;
        }

        public Builder expiry(long expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder hasProxy(boolean hasProxy) {
            this.hasProxy = hasProxy;
            return this;
        }

        public Builder maxAutomaticAssociations(int maxAutomaticAssociations) {
            this.maxAutomaticAssociations = maxAutomaticAssociations;
            return this;
        }

        public Builder hasMaxAutomaticAssociations(boolean hasMaxAutomaticAssociations) {
            this.hasMaxAutomaticAssociations = hasMaxAutomaticAssociations;
            return this;
        }

        public Builder numHookCreations(int numHookCreations) {
            this.numHookCreations = numHookCreations;
            return this;
        }

        public Builder numHookDeletions(int numHookDeletions) {
            this.numHookDeletions = numHookDeletions;
            return this;
        }

        public CryptoUpdateMeta build() {
            return new CryptoUpdateMeta(this);
        }
    }
}

