/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import org.apache.tuweni.bytes.ArrayWrappingBytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.Checks;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes32;
import org.apache.tuweni.bytes.MutableBytes32;

final class ArrayWrappingBytes32
extends ArrayWrappingBytes
implements Bytes32 {
    ArrayWrappingBytes32(byte[] bytes) {
        this(ArrayWrappingBytes32.checkLength(bytes), 0);
    }

    ArrayWrappingBytes32(byte[] bytes, int offset) {
        super(ArrayWrappingBytes32.checkLength(bytes, offset), offset, 32);
    }

    private static byte[] checkLength(byte[] bytes) {
        Checks.checkArgument(bytes.length == 32, "Expected %s bytes but got %s", 32, bytes.length);
        return bytes;
    }

    private static byte[] checkLength(byte[] bytes, int offset) {
        Checks.checkArgument(bytes.length - offset >= 32, "Expected at least %s bytes from offset %s but got only %s", 32, offset, bytes.length - offset);
        return bytes;
    }

    @Override
    public Bytes32 copy() {
        if (this.offset == 0 && this.length == this.bytes.length) {
            return this;
        }
        return new ArrayWrappingBytes32(this.toArray());
    }

    @Override
    public MutableBytes32 mutableCopy() {
        return new MutableArrayWrappingBytes32(this.toArray());
    }
}

