/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.deterministic;

import com.swirlds.common.metrics.extensions.FractionalTimer;
import com.swirlds.common.metrics.extensions.NoOpFractionalTimer;
import com.swirlds.component.framework.model.TraceableWiringModel;
import com.swirlds.component.framework.model.internal.deterministic.DeterministicTaskScheduler;
import com.swirlds.component.framework.schedulers.ExceptionHandlers;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.schedulers.builders.internal.AbstractTaskSchedulerBuilder;
import com.swirlds.component.framework.schedulers.internal.DirectTaskScheduler;
import com.swirlds.component.framework.schedulers.internal.NoOpTaskScheduler;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;

public class DeterministicTaskSchedulerBuilder<OUT>
extends AbstractTaskSchedulerBuilder<OUT> {
    private final Consumer<Runnable> submitWork;

    public DeterministicTaskSchedulerBuilder(@NonNull Metrics metrics, @NonNull TraceableWiringModel model, @NonNull String name, @NonNull Consumer<Runnable> submitWork) {
        super(metrics, model, name, ForkJoinPool.commonPool());
        this.submitWork = Objects.requireNonNull(submitWork);
    }

    @Override
    @NonNull
    public TaskScheduler<OUT> build() {
        TaskScheduler scheduler;
        boolean insertionIsBlocking = this.unhandledTaskCapacity != -1L || this.externalBackPressure;
        AbstractTaskSchedulerBuilder.Counters counters = this.buildCounters();
        FractionalTimer busyFractionTimer = NoOpFractionalTimer.getInstance();
        switch (this.type) {
            default: {
                throw new MatchException(null, null);
            }
            case CONCURRENT: 
            case SEQUENTIAL: 
            case SEQUENTIAL_THREAD: {
                TaskScheduler taskScheduler = new DeterministicTaskScheduler(this.model, this.name, this.type, this.uncaughtExceptionHandlerOr(ExceptionHandlers.RETHROW_UNCAUGHT_EXCEPTION), counters.onRamp(), counters.offRamp(), this.unhandledTaskCapacity, this.flushingEnabled, this.squelchingEnabled, insertionIsBlocking, this.submitWork);
                break;
            }
            case DIRECT: 
            case DIRECT_THREADSAFE: {
                TaskScheduler taskScheduler = new DirectTaskScheduler(this.model, this.name, this.uncaughtExceptionHandlerOr(ExceptionHandlers.RETHROW_UNCAUGHT_EXCEPTION), counters.onRamp(), counters.offRamp(), this.squelchingEnabled, busyFractionTimer, this.type == TaskSchedulerType.DIRECT_THREADSAFE);
                break;
            }
            case NO_OP: {
                TaskScheduler taskScheduler = scheduler = new NoOpTaskScheduler(this.model, this.name, this.type, this.flushingEnabled, this.squelchingEnabled);
            }
        }
        if (this.type != TaskSchedulerType.NO_OP) {
            this.model.registerScheduler(scheduler, this.hyperlink);
        }
        return scheduler;
    }
}

