/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.monitor;

import com.swirlds.base.time.Time;
import com.swirlds.base.units.TimeUnit;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.CompareTo;

public class HealthMonitorLogger {
    private static final Logger logger = LogManager.getLogger(HealthMonitorLogger.class);
    private final Duration healthLogThreshold;
    private final Map<String, RateLimitedLogger> schedulerLoggers = new HashMap<String, RateLimitedLogger>();

    public HealthMonitorLogger(@NonNull Time time, @NonNull List<TaskScheduler<?>> schedulers, @NonNull Duration healthLogThreshold, @NonNull Duration healthLogPeriod) {
        this.healthLogThreshold = healthLogThreshold;
        for (TaskScheduler<?> scheduler : schedulers) {
            String schedulerName = scheduler.getName();
            RateLimitedLogger rateLimitedLogger = new RateLimitedLogger(logger, time, healthLogPeriod);
            this.schedulerLoggers.put(schedulerName, rateLimitedLogger);
        }
    }

    public void reportUnhealthyScheduler(@NonNull TaskScheduler<?> scheduler, @NonNull Duration unhealthyDuration) {
        if (CompareTo.isLessThan((Comparable)unhealthyDuration, (Object)this.healthLogThreshold)) {
            return;
        }
        RateLimitedLogger rateLimitedLogger = this.schedulerLoggers.get(scheduler.getName());
        String formattedDuration = TimeUnit.UNIT_NANOSECONDS.buildFormatter(unhealthyDuration.toNanos()).render();
        rateLimitedLogger.warn(LogMarker.STARTUP.getMarker(), "Task scheduler {} has been unhealthy for {}. It currently has {}/{} unhandled tasks.", new Object[]{scheduler.getName(), formattedDuration, scheduler.getUnprocessedTaskCount(), scheduler.getCapacity()});
    }
}

