/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.statistics;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicAverage {
    private static final long UNINITIALIZED_BITS = Double.doubleToLongBits(-9.223372036854776E18);
    private static final double DEFAULT_WEIGHT = 0.5;
    private static final double DEFAULT_UNINITIALIZED = 0.0;
    private final double weight;
    private final double uninitializedValue;
    private final AtomicLong average;

    public AtomicAverage(double weight, double uninitializedValue) {
        if (weight <= 0.0 || weight >= 1.0) {
            throw new IllegalArgumentException("weight must be greater than 0 and less than 1");
        }
        this.weight = weight;
        this.uninitializedValue = uninitializedValue;
        this.average = new AtomicLong(UNINITIALIZED_BITS);
    }

    public AtomicAverage(double weight) {
        this(weight, 0.0);
    }

    public AtomicAverage() {
        this(0.5);
    }

    public double get() {
        long bits = this.average.get();
        if (bits == UNINITIALIZED_BITS) {
            return this.uninitializedValue;
        }
        return Double.longBitsToDouble(bits);
    }

    public void reset() {
        this.average.set(UNINITIALIZED_BITS);
    }

    public void update(long value) {
        this.average.accumulateAndGet(value, this::updater);
    }

    private long updater(long bits, long value) {
        if (bits == UNINITIALIZED_BITS) {
            return Double.doubleToLongBits(value);
        }
        double prevAvg = Double.longBitsToDouble(bits);
        double newAvg = prevAvg * (1.0 - this.weight) + (double)value * this.weight;
        return Double.doubleToLongBits(newAvg);
    }
}

