/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.statistics.cycle;

import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.statistics.cycle.CycleMetrics;
import java.util.Arrays;

public class CycleTracker {
    private final CycleMetrics metrics;
    private final Time time;
    private final long[] duration;
    private long lastTime;
    private int intervalStarted;

    public CycleTracker(Time time, CycleMetrics metrics) {
        this.metrics = metrics;
        this.time = time;
        this.duration = new long[metrics.getNumIntervals()];
        this.lastTime = this.now();
    }

    public void startCycle() {
        Arrays.fill(this.duration, 0L);
        long now = this.now();
        this.metrics.idleTime(now - this.lastTime);
        this.lastTime = now;
        this.intervalStarted = 0;
    }

    public void intervalEnded(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Time point must be greater than 0. Use startCycle() to mark the beginning of the cycle.");
        }
        if (i >= this.metrics.getNumIntervals()) {
            throw new IllegalArgumentException(String.format("Time point must be less than %s. Use stopCycle() to mark the end of the cycle.", this.metrics.getNumIntervals() - 1));
        }
        long now = this.now();
        this.duration[i] = now - this.lastTime;
        this.lastTime = now;
        this.intervalStarted = i + 1;
        this.metrics.intervalFinished(i, this.duration[i]);
    }

    public void cycleEnded() {
        if (this.intervalStarted < this.metrics.getNumIntervals()) {
            this.intervalEnded(this.intervalStarted);
        }
        this.metrics.cycleFinished(this.duration);
    }

    private long now() {
        return this.time.nanoTime();
    }
}

