/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.statistics.cycle;

import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.metrics.api.Metrics;
import java.util.Objects;
import java.util.function.BiFunction;

public class PercentageMetric {
    private static final String APPENDIX = " (%)";
    private static final int PERCENT = 100;
    private final IntegerPairAccumulator<Double> container;

    protected PercentageMetric(Metrics metrics, String category, String name, String description, BiFunction<Integer, Integer, Double> resultFunction) {
        Objects.requireNonNull(name, "name must not be null");
        this.container = (IntegerPairAccumulator)metrics.getOrCreate(new IntegerPairAccumulator.Config<Double>(category, name + APPENDIX, Double.class, resultFunction).withDescription(description).withFormat("%,3.1f"));
    }

    protected PercentageMetric(Metrics metrics, String category, String name, String description) {
        this(metrics, category, name, description, PercentageMetric::calculatePercentage);
    }

    protected void update(int leftValue, int rightValue) {
        this.container.update(leftValue, rightValue);
    }

    public static double calculatePercentage(int total, int part) {
        if (total == 0) {
            return 0.0;
        }
        return (double)part / (double)total * 100.0;
    }

    public double get() {
        return this.container.get();
    }
}

