/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.statistics.simple;

import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.metrics.api.Metrics;

public class AccumulatedAverageTime {
    private static final String UNIT_APPENDIX = " (ms)";
    private final IntegerPairAccumulator<Double> accumulator;

    public AccumulatedAverageTime(Metrics metrics, String category, String name, String description) {
        this.accumulator = (IntegerPairAccumulator)metrics.getOrCreate(new IntegerPairAccumulator.Config<Double>(category, name + UNIT_APPENDIX, Double.class, AccumulatedAverageTime::averageMillis).withDescription(description).withFormat("%,10.6f"));
    }

    public void add(long nanoTime) {
        this.accumulator.update((int)((double)nanoTime * 0.001), 1);
    }

    public double get() {
        return this.accumulator.get();
    }

    private static double averageMillis(int sum, int count) {
        if (count == 0) {
            return 0.0;
        }
        return (double)sum / (double)count * 0.001;
    }
}

