/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.rules;

import com.swirlds.base.time.Time;
import com.swirlds.common.utility.throttle.RateLimiter;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.event.creator.config.EventCreationConfig;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;

public class MaximumRateRule
implements EventCreationRule {
    private final RateLimiter rateLimiter;

    public MaximumRateRule(@NonNull Configuration configuration, @NonNull Time time) {
        EventCreationConfig eventCreationConfig = (EventCreationConfig)configuration.getConfigData(EventCreationConfig.class);
        double maxCreationRate = eventCreationConfig.maxCreationRate();
        this.rateLimiter = maxCreationRate > 0.0 ? new RateLimiter(time, maxCreationRate) : null;
    }

    @Override
    public boolean isEventCreationPermitted() {
        if (this.rateLimiter != null) {
            return this.rateLimiter.request();
        }
        return true;
    }

    @Override
    public void eventWasCreated() {
        if (this.rateLimiter != null) {
            this.rateLimiter.trigger();
        }
    }

    @Override
    @NonNull
    public EventCreationStatus getEventCreationStatus() {
        return EventCreationStatus.RATE_LIMITED;
    }
}

