/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.intake.impl.validation;

import com.hedera.hapi.platform.event.EventCore;
import com.hedera.hapi.platform.event.EventDescriptor;
import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.DigestType;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.event.intake.impl.validation.InternalEventValidator;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.transaction.Transaction;
import org.hiero.consensus.transaction.TransactionLimits;

public class DefaultInternalEventValidator
implements InternalEventValidator {
    private static final Logger logger = LogManager.getLogger(DefaultInternalEventValidator.class);
    private static final Duration MINIMUM_LOG_PERIOD = Duration.ofMinutes(1L);
    private final IntakeEventCounter intakeEventCounter;
    private final TransactionLimits transactionLimits;
    private final RateLimitedLogger nullFieldLogger;
    private final RateLimitedLogger fieldLengthLogger;
    private final RateLimitedLogger tooManyTransactionBytesLogger;
    private final RateLimitedLogger invalidParentsLogger;
    private final RateLimitedLogger invalidBirthRoundLogger;
    private final LongAccumulator nullFieldAccumulator;
    private final LongAccumulator fieldLengthAccumulator;
    private final LongAccumulator tooManyTransactionBytesAccumulator;
    private final LongAccumulator invalidParentsAccumulator;
    private final LongAccumulator invalidBirthRoundAccumulator;

    public DefaultInternalEventValidator(@NonNull Metrics metrics, @NonNull Time time, @NonNull IntakeEventCounter intakeEventCounter, @NonNull TransactionLimits transactionLimits) {
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.transactionLimits = Objects.requireNonNull(transactionLimits);
        this.nullFieldLogger = new RateLimitedLogger(logger, time, MINIMUM_LOG_PERIOD);
        this.fieldLengthLogger = new RateLimitedLogger(logger, time, MINIMUM_LOG_PERIOD);
        this.tooManyTransactionBytesLogger = new RateLimitedLogger(logger, time, MINIMUM_LOG_PERIOD);
        this.invalidParentsLogger = new RateLimitedLogger(logger, time, MINIMUM_LOG_PERIOD);
        this.invalidBirthRoundLogger = new RateLimitedLogger(logger, time, MINIMUM_LOG_PERIOD);
        this.nullFieldAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "eventsWithNullFields").withDescription("Events that had a null field").withUnit("events"));
        this.fieldLengthAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "eventsWithInvalidFieldLength").withDescription("Events with an invalid field length").withUnit("events"));
        this.tooManyTransactionBytesAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "eventsWithTooManyTransactionBytes").withDescription("Events that had more transaction bytes than permitted").withUnit("events"));
        this.invalidParentsAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "eventsWithInvalidParents").withDescription("Events that have invalid parents").withUnit("events"));
        this.invalidBirthRoundAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "eventsWithInvalidBirthRound").withDescription("Events with an invalid birth round").withUnit("events"));
    }

    private boolean areRequiredFieldsNonNull(@NonNull PlatformEvent event) {
        GossipEvent gossipEvent = event.getGossipEvent();
        EventCore eventCore = gossipEvent.eventCore();
        String nullField = null;
        if (eventCore == null) {
            nullField = "eventCore";
        } else if (eventCore.timeCreated() == null) {
            nullField = "timeCreated";
        } else if (gossipEvent.parents().stream().anyMatch(Objects::isNull)) {
            nullField = "parent";
        } else if (gossipEvent.transactions().stream().anyMatch(DefaultInternalEventValidator::isTransactionNull)) {
            nullField = "transaction";
        }
        if (nullField != null) {
            this.nullFieldLogger.error(LogMarker.EXCEPTION.getMarker(), "Event has null field '{}' {}", new Object[]{nullField, gossipEvent});
            this.nullFieldAccumulator.update(1L);
            return false;
        }
        return true;
    }

    private static boolean isTransactionNull(@Nullable Bytes transaction) {
        return transaction == null || transaction.length() == 0L;
    }

    private boolean areByteFieldsCorrectLength(@NonNull PlatformEvent event) {
        GossipEvent gossipEvent = event.getGossipEvent();
        if (gossipEvent.parents().stream().map(EventDescriptor::hash).anyMatch(hash -> hash.length() != (long)DigestType.SHA_384.digestLength())) {
            this.fieldLengthLogger.error(LogMarker.EXCEPTION.getMarker(), "Event parent descriptor has a hash that is the wrong length {}", new Object[]{gossipEvent});
            this.fieldLengthAccumulator.update(1L);
            return false;
        }
        return true;
    }

    private boolean isTransactionByteCountValid(@NonNull PlatformEvent event) {
        long totalTransactionBytes = 0L;
        Iterator iterator = event.transactionIterator();
        while (iterator.hasNext()) {
            totalTransactionBytes += ((Transaction)iterator.next()).getSize();
        }
        if (totalTransactionBytes > (long)this.transactionLimits.maxTransactionBytesPerEvent()) {
            this.tooManyTransactionBytesLogger.error(LogMarker.EXCEPTION.getMarker(), "Event %s has %s transaction bytes, which is more than permitted".formatted(event, totalTransactionBytes), new Object[0]);
            this.tooManyTransactionBytesAccumulator.update(1L);
            return false;
        }
        return true;
    }

    private boolean areParentsFromUniqueCreators(@NonNull PlatformEvent event) {
        long numUniqueParentCreators = event.getAllParents().stream().map(EventDescriptorWrapper::creator).distinct().count();
        if (numUniqueParentCreators < (long)event.getAllParents().size()) {
            this.invalidParentsAccumulator.update(1L);
            this.invalidParentsLogger.error(LogMarker.EXCEPTION.getMarker(), "Event {} has multiple parents from the same creator: {}", new Object[]{event.getDescriptor(), event.getAllParents()});
            return false;
        }
        return true;
    }

    private boolean isEventBirthRoundValid(@NonNull PlatformEvent event) {
        long eventBirthRound = event.getDescriptor().eventDescriptor().birthRound();
        long maxParentBirthRound = 0L;
        for (EventDescriptorWrapper parent : event.getAllParents()) {
            maxParentBirthRound = Math.max(maxParentBirthRound, parent.eventDescriptor().birthRound());
        }
        if (eventBirthRound < maxParentBirthRound) {
            this.invalidBirthRoundLogger.error(LogMarker.EXCEPTION.getMarker(), "Event %s has an invalid birth round that is less than the max of its parents. Event birth round: %s, the max of all parent birth rounds is: %s".formatted(event, eventBirthRound, maxParentBirthRound), new Object[0]);
            this.invalidBirthRoundAccumulator.update(1L);
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public PlatformEvent validateEvent(@NonNull PlatformEvent event) {
        if (this.areRequiredFieldsNonNull(event) && this.areByteFieldsCorrectLength(event) && this.isTransactionByteCountValid(event) && this.areParentsFromUniqueCreators(event) && this.isEventBirthRoundValid(event)) {
            return event;
        }
        this.intakeEventCounter.eventExitedIntakePipeline(event.getSenderId());
        return null;
    }
}

