/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class TLoadOperation
extends AbstractOperation {
    public TLoadOperation(GasCalculator gasCalculator) {
        super(92, "TLOAD", 1, 1, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long cost = this.gasCalculator().getTransientLoadOperationGasCost();
        try {
            UInt256 slot = UInt256.fromBytes((Bytes)frame.popStackItem());
            if (frame.getRemainingGas() < cost) {
                return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            frame.pushStackItem((Bytes)frame.getTransientStorageValue(frame.getRecipientAddress(), (Bytes32)slot));
            return new Operation.OperationResult(cost, null);
        }
        catch (UnderflowException ufe) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        }
    }
}

