/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing;

import io.helidon.common.Builder;
import io.helidon.common.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.TracerProviderHelper;
import java.net.URI;
import java.util.Objects;

@Configured(description="Tracer configuration.", ignoreBuildMethod=true)
public interface TracerBuilder<T extends TracerBuilder<T>>
extends Builder<T, Tracer> {
    public static TracerBuilder<?> create(String serviceName) {
        return TracerProviderHelper.findTracerBuilder().serviceName(serviceName);
    }

    public static TracerBuilder<?> create(Config config) {
        return TracerProviderHelper.findTracerBuilder().config(config);
    }

    @ConfiguredOption(key="service")
    public T serviceName(String var1);

    default public T collectorUri(URI uri) {
        Objects.requireNonNull(uri);
        TracerBuilder<T> result = (TracerBuilder)this.identity();
        if (null != uri.getScheme()) {
            result = result.collectorProtocol(uri.getScheme());
        }
        if (null != uri.getHost()) {
            result = result.collectorHost(uri.getHost());
        }
        if (null != uri.getPath()) {
            result = result.collectorPath(uri.getPath());
        }
        if (uri.getPort() >= -1) {
            result = result.collectorPort(uri.getPort());
        }
        return (T)result;
    }

    @ConfiguredOption(key="protocol")
    public T collectorProtocol(String var1);

    @ConfiguredOption(key="port")
    public T collectorPort(int var1);

    @ConfiguredOption(key="host")
    public T collectorHost(String var1);

    @ConfiguredOption(key="path")
    public T collectorPath(String var1);

    @ConfiguredOption(key="tags", kind=ConfiguredOption.Kind.MAP, type=String.class)
    public T addTracerTag(String var1, String var2);

    @ConfiguredOption(key="int-tags", kind=ConfiguredOption.Kind.MAP, type=Integer.class)
    public T addTracerTag(String var1, Number var2);

    @ConfiguredOption(key="boolean-tags", kind=ConfiguredOption.Kind.MAP, type=Boolean.class)
    public T addTracerTag(String var1, boolean var2);

    public T config(Config var1);

    @ConfiguredOption(value="true")
    public T enabled(boolean var1);

    @ConfiguredOption(key="global", value="true")
    public T registerGlobal(boolean var1);

    public <B> B unwrap(Class<B> var1);
}

