/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import com.hedera.node.app.blocks.impl.streaming.config.BlockNodeConfiguration;
import com.hedera.pbj.grpc.client.helidon.PbjGrpcClient;
import com.hedera.pbj.grpc.client.helidon.PbjGrpcClientConfig;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.grpc.GrpcClientProtocolConfig;
import io.helidon.webclient.http2.Http2ClientProtocolConfig;
import io.helidon.webclient.spi.ProtocolConfig;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.hiero.block.api.BlockNodeServiceInterface;
import org.hiero.block.api.BlockStreamPublishServiceInterface;

public class BlockNodeClientFactory {
    private PbjGrpcClient buildPbjClient(@NonNull BlockNodeConfiguration config, @NonNull Duration timeout) {
        Objects.requireNonNull(config, "config is required");
        Objects.requireNonNull(timeout, "timeout is required");
        Tls tls = ((TlsConfig.Builder)Tls.builder().enabled(false)).build();
        PbjGrpcClientConfig pbjConfig = new PbjGrpcClientConfig(timeout, tls, Optional.of(""), "application/grpc");
        Http2ClientProtocolConfig httpConfig = config.clientHttpConfig().toHttp2ClientProtocolConfig();
        GrpcClientProtocolConfig grpcConfig = config.clientGrpcConfig().toGrpcClientProtocolConfig();
        WebClient webClient = ((WebClientConfig.Builder)((WebClientConfig.Builder)((WebClientConfig.Builder)((WebClientConfig.Builder)((WebClientConfig.Builder)WebClient.builder().baseUri("http://" + config.address() + ":" + config.port())).tls(tls)).addProtocolConfig((ProtocolConfig)httpConfig)).addProtocolConfig((ProtocolConfig)grpcConfig)).connectTimeout(timeout)).build();
        return new PbjGrpcClient(webClient, pbjConfig);
    }

    public BlockStreamPublishServiceInterface.BlockStreamPublishServiceClient createStreamingClient(@NonNull BlockNodeConfiguration config, @NonNull Duration timeout) {
        PbjGrpcClient client = this.buildPbjClient(config, timeout);
        return new BlockStreamPublishServiceInterface.BlockStreamPublishServiceClient((GrpcClient)client, (ServiceInterface.RequestOptions)new DefaultRequestOptions());
    }

    public BlockNodeServiceInterface.BlockNodeServiceClient createServiceClient(@NonNull BlockNodeConfiguration config, @NonNull Duration timeout) {
        PbjGrpcClient client = this.buildPbjClient(config, timeout);
        return new BlockNodeServiceInterface.BlockNodeServiceClient((GrpcClient)client, (ServiceInterface.RequestOptions)new DefaultRequestOptions());
    }

    private static class DefaultRequestOptions
    implements ServiceInterface.RequestOptions {
        private DefaultRequestOptions() {
        }

        @NonNull
        public Optional<String> authority() {
            return Optional.empty();
        }

        @NonNull
        public String contentType() {
            return "application/grpc";
        }
    }
}

