/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.services;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.NodePayment;
import com.hedera.hapi.node.state.token.NodePayments;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.entityid.impl.WritableEntityIdStoreImpl;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.impl.ReadableNodePaymentsStoreImpl;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNodePaymentsStore;
import com.hedera.node.app.service.token.impl.schemas.V0700TokenSchema;
import com.hedera.node.app.spi.fees.NodeFeeAccumulator;
import com.hedera.node.app.workflows.handle.record.SystemTransactions;
import com.hedera.node.app.workflows.handle.steps.StakePeriodChanges;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.NodesConfig;
import com.hedera.node.config.data.StakingConfig;
import com.swirlds.state.State;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class NodeFeeManager
implements NodeFeeAccumulator {
    private static final Logger log = LogManager.getLogger(NodeFeeManager.class);
    private final EntityIdFactory entityIdFactory;
    private final ConfigProvider configProvider;
    private final Map<AccountID, Long> nodeFees = new LinkedHashMap<AccountID, Long>();

    @Inject
    public NodeFeeManager(@NonNull ConfigProvider configProvider, @NonNull EntityIdFactory entityIdFactory) {
        this.configProvider = configProvider;
        this.entityIdFactory = entityIdFactory;
    }

    public void onOpenBlock(@NonNull State state) {
        if (((NodesConfig)this.configProvider.getConfiguration().getConfigData(NodesConfig.class)).feeCollectionAccountEnabled()) {
            this.resetNodeFees();
            ReadableSingletonState nodePaymentsState = Objects.requireNonNull(state.getReadableStates("TokenService").getSingleton(V0700TokenSchema.NODE_PAYMENTS_STATE_ID));
            NodePayments nodePayments = Objects.requireNonNull((NodePayments)nodePaymentsState.get());
            nodePayments.payments().forEach(pair -> this.nodeFees.put(pair.nodeAccountId(), pair.fees()));
            log.debug("Loaded node payments from state: {}", (Object)nodePayments);
        }
    }

    public void onCloseBlock(@NonNull State state) {
        if (((NodesConfig)this.configProvider.getConfiguration().getConfigData(NodesConfig.class)).feeCollectionAccountEnabled()) {
            this.updateNodePaymentsState(state);
        }
    }

    public void accumulate(AccountID nodeAccountId, long fees) {
        this.nodeFees.merge(nodeAccountId, fees, Long::sum);
    }

    public void resetNodeFees() {
        this.nodeFees.clear();
    }

    private LastNodeFeesPaymentTime classifyLastNodeFeesPaymentTime(@NonNull State state, @NonNull Instant now) {
        ReadableNodePaymentsStoreImpl nodeFeePaymentsStore = new ReadableNodePaymentsStoreImpl(state.getReadableStates("TokenService"));
        Timestamp lastPaidTime = nodeFeePaymentsStore.get().lastNodeFeeDistributionTime();
        if (lastPaidTime == null) {
            return LastNodeFeesPaymentTime.NEVER;
        }
        long stakePeriodMins = ((StakingConfig)this.configProvider.getConfiguration().getConfigData(StakingConfig.class)).periodMins();
        boolean isNextPeriod = StakePeriodChanges.isNextStakingPeriod(now, HapiUtils.asInstant((Timestamp)lastPaidTime), stakePeriodMins);
        return isNextPeriod ? LastNodeFeesPaymentTime.PREVIOUS_PERIOD : LastNodeFeesPaymentTime.CURRENT_PERIOD;
    }

    public boolean distributeFees(@NonNull State state, @NonNull Instant now, @NonNull SystemTransactions systemTransactions) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(now);
        Objects.requireNonNull(systemTransactions);
        NodesConfig nodesConfig = (NodesConfig)this.configProvider.getConfiguration().getConfigData(NodesConfig.class);
        if (!nodesConfig.feeCollectionAccountEnabled()) {
            return false;
        }
        AccountsConfig accountsConfig = (AccountsConfig)this.configProvider.getConfiguration().getConfigData(AccountsConfig.class);
        LedgerConfig ledgerConfig = (LedgerConfig)this.configProvider.getConfiguration().getConfigData(LedgerConfig.class);
        StakingConfig stakingConfig = (StakingConfig)this.configProvider.getConfiguration().getConfigData(StakingConfig.class);
        LastNodeFeesPaymentTime lastNodeFeesPaymentTime = this.classifyLastNodeFeesPaymentTime(state, now);
        if (lastNodeFeesPaymentTime == LastNodeFeesPaymentTime.CURRENT_PERIOD) {
            return false;
        }
        WritableStates writableTokenStates = state.getWritableStates("TokenService");
        WritableEntityIdStoreImpl entityIdStore = new WritableEntityIdStoreImpl(state.getWritableStates("EntityIdService"));
        WritableNodePaymentsStore nodePaymentsStore = new WritableNodePaymentsStore(writableTokenStates);
        if (lastNodeFeesPaymentTime == LastNodeFeesPaymentTime.PREVIOUS_PERIOD) {
            log.info("Considering distributing node fees for staking period @ {}", (Object)HapiUtils.asTimestamp((Instant)now));
            this.updateNodePaymentsState(state);
            WritableAccountStore accountStore = new WritableAccountStore(writableTokenStates, (WritableEntityCounters)entityIdStore);
            AccountID feeCollectionAccountId = this.entityIdFactory.newAccountId(accountsConfig.feeCollectionAccount());
            Account feeCollectionAccount = Objects.requireNonNull(accountStore.getAccountById(feeCollectionAccountId));
            long feeCollectionBalance = feeCollectionAccount.tinybarBalance();
            ArrayList<AccountAmount> transferAmounts = new ArrayList<AccountAmount>();
            long totalNodeFees = 0L;
            for (NodePayment payment : Objects.requireNonNull(nodePaymentsStore.get()).payments()) {
                Account nodeAccount = accountStore.getAccountById(payment.nodeAccountId());
                long nodeFee = payment.fees();
                if (nodeAccount != null && !nodeAccount.deleted()) {
                    if (nodeFee <= 0L) continue;
                    transferAmounts.add(AccountAmount.newBuilder().accountID(payment.nodeAccountId()).amount(nodeFee).build());
                    totalNodeFees += nodeFee;
                    log.info("Node account {} will receive {} tinybars", (Object)payment.nodeAccountId(), (Object)nodeFee);
                    continue;
                }
                log.info("Node account {} is deleted or doesn't exist, forfeiting {} tinybars", (Object)payment.nodeAccountId(), (Object)nodeFee);
            }
            if (totalNodeFees > feeCollectionBalance) {
                throw new IllegalStateException("Possibly CATASTROPHIC failureTotal node fees to be distributed" + totalNodeFees + " exceeds fee collection balance " + feeCollectionBalance);
            }
            long networkServiceFees = feeCollectionBalance - totalNodeFees;
            AccountID fundingAccountId = this.entityIdFactory.newAccountId(ledgerConfig.fundingAccount());
            AccountID stakingRewardAccountId = this.entityIdFactory.newAccountId(accountsConfig.stakingRewardAccount());
            AccountID nodeRewardAccountId = this.entityIdFactory.newAccountId(accountsConfig.nodeRewardAccount());
            if (networkServiceFees > 0L) {
                this.updateNetworkAndServiceTransferAmounts(networkServiceFees, fundingAccountId, stakingRewardAccountId, nodeRewardAccountId, (ReadableAccountStore)accountStore, transferAmounts, nodesConfig, stakingConfig);
            }
            if (!transferAmounts.isEmpty()) {
                long totalDistributed = transferAmounts.stream().mapToLong(AccountAmount::amount).sum();
                transferAmounts.add(AccountAmount.newBuilder().accountID(feeCollectionAccountId).amount(-totalDistributed).build());
                log.info("Distributing {} tinybars from fee collection account: {} as node fees, {} to network/service accounts", (Object)feeCollectionBalance, (Object)totalNodeFees, (Object)networkServiceFees);
            }
            systemTransactions.dispatchNodePayments(state, now, TransferList.newBuilder().accountAmounts(transferAmounts).build());
        }
        nodePaymentsStore.resetForNewStakingPeriod(HapiUtils.asTimestamp((Instant)now));
        this.resetNodeFees();
        ((CommittableWritableStates)writableTokenStates).commit();
        return true;
    }

    private void updateNetworkAndServiceTransferAmounts(long amount, @NonNull AccountID fundingAccountId, @NonNull AccountID stakingRewardAccountId, @NonNull AccountID nodeRewardAccountId, @NonNull ReadableAccountStore accountStore, @NonNull ArrayList<AccountAmount> transferAmounts, @NonNull NodesConfig nodesConfig, @NonNull StakingConfig stakingConfig) {
        boolean preservingRewardBalance;
        long balance = amount;
        Account nodeRewardAccount = Objects.requireNonNull(accountStore.getAccountById(nodeRewardAccountId));
        boolean bl = preservingRewardBalance = nodesConfig.nodeRewardsEnabled() && nodesConfig.preserveMinNodeRewardBalance();
        if (preservingRewardBalance && nodeRewardAccount.tinybarBalance() <= nodesConfig.minNodeRewardBalance()) {
            transferAmounts.add(AccountAmount.newBuilder().accountID(nodeRewardAccountId).amount(balance).build());
            log.info("Routing all {} tinybars to node reward account (below minimum balance)", (Object)balance);
            return;
        }
        long nodeReward = (long)stakingConfig.feesNodeRewardPercentage() * amount / 100L;
        balance -= nodeReward;
        if (nodeReward > 0L) {
            transferAmounts.add(AccountAmount.newBuilder().accountID(nodeRewardAccountId).amount(nodeReward).build());
        }
        long stakingReward = (long)stakingConfig.feesStakingRewardPercentage() * amount / 100L;
        balance -= stakingReward;
        if (stakingReward > 0L) {
            transferAmounts.add(AccountAmount.newBuilder().accountID(stakingRewardAccountId).amount(stakingReward).build());
        }
        if (balance > 0L) {
            transferAmounts.add(AccountAmount.newBuilder().accountID(fundingAccountId).amount(balance).build());
        }
    }

    private void updateNodePaymentsState(@NonNull State state) {
        WritableStates writableTokenState = state.getWritableStates("TokenService");
        WritableSingletonState nodePaymentsState = writableTokenState.getSingleton(V0700TokenSchema.NODE_PAYMENTS_STATE_ID);
        NodePayments currentPayments = Objects.requireNonNull((NodePayments)nodePaymentsState.get());
        List<NodePayment> updatedPayments = this.nodeFees.entrySet().stream().map(entry -> NodePayment.newBuilder().nodeAccountId((AccountID)entry.getKey()).fees(((Long)entry.getValue()).longValue()).build()).sorted((a, b) -> Long.compare(a.nodeAccountId().accountNum(), b.nodeAccountId().accountNum())).toList();
        nodePaymentsState.put((Object)currentPayments.copyBuilder().payments(updatedPayments).build());
        ((CommittableWritableStates)writableTokenState).commit();
        log.debug("Committed node payments state with {}", updatedPayments);
        this.resetNodeFees();
    }

    static enum LastNodeFeesPaymentTime {
        NEVER,
        PREVIOUS_PERIOD,
        CURRENT_PERIOD;

    }
}

