/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.statistics;

import com.swirlds.common.metrics.StatEntry;
import com.swirlds.common.metrics.statistics.AtomicAverage;
import com.swirlds.metrics.api.Metrics;
import java.time.temporal.ChronoUnit;

public class AverageTimeStat {
    private static final String FORMAT_DEFAULT = "%,10.3f";
    private static final String FORMAT_SECONDS = "%,5.4f";
    private static final String FORMAT_MILLIS = "%,10.1f";
    private final ChronoUnit unit;
    private final AtomicAverage average;
    private final StatEntry avgEntry;

    public AverageTimeStat(Metrics metrics, ChronoUnit unit, String category, String name, String desc) {
        this(metrics, unit, category, name, desc, 0.01);
    }

    public AverageTimeStat(Metrics metrics, ChronoUnit unit, String category, String name, String desc, double weight) {
        this.unit = unit;
        this.average = new AtomicAverage(weight);
        this.avgEntry = (StatEntry)metrics.getOrCreate(new StatEntry.Config<Double>(category, name, Double.class, this::getAvg).withDescription(desc).withFormat(switch (unit) {
            case ChronoUnit.MILLIS -> FORMAT_MILLIS;
            case ChronoUnit.SECONDS -> FORMAT_SECONDS;
            default -> FORMAT_DEFAULT;
        }).withReset(this::resetAvg));
    }

    private double convert(double nanos) {
        return nanos / (double)this.unit.getDuration().toNanos();
    }

    private double getAvg() {
        return this.convert(this.average.get());
    }

    private void resetAvg(double unused) {
        this.average.reset();
    }

    public void update(long startTime) {
        this.update(startTime, System.nanoTime());
    }

    public void update(long start, long end) {
        long nanos = end - start;
        this.average.update(nanos);
    }

    public StatEntry getAverageStat() {
        return this.avgEntry;
    }
}

