/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.statistics;

import com.swirlds.common.metrics.StatEntry;
import java.util.Arrays;
import java.util.function.Supplier;
import org.hiero.base.UniqueId;

public class StatConstructor {
    private static final int NO_VALUE = 0;

    public static <T extends Enum<T>> StatEntry.Config<Integer> createEnumStat(String name, String category, T[] enumValues, Supplier<T> enumSupplier) {
        if (Arrays.stream(enumValues).anyMatch(v -> ((UniqueId)v).getId() == 0)) {
            throw new IllegalArgumentException("Unique ID must not be equal to 0");
        }
        StringBuilder desc = new StringBuilder();
        desc.append(0).append('=').append("NO_VALUE").append(' ');
        Arrays.stream(enumValues).forEach(v -> desc.append(((UniqueId)v).getId()).append('=').append(v.name()).append(' '));
        Supplier<Integer> statValueSupplier = () -> {
            Enum t = (Enum)enumSupplier.get();
            if (t == null) {
                return 0;
            }
            return ((UniqueId)t).getId();
        };
        return new StatEntry.Config<Integer>(category, name, Integer.class, statValueSupplier).withDescription(desc.toString()).withFormat("%d");
    }
}

