/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.statistics.cycle;

import com.swirlds.base.utility.Pair;
import java.util.List;
import java.util.stream.Collectors;

public class CycleDefinition {
    private final String category;
    private final String name;
    private final List<String> intervalNames;
    private final List<String> intervalDesc;
    private final int numIntervals;

    public CycleDefinition(String category, String name, List<String> intervalNames, List<String> intervalDescriptions) {
        if (intervalNames.isEmpty()) {
            throw new IllegalArgumentException("The number of intervals must be at least 1.");
        }
        if (intervalNames.size() != intervalDescriptions.size()) {
            throw new IllegalArgumentException(String.format("The number of descriptions for %s (%d) does not match the number of names (%d).", name, intervalNames.size(), intervalDescriptions.size()));
        }
        this.category = category;
        this.name = name;
        this.intervalNames = intervalNames;
        this.intervalDesc = intervalDescriptions;
        this.numIntervals = intervalNames.size();
    }

    public CycleDefinition(String category, String name, List<Pair<String, String>> namesAndDescriptions) {
        this(category, name, namesAndDescriptions.stream().map(Pair::left).collect(Collectors.toList()), namesAndDescriptions.stream().map(Pair::right).collect(Collectors.toList()));
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public String getIntervalName(int index) {
        return this.intervalNames.get(index);
    }

    public String getDisplayName(int index) {
        return this.name + "-" + this.getIntervalName(index);
    }

    public String getIntervalDescription(int index) {
        return this.intervalDesc.get(index);
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }
}

