/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.metrics;

import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.metrics.statistics.AverageAndMax;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.internal.EventImpl;
import com.swirlds.platform.metrics.ConsensusMetrics;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.hiero.consensus.model.node.NodeId;

public class ConsensusMetricsImpl
implements ConsensusMetrics {
    private static final RunningAverageMetric.Config AVG_JUDGES_WEIGHT_CONFIG = new RunningAverageMetric.Config("platform", "judgesWeight").withDescription("weight of judges of rounds").withFormat("%,10.3f");
    private final RunningAverageMetric avgJudgesWeight;
    private static final RunningAverageMetric.Config AVG_FIRST_EVENT_IN_ROUND_RECEIVED_TIME_CONFIG = new RunningAverageMetric.Config("platform", "secR2nR").withDescription("time from first event received in one round, to first event received in the next round (in seconds)").withFormat("%,10.3f");
    private final RunningAverageMetric avgFirstEventInRoundReceivedTime;
    private static final RunningAverageMetric.Config NUM_COIN_ROUNDS_CONFIG = new RunningAverageMetric.Config("internal", "coinR").withDescription("number of coin rounds that have occurred so far").withFormat("%,10.0f");
    private final RunningAverageMetric numCoinRounds;
    private static final RunningAverageMetric.Config AVG_RECEIVED_FAMOUS_TIME_CONFIG = new RunningAverageMetric.Config("platform", "secR2F").withDescription("time from a round's first received event to all the famous witnesses being known (in seconds)").withFormat("%,10.3f");
    private final RunningAverageMetric avgReceivedFamousTime;
    private static final SpeedometerMetric.Config ROUNDS_PER_SECOND_CONFIG = new SpeedometerMetric.Config("platform", "rounds_per_sec").withDescription("average number of rounds per second");
    private final SpeedometerMetric roundsPerSecond;
    private static final RunningAverageMetric.Config AVG_CREATED_CONSENSUS_TIME_CONFIG = new RunningAverageMetric.Config("platform", "secC2C").withDescription("time from creating an event to knowing its consensus (in seconds)").withFormat("%,10.3f");
    private final RunningAverageMetric avgCreatedConsensusTime;
    private static final RunningAverageMetric.Config AVG_RECEIVED_CONSENSUS_TIME_CONFIG = new RunningAverageMetric.Config("platform", "secR2C").withDescription("time from receiving an event to knowing its consensus (in seconds)").withFormat("%,10.3f");
    private final RunningAverageMetric avgReceivedConsensusTime;
    private static final RunningAverageMetric.Config AVG_CREATED_RECEIVED_CONSENSUS_TIME_CONFIG = new RunningAverageMetric.Config("platform", "secC2RC").withDescription("time from another member creating an event to it being received and knowing consensus for it (in seconds)").withFormat("%,10.3f");
    private final RunningAverageMetric avgCreatedReceivedConsensusTime;
    private static final RunningAverageMetric.Config AVG_SELF_CREATED_TIMESTAMP_CONFIG = new RunningAverageMetric.Config("internal", "secSC2T").withDescription("self event consensus timestamp minus time created (in seconds)").withFormat("%,10.3f");
    private final RunningAverageMetric avgSelfCreatedTimestamp;
    private static final RunningAverageMetric.Config AVG_OTHER_RECEIVED_TIMESTAMP_CONFIG = new RunningAverageMetric.Config("internal", "secOR2T").withDescription("other event consensus timestamp minus time received (in seconds)").withFormat("%,10.3f");
    private final RunningAverageMetric avgOtherReceivedTimestamp;
    private static final SpeedometerMetric.Config TIME_FRAC_DOT_CONFIG = new SpeedometerMetric.Config("internal", "timeFracDot").withDescription("fraction of each second spent on dot products").withFormat("%,9.6f");
    private final SpeedometerMetric timeFracDot;
    private final AverageAndMax witnessesSeen;
    private static final Counter.Config ROUND_INCREMENT_STRONGLY_SEEN_CONFIG = new Counter.Config("internal", "roundIncEqParents");
    private final Counter roundIncrementedByStronglySeen;
    private final NodeId selfId;
    private static volatile Instant firstEventInLastRoundTime = null;
    private static volatile long lastRoundNumber = -1L;

    public ConsensusMetricsImpl(NodeId selfId, Metrics metrics) {
        this.selfId = Objects.requireNonNull(selfId, "selfId must not be null");
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.avgJudgesWeight = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_JUDGES_WEIGHT_CONFIG);
        this.avgFirstEventInRoundReceivedTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_FIRST_EVENT_IN_ROUND_RECEIVED_TIME_CONFIG);
        this.numCoinRounds = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)NUM_COIN_ROUNDS_CONFIG);
        this.avgReceivedFamousTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_RECEIVED_FAMOUS_TIME_CONFIG);
        this.roundsPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)ROUNDS_PER_SECOND_CONFIG);
        this.avgCreatedConsensusTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_CREATED_CONSENSUS_TIME_CONFIG);
        this.avgReceivedConsensusTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_RECEIVED_CONSENSUS_TIME_CONFIG);
        this.avgCreatedReceivedConsensusTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_CREATED_RECEIVED_CONSENSUS_TIME_CONFIG);
        this.avgSelfCreatedTimestamp = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SELF_CREATED_TIMESTAMP_CONFIG);
        this.avgOtherReceivedTimestamp = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_OTHER_RECEIVED_TIMESTAMP_CONFIG);
        this.timeFracDot = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)TIME_FRAC_DOT_CONFIG);
        this.witnessesSeen = new AverageAndMax(metrics, "internal", "witnessesSeen", "number of witnesses seen by an event added to the hashgraph when both parents have the same round created", "%,4.2f");
        this.roundIncrementedByStronglySeen = (Counter)metrics.getOrCreate((MetricConfig)ROUND_INCREMENT_STRONGLY_SEEN_CONFIG);
    }

    @Override
    public void addedEvent(EventImpl event) {
        if (!Objects.equals(this.selfId, event.getCreatorId()) && event.getRoundCreated() > lastRoundNumber) {
            Instant now = Instant.now();
            if (firstEventInLastRoundTime != null) {
                this.avgFirstEventInRoundReceivedTime.update((double)firstEventInLastRoundTime.until(now, ChronoUnit.NANOS) * 1.0E-9);
            }
            firstEventInLastRoundTime = now;
            lastRoundNumber = event.getRoundCreated();
        }
    }

    @Override
    public void coinRound() {
        this.numCoinRounds.update(1.0);
    }

    @Override
    public void lastFamousInRound(EventImpl event) {
        if (this.selfId.id() != event.getCreatorId().id()) {
            this.avgReceivedFamousTime.update((double)event.getBaseEvent().getTimeReceived().until(Instant.now(), ChronoUnit.NANOS) * 1.0E-9);
        }
    }

    @Override
    public void consensusReachedOnRound() {
        this.roundsPerSecond.cycle();
    }

    @Override
    public void consensusReached(EventImpl event) {
        if (Objects.equals(this.selfId, event.getCreatorId())) {
            this.avgCreatedConsensusTime.update((double)event.getBaseEvent().getTimeReceived().until(Instant.now(), ChronoUnit.NANOS) * 1.0E-9);
        } else {
            this.avgReceivedConsensusTime.update((double)event.getBaseEvent().getTimeReceived().until(Instant.now(), ChronoUnit.NANOS) * 1.0E-9);
            this.avgCreatedReceivedConsensusTime.update((double)event.getTimeCreated().until(Instant.now(), ChronoUnit.NANOS) * 1.0E-9);
        }
        if (Objects.equals(this.selfId, event.getCreatorId())) {
            this.avgSelfCreatedTimestamp.update((double)event.getTimeCreated().until(event.getConsensusTimestamp(), ChronoUnit.NANOS) * 1.0E-9);
        } else {
            this.avgOtherReceivedTimestamp.update((double)event.getBaseEvent().getTimeReceived().until(event.getConsensusTimestamp(), ChronoUnit.NANOS) * 1.0E-9);
        }
    }

    @Override
    public void dotProductTime(long nanoTime) {
        this.timeFracDot.update((double)nanoTime * 1.0E-9);
    }

    @Override
    public double getAvgSelfCreatedTimestamp() {
        return this.avgSelfCreatedTimestamp.get();
    }

    @Override
    public double getAvgOtherReceivedTimestamp() {
        return this.avgOtherReceivedTimestamp.get();
    }

    @Override
    public void judgeWeights(long weight) {
        this.avgJudgesWeight.update((double)weight);
    }

    @Override
    public void witnessesStronglySeen(int numSeen) {
        this.witnessesSeen.update((long)numSeen);
    }

    @Override
    public void roundIncrementedByStronglySeen() {
        this.roundIncrementedByStronglySeen.increment();
    }
}

