/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.metrics;

import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.common.metrics.extensions.CountPerSecond;
import com.swirlds.common.metrics.extensions.PhaseTimer;
import com.swirlds.common.metrics.extensions.PhaseTimerBuilder;
import com.swirlds.common.metrics.statistics.AverageAndMax;
import com.swirlds.common.metrics.statistics.AverageAndMaxTimeStat;
import com.swirlds.common.metrics.statistics.AverageStat;
import com.swirlds.common.metrics.statistics.AverageTimeStat;
import com.swirlds.common.metrics.statistics.MaxStat;
import com.swirlds.metrics.api.IntegerGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.gossip.shadowgraph.SyncPhase;
import com.swirlds.platform.gossip.shadowgraph.SyncResult;
import com.swirlds.platform.gossip.shadowgraph.SyncTiming;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.PeerInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public class SyncMetrics {
    private static final RunningAverageMetric.Config AVG_BYTES_PER_SEC_SYNC_CONFIG = new RunningAverageMetric.Config("platform", "bytes_per_sec_sync").withDescription("average number of bytes per second transferred during a sync");
    private final RunningAverageMetric avgBytesPerSecSync;
    private static final RunningAverageMetric.Config TIPS_PER_SYNC_CONFIG = new RunningAverageMetric.Config("internal", "tips_per_sync").withDescription("the average number of tips per sync at the start of each sync").withFormat("%,15.3f");
    private static final CountPerSecond.Config INCOMING_SYNC_REQUESTS_CONFIG = new CountPerSecond.Config("platform", "incomingSyncRequests_per_sec").withDescription("Incoming sync requests received per second");
    private final CountPerSecond incomingSyncRequestsPerSec;
    private static final CountPerSecond.Config ACCEPTED_SYNC_REQUESTS_CONFIG = new CountPerSecond.Config("platform", "acceptedSyncRequests_per_sec").withDescription("Incoming sync requests accepted per second");
    private final CountPerSecond acceptedSyncRequestsPerSec;
    private static final CountPerSecond.Config OPPORTUNITIES_TO_INITIATE_SYNC_CONFIG = new CountPerSecond.Config("platform", "opportunitiesToInitiateSync_per_sec").withDescription("Opportunities to initiate an outgoing sync per second");
    private final CountPerSecond opportunitiesToInitiateSyncPerSec;
    private static final CountPerSecond.Config OUTGOING_SYNC_REQUESTS_CONFIG = new CountPerSecond.Config("platform", "outgoingSyncRequests_per_sec").withDescription("Outgoing sync requests sent per second");
    private final CountPerSecond outgoingSyncRequestsPerSec;
    private static final CountPerSecond.Config SYNCS_PER_SECOND_CONFIG = new CountPerSecond.Config("platform", "syncs_per_sec").withDescription("Total number of syncs completed per second");
    private final CountPerSecond syncsPerSec;
    private static final CountPerSecond.Config CALL_SYNCS_PER_SECOND_CONFIG = new CountPerSecond.Config("platform", "sync_per_secC").withDescription("(call syncs) syncs completed per second initiated by this member");
    private final CountPerSecond callSyncsPerSecond;
    private static final CountPerSecond.Config REC_SYNCS_PER_SECOND_CONFIG = new CountPerSecond.Config("platform", "sync_per_secR").withDescription("(receive syncs) syncs completed per second initiated by other member");
    private final CountPerSecond recSyncsPerSecond;
    private static final RunningAverageMetric.Config SYNC_FILTER_TIME_CONFIG = new RunningAverageMetric.Config("platform", "syncFilterTime").withDescription("the average time spent filtering events during a sync").withUnit("nanoseconds");
    private static final CountPerSecond.Config DO_NOT_SYNC_PLATFORM_STATUS = new CountPerSecond.Config("platform", "doNotSyncPlatformStatus").withUnit("hz").withDescription("Number of times per second we do not sync because the platform status doesn't permit it");
    private final CountPerSecond doNoSyncPlatformStatus;
    private static final CountPerSecond.Config DO_NOT_SYNC_COOLDOWN_CONFIG = new CountPerSecond.Config("platform", "doNotSyncCooldown").withUnit("hz").withDescription("Number of times per second we do not sync because we are in sync cooldown");
    private final CountPerSecond doNotSyncCooldown;
    private static final CountPerSecond.Config DO_NOT_SYNC_HALTED_CONFIG = new CountPerSecond.Config("platform", "doNotSyncHalted").withUnit("hz").withDescription("Number of times per second we do not sync because gossip is halted");
    private final CountPerSecond doNotSyncHalted;
    private static final CountPerSecond.Config DO_NOT_SYNC_FALLEN_BEHIND_CONFIG = new CountPerSecond.Config("platform", "doNotSyncFallenBehind").withUnit("hz").withDescription("Number of times per second we do not sync because we have fallen behind");
    private final CountPerSecond doNotSyncFallenBehind;
    private static final CountPerSecond.Config DO_NOT_SYNC_PEER_FALLEN_BEHIND_CONFIG = new CountPerSecond.Config("platform", "doNotSyncRemoteFallenBehind").withUnit("hz").withDescription("Number of times per second we do not sync because peer node has fallen behind");
    private final CountPerSecond doNotSyncPeerFallenBehind;
    private static final CountPerSecond.Config DO_NOT_SYNC_PEER_PROCESSING_EVENTS_CONFIG = new CountPerSecond.Config("platform", "doNotSyncRemoteProcessingEvents").withUnit("hz").withDescription("Number of times per second we do not initiate sync because peer node is still processing our events");
    private final CountPerSecond doNotSyncPeerProcessingEvents;
    private static final CountPerSecond.Config DO_NOT_SYNC_ALREADY_STARTED_CONFIG = new CountPerSecond.Config("platform", "doNotSyncAlreadyStarted").withUnit("hz").withDescription("Number of times per second we do not sync because we have already started sync");
    private final CountPerSecond doNotSyncAlreadyStarted;
    private static final CountPerSecond.Config DO_NOT_SYNC_NO_PERMITS_CONFIG = new CountPerSecond.Config("platform", "doNotSyncNoPermits").withUnit("hz").withDescription("Number of times per second we do not sync because we have no permits");
    private final CountPerSecond doNotSyncNoPermits;
    private static final CountPerSecond.Config DO_NOT_SYNC_INTAKE_COUNTER_CONFIG = new CountPerSecond.Config("platform", "doNotSyncIntakeCounter").withUnit("hz").withDescription("Number of times per second we do not sync because the intake counter is too high");
    private final CountPerSecond doNotSyncIntakeCounter;
    private static final CountPerSecond.Config DO_NOT_SYNC_FAIR_SELECTOR_CONFIG = new CountPerSecond.Config("platform", "doNotSyncFairSelector").withUnit("hz").withDescription("Number of times per second we do not sync because of the fair selector");
    private final CountPerSecond doNotSyncFairSelector;
    private final IntegerGauge.Config RPC_READ_THREAD_RUNNING_CONFIG = new IntegerGauge.Config("platform", "rpcReadThreadRunning").withDescription("number of rpc thread running in read mode");
    private final IntegerGauge.Config RPC_WRITE_THREAD_RUNNING_CONFIG = new IntegerGauge.Config("platform", "rpcWriteThreadRunning").withDescription("number of rpc thread running in write mode");
    private final IntegerGauge.Config RPC_DISPATCH_THREAD_RUNNING_CONFIG = new IntegerGauge.Config("platform", "rpcDispatchThreadRunning").withDescription("number of rpc thread running in dispatch mode");
    private final IntegerGauge.Config SYNCS_IN_PROGRESS_CONFIG = new IntegerGauge.Config("platform", "syncs_in_progress").withDescription("number of syncs running concurrently");
    private final RunningAverageMetric tipsPerSync;
    private final AverageStat syncIndicatorDiff;
    private final AverageStat eventRecRate;
    private final AverageTimeStat avgSyncDuration1;
    private final AverageTimeStat avgSyncDuration2;
    private final AverageTimeStat avgSyncDuration3;
    private final AverageTimeStat avgSyncDuration4;
    private final AverageTimeStat avgSyncDuration5;
    private final AverageAndMaxTimeStat avgSyncDuration;
    private final AverageStat knownSetSize;
    private final AverageAndMax avgEventsPerSyncSent;
    private final AverageAndMax avgEventsPerSyncRec;
    private final MaxStat multiTipsPerSync;
    private final RunningAverageMetric syncFilterTime;
    private final ConcurrentHashMap<NodeId, AverageAndMax> rpcOutputQueueSize = new ConcurrentHashMap();
    private final ConcurrentHashMap<NodeId, AverageAndMax> rpcInputQueueSize = new ConcurrentHashMap();
    private final ConcurrentHashMap<NodeId, PhaseTimer<SyncPhase>> syncPhasePerNode = new ConcurrentHashMap();
    private final Metrics metrics;
    private final AverageAndMax outputQueuePollTime;
    private final Time time;
    private final IntegerGauge rpcReadThreadRunning;
    private final IntegerGauge rpcWriteThreadRunning;
    private final IntegerGauge rpcDispatchThreadRunning;
    private final IntegerGauge syncsInProgress;

    public SyncMetrics(Metrics metrics, Time time, List<PeerInfo> peers) {
        this.metrics = Objects.requireNonNull(metrics);
        this.time = Objects.requireNonNull(time);
        this.avgBytesPerSecSync = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_BYTES_PER_SEC_SYNC_CONFIG);
        this.callSyncsPerSecond = new CountPerSecond(metrics, CALL_SYNCS_PER_SECOND_CONFIG);
        this.recSyncsPerSecond = new CountPerSecond(metrics, REC_SYNCS_PER_SECOND_CONFIG);
        this.tipsPerSync = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)TIPS_PER_SYNC_CONFIG);
        this.incomingSyncRequestsPerSec = new CountPerSecond(metrics, INCOMING_SYNC_REQUESTS_CONFIG);
        this.acceptedSyncRequestsPerSec = new CountPerSecond(metrics, ACCEPTED_SYNC_REQUESTS_CONFIG);
        this.opportunitiesToInitiateSyncPerSec = new CountPerSecond(metrics, OPPORTUNITIES_TO_INITIATE_SYNC_CONFIG);
        this.outgoingSyncRequestsPerSec = new CountPerSecond(metrics, OUTGOING_SYNC_REQUESTS_CONFIG);
        this.syncsPerSec = new CountPerSecond(metrics, SYNCS_PER_SECOND_CONFIG);
        this.syncFilterTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)SYNC_FILTER_TIME_CONFIG);
        this.doNoSyncPlatformStatus = new CountPerSecond(metrics, DO_NOT_SYNC_PLATFORM_STATUS);
        this.doNotSyncCooldown = new CountPerSecond(metrics, DO_NOT_SYNC_COOLDOWN_CONFIG);
        this.doNotSyncHalted = new CountPerSecond(metrics, DO_NOT_SYNC_HALTED_CONFIG);
        this.doNotSyncFallenBehind = new CountPerSecond(metrics, DO_NOT_SYNC_FALLEN_BEHIND_CONFIG);
        this.doNotSyncPeerFallenBehind = new CountPerSecond(metrics, DO_NOT_SYNC_PEER_FALLEN_BEHIND_CONFIG);
        this.doNotSyncPeerProcessingEvents = new CountPerSecond(metrics, DO_NOT_SYNC_PEER_PROCESSING_EVENTS_CONFIG);
        this.doNotSyncAlreadyStarted = new CountPerSecond(metrics, DO_NOT_SYNC_ALREADY_STARTED_CONFIG);
        this.doNotSyncNoPermits = new CountPerSecond(metrics, DO_NOT_SYNC_NO_PERMITS_CONFIG);
        this.doNotSyncIntakeCounter = new CountPerSecond(metrics, DO_NOT_SYNC_INTAKE_COUNTER_CONFIG);
        this.doNotSyncFairSelector = new CountPerSecond(metrics, DO_NOT_SYNC_FAIR_SELECTOR_CONFIG);
        this.rpcReadThreadRunning = (IntegerGauge)metrics.getOrCreate((MetricConfig)this.RPC_READ_THREAD_RUNNING_CONFIG);
        this.rpcWriteThreadRunning = (IntegerGauge)metrics.getOrCreate((MetricConfig)this.RPC_WRITE_THREAD_RUNNING_CONFIG);
        this.rpcDispatchThreadRunning = (IntegerGauge)metrics.getOrCreate((MetricConfig)this.RPC_DISPATCH_THREAD_RUNNING_CONFIG);
        this.syncsInProgress = (IntegerGauge)metrics.getOrCreate((MetricConfig)this.SYNCS_IN_PROGRESS_CONFIG);
        this.avgSyncDuration = new AverageAndMaxTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync", "duration of average successful sync (in seconds)");
        this.avgEventsPerSyncSent = new AverageAndMax(metrics, "platform", "ev_per_syncS", "number of events sent per successful sync", "%,8.1f");
        this.avgEventsPerSyncRec = new AverageAndMax(metrics, "platform", "ev_per_syncR", "number of events received per successful sync", "%,8.1f");
        this.syncIndicatorDiff = new AverageStat(metrics, "internal", "syncIndicatorDiff", "number of ancient indicators ahead (positive) or behind (negative) when syncing", "%,8.1f", 0.1);
        this.eventRecRate = new AverageStat(metrics, "internal", "eventRecRate", "the rate at which we receive and enqueue events in ev/sec", "%,8.1f", 0.1);
        this.avgSyncDuration1 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync1", "duration of step 1 of average successful sync (in seconds)");
        this.avgSyncDuration2 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync2", "duration of step 2 of average successful sync (in seconds)");
        this.avgSyncDuration3 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync3", "duration of step 3 of average successful sync (in seconds)");
        this.avgSyncDuration4 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync4", "duration of step 4 of average successful sync (in seconds)");
        this.avgSyncDuration5 = new AverageTimeStat(metrics, ChronoUnit.SECONDS, "internal", "sec_per_sync5", "duration of step 5 of average successful sync (in seconds)");
        this.knownSetSize = new AverageStat(metrics, "platform", "knownSetSize", "the average size of the known set during a sync", "%,10.3f", 0.1);
        this.multiTipsPerSync = new MaxStat(metrics, "platform", "multiTips_per_sync", "the number of creators that have more than one tip at the start of each sync", "%5d");
        this.outputQueuePollTime = new AverageAndMax(metrics, "platform", "rpc_output_queue_poll_time", "amount of us spent sleeping waiting for poll to happen or timeout on rpc output queue", "%,10.0f");
        this.precreateDynamicMetrics(peers);
    }

    private void precreateDynamicMetrics(List<PeerInfo> peers) {
        for (PeerInfo peer : peers) {
            NodeId nodeId = peer.nodeId();
            this.rpcInputQueueSize(nodeId, 0);
            this.rpcOutputQueueSize(nodeId, 0);
            this.reportSyncPhase(nodeId, SyncPhase.OUTSIDE_OF_RPC);
        }
    }

    public void eventWindow(@NonNull EventWindow self, @NonNull EventWindow other) {
        this.syncIndicatorDiff.update(self.ancientThreshold() - other.ancientThreshold());
    }

    public void eventsReceived(long nanosStart, int numberReceived) {
        if (numberReceived == 0) {
            return;
        }
        double nanos = (double)System.nanoTime() - (double)nanosStart;
        double seconds = nanos / (double)ChronoUnit.SECONDS.getDuration().toNanos();
        this.eventRecRate.update(Math.round((double)numberReceived / seconds));
    }

    public void recordSyncTiming(SyncTiming timing, Connection conn) {
        this.avgSyncDuration1.update(timing.getTimePoint(0), timing.getTimePoint(1));
        this.avgSyncDuration2.update(timing.getTimePoint(1), timing.getTimePoint(2));
        this.avgSyncDuration3.update(timing.getTimePoint(2), timing.getTimePoint(3));
        this.avgSyncDuration4.update(timing.getTimePoint(3), timing.getTimePoint(4));
        this.avgSyncDuration5.update(timing.getTimePoint(4), timing.getTimePoint(5));
        this.avgSyncDuration.update(timing.getTimePoint(0), timing.getTimePoint(5));
        double syncDurationSec = (double)timing.getPointDiff(5, 0) * 1.0E-9;
        double speed = (double)Math.max(conn.getDis().getSyncByteCounter().getCount(), conn.getDos().getSyncByteCounter().getCount()) / syncDurationSec;
        this.avgBytesPerSecSync.update(speed);
    }

    public void knownSetSize(int knownSetSize) {
        this.knownSetSize.update((long)knownSetSize);
    }

    public void syncDone(SyncResult info, @Nullable Boolean usedOutgoingConnection) {
        this.syncsPerSec.count();
        if (usedOutgoingConnection != null) {
            if (usedOutgoingConnection.booleanValue()) {
                this.callSyncsPerSecond.count();
            } else {
                this.recSyncsPerSecond.count();
            }
        }
        this.avgEventsPerSyncSent.update((long)info.getEventsWritten());
        this.avgEventsPerSyncRec.update((long)info.getEventsRead());
    }

    public void updateMultiTipsPerSync(int multiTipCount) {
        this.multiTipsPerSync.update((long)multiTipCount);
    }

    public void updateTipsPerSync(int tipCount) {
        this.tipsPerSync.update((double)tipCount);
    }

    public void incomingSyncRequestReceived() {
        this.incomingSyncRequestsPerSec.count();
    }

    public void acceptedSyncRequest() {
        this.acceptedSyncRequestsPerSec.count();
    }

    public void opportunityToInitiateSync() {
        this.opportunitiesToInitiateSyncPerSec.count();
    }

    public void outgoingSyncRequestSent() {
        this.outgoingSyncRequestsPerSec.count();
    }

    public void recordSyncFilterTime(long nanoseconds) {
        this.syncFilterTime.update((double)nanoseconds);
    }

    public void doNotSyncPlatformStatus() {
        this.doNoSyncPlatformStatus.count();
    }

    public void doNotSyncCooldown() {
        this.doNotSyncCooldown.count();
    }

    public void doNotSyncHalted() {
        this.doNotSyncHalted.count();
    }

    public void doNotSyncFallenBehind() {
        this.doNotSyncFallenBehind.count();
    }

    public void doNotSyncPeerFallenBehind() {
        this.doNotSyncPeerFallenBehind.count();
    }

    public void doNotSyncPeerProcessingEvents() {
        this.doNotSyncPeerProcessingEvents.count();
    }

    public void doNotSyncAlreadyStarted() {
        this.doNotSyncAlreadyStarted.count();
    }

    public void doNotSyncNoPermits() {
        this.doNotSyncNoPermits.count();
    }

    public void doNotSyncIntakeCounter() {
        this.doNotSyncIntakeCounter.count();
    }

    public void doNotSyncFairSelector() {
        this.doNotSyncFairSelector.count();
    }

    public void rpcOutputQueueSize(NodeId node, int size) {
        this.rpcOutputQueueSize.computeIfAbsent(node, nodeId -> new AverageAndMax(this.metrics, "platform", String.format("rpc_output_queue_size_%02d", nodeId.id()), String.format("gossip rpc output queue size to node %02d", nodeId.id()), "%,10.0f", 0.1)).update((long)size);
    }

    public void rpcInputQueueSize(NodeId node, int size) {
        this.rpcInputQueueSize.computeIfAbsent(node, nodeId -> new AverageAndMax(this.metrics, "platform", String.format("rpc_input_queue_size_%02d", nodeId.id()), String.format("gossip rpc input queue size from node %02d", nodeId.id()), "%,10.0f", 0.1)).update((long)size);
    }

    public void outputQueuePollTime(long nanos) {
        this.outputQueuePollTime.update(nanos / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncPhase reportSyncPhase(@NonNull NodeId node, @NonNull SyncPhase syncPhase) {
        PhaseTimer phaseMetric;
        PhaseTimer phaseTimer = phaseMetric = this.syncPhasePerNode.computeIfAbsent(node, nodeId -> new PhaseTimerBuilder(this.metrics, this.time, "platform", SyncPhase.class).enableFractionalMetrics().setInitialPhase((Enum)SyncPhase.OUTSIDE_OF_RPC).setMetricsNamePrefix(String.format("sync_phase_%02d", nodeId.id())).build());
        synchronized (phaseTimer) {
            SyncPhase oldPhase = (SyncPhase)phaseMetric.getActivePhase();
            phaseMetric.activatePhase((Enum)syncPhase);
            return oldPhase;
        }
    }

    public void rpcReadThreadRunning(int change) {
        this.rpcReadThreadRunning.add(change);
    }

    public void rpcWriteThreadRunning(int change) {
        this.rpcWriteThreadRunning.add(change);
    }

    public void rpcDispatchThreadRunning(int change) {
        this.rpcDispatchThreadRunning.add(change);
    }

    public void syncStarted() {
        this.syncsInProgress.add(1);
    }

    public void syncFinished() {
        this.syncsInProgress.add(-1);
    }
}

