/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol.rpc;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.CachedPoolParallelExecutor;
import com.swirlds.common.threading.pool.ParallelExecutor;
import com.swirlds.platform.gossip.shadowgraph.RpcPeerHandler;
import com.swirlds.platform.gossip.shadowgraph.RpcShadowgraphSynchronizer;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.network.NetworkMetrics;
import com.swirlds.platform.network.protocol.AbstractSyncProtocol;
import com.swirlds.platform.network.protocol.PeerProtocol;
import com.swirlds.platform.network.protocol.rpc.RpcPeerProtocol;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class RpcProtocol
extends AbstractSyncProtocol<RpcShadowgraphSynchronizer> {
    private final CachedPoolParallelExecutor executor;
    private final AtomicReference<PlatformStatus> platformStatus = new AtomicReference<PlatformStatus>(PlatformStatus.STARTING_UP);
    private final NetworkMetrics networkMetrics;
    private final Time time;
    private final SyncMetrics syncMetrics;

    protected RpcProtocol(@NonNull RpcShadowgraphSynchronizer synchronizer, @NonNull CachedPoolParallelExecutor executor, @NonNull IntakeEventCounter intakeEventCounter, @NonNull PlatformContext platformContext, int rosterSize, @NonNull NetworkMetrics networkMetrics, @NonNull Time time, @NonNull SyncMetrics syncMetrics) {
        super(synchronizer, platformContext, rosterSize, intakeEventCounter);
        this.executor = Objects.requireNonNull(executor);
        this.networkMetrics = Objects.requireNonNull(networkMetrics);
        this.time = Objects.requireNonNull(time);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
    }

    public static RpcProtocol create(@NonNull PlatformContext platformContext, @NonNull RpcShadowgraphSynchronizer synchronizer, @NonNull IntakeEventCounter intakeEventCounter, @NonNull ThreadManager threadManager, int rosterSize, @NonNull NetworkMetrics networkMetrics, SyncMetrics syncMetrics) {
        return new RpcProtocol(synchronizer, new CachedPoolParallelExecutor(threadManager, "node-rpc-sync"), intakeEventCounter, platformContext, rosterSize, networkMetrics, platformContext.getTime(), syncMetrics);
    }

    @Override
    public PeerProtocol createPeerInstance(@NonNull NodeId peerId) {
        RpcPeerProtocol peerProtocol = new RpcPeerProtocol(peerId, (ParallelExecutor)this.executor, this.gossipHalted::get, this.platformStatus::get, this.permitProvider, this.networkMetrics, this.time, this.syncMetrics, this.syncConfig);
        RpcPeerHandler handler = ((RpcShadowgraphSynchronizer)this.synchronizer).createPeerHandler(peerProtocol, peerId);
        peerProtocol.setRpcPeerHandler(handler);
        return peerProtocol;
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus status) {
        this.platformStatus.set(status);
    }

    @Override
    public void start() {
        super.start();
        this.executor.start();
    }

    @Override
    public void stop() {
        this.executor.stop();
        super.stop();
    }
}

