/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.metrics.extensions.CountPerSecond;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ReconnectFinishPayload;
import com.swirlds.logging.legacy.payload.ReconnectStartPayload;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.protocol.PeerProtocol;
import com.swirlds.platform.network.protocol.ReservedSignedStateResult;
import com.swirlds.platform.reconnect.FallenBehindMonitor;
import com.swirlds.platform.reconnect.ReconnectStateLearner;
import com.swirlds.platform.reconnect.ReconnectStateTeacher;
import com.swirlds.platform.reconnect.ReconnectStateTeacherThrottle;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.concurrent.BlockingResourceProvider;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class ReconnectStatePeerProtocol
implements PeerProtocol {
    private static final Logger logger = LogManager.getLogger(ReconnectStatePeerProtocol.class);
    private final NodeId peerId;
    private final ReconnectStateTeacherThrottle teacherThrottle;
    private final java.util.function.Supplier<ReservedSignedState> lastCompleteSignedState;
    private final Duration reconnectSocketTimeout;
    private final ReconnectMetrics reconnectMetrics;
    private final CountPerSecond reconnectRejectionMetrics;
    private InitiatedBy initiatedBy = InitiatedBy.NO_ONE;
    private final ThreadManager threadManager;
    private final FallenBehindMonitor fallenBehindMonitor;
    private final java.util.function.Supplier<PlatformStatus> platformStatusSupplier;
    private ReservedSignedState teacherState;
    private final RateLimitedLogger stateNullLogger;
    private final RateLimitedLogger stateIncompleteLogger;
    private final RateLimitedLogger fallenBehindLogger;
    private final RateLimitedLogger notActiveLogger;
    private final Time time;
    private final PlatformContext platformContext;
    private final BlockingResourceProvider<ReservedSignedStateResult> reservedSignedStateResultProvider;
    private final StateLifecycleManager stateLifecycleManager;

    public ReconnectStatePeerProtocol(@NonNull PlatformContext platformContext, @NonNull ThreadManager threadManager, @NonNull NodeId peerId, @NonNull ReconnectStateTeacherThrottle teacherThrottle, @NonNull java.util.function.Supplier<ReservedSignedState> lastCompleteSignedState, @NonNull Duration reconnectSocketTimeout, @NonNull ReconnectMetrics reconnectMetrics, @NonNull FallenBehindMonitor fallenBehindMonitor, @NonNull java.util.function.Supplier<PlatformStatus> platformStatusSupplier, @NonNull Time time, @NonNull BlockingResourceProvider<ReservedSignedStateResult> reservedSignedStateResultProvider, @NonNull StateLifecycleManager stateLifecycleManager) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.peerId = Objects.requireNonNull(peerId);
        this.teacherThrottle = Objects.requireNonNull(teacherThrottle);
        this.lastCompleteSignedState = Objects.requireNonNull(lastCompleteSignedState);
        this.reconnectSocketTimeout = Objects.requireNonNull(reconnectSocketTimeout);
        this.reconnectMetrics = Objects.requireNonNull(reconnectMetrics);
        this.fallenBehindMonitor = Objects.requireNonNull(fallenBehindMonitor);
        this.platformStatusSupplier = Objects.requireNonNull(platformStatusSupplier);
        this.reservedSignedStateResultProvider = Objects.requireNonNull(reservedSignedStateResultProvider);
        this.stateLifecycleManager = Objects.requireNonNull(stateLifecycleManager);
        Objects.requireNonNull(time);
        Duration minimumTimeBetweenReconnects = ((ReconnectConfig)platformContext.getConfiguration().getConfigData(ReconnectConfig.class)).minimumTimeBetweenReconnects();
        this.stateNullLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.stateIncompleteLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.fallenBehindLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.notActiveLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.time = Objects.requireNonNull(time);
        this.reconnectRejectionMetrics = new CountPerSecond(reconnectMetrics.getMetrics(), new CountPerSecond.Config("platform", String.format("reconnectRejections_per_sec_%02d", peerId.id())).withDescription(String.format("number of reconnections rejected per second from node %02d", peerId.id())).withUnit("rejectionsPerSec").withFormat("%,10.0f"));
    }

    @Override
    public boolean shouldInitiate() {
        if (!this.fallenBehindMonitor.hasFallenBehind()) {
            return false;
        }
        if (!this.fallenBehindMonitor.isBehindPeer(this.peerId)) {
            return false;
        }
        boolean acquiredPermit = this.reservedSignedStateResultProvider.acquireProvidePermit();
        if (acquiredPermit) {
            this.initiatedBy = InitiatedBy.SELF;
        }
        return acquiredPermit;
    }

    @Override
    public void initiateFailed() {
        this.reservedSignedStateResultProvider.releaseProvidePermit();
        this.initiatedBy = InitiatedBy.NO_ONE;
    }

    @Override
    public boolean shouldAccept() {
        if (this.fallenBehindMonitor.hasFallenBehind()) {
            this.fallenBehindLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} because this node has fallen behind", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        if (this.platformStatusSupplier.get() != PlatformStatus.ACTIVE) {
            this.notActiveLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} because this node isn't ACTIVE", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        this.teacherState = this.lastCompleteSignedState.get();
        if (this.teacherState == null || this.teacherState.isNull()) {
            this.stateNullLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} due to lack of a fully signed state", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        if (!this.teacherState.get().isComplete()) {
            this.stateIncompleteLogger.error(LogMarker.EXCEPTION.getMarker(), "Rejecting reconnect request from node {} due to lack of a fully signed state. The signed state manager attempted to provide a state that was not fully signed, which should not be possible.", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        if (!this.reservedSignedStateResultProvider.tryBlockProvidePermit()) {
            this.reconnectRejected();
            return false;
        }
        boolean reconnectPermittedByThrottle = this.teacherThrottle.initiateReconnect(this.peerId);
        if (!reconnectPermittedByThrottle) {
            this.reconnectRejected();
            this.reservedSignedStateResultProvider.releaseProvidePermit();
            return false;
        }
        this.initiatedBy = InitiatedBy.PEER;
        return true;
    }

    private void reconnectRejected() {
        if (this.teacherState != null) {
            this.teacherState.close();
            this.teacherState = null;
        }
        this.reconnectRejectionMetrics.count();
    }

    @Override
    public void acceptFailed() {
        this.teacherState.close();
        this.teacherState = null;
        this.teacherThrottle.reconnectAttemptFinished();
        this.reservedSignedStateResultProvider.releaseProvidePermit();
    }

    @Override
    public boolean acceptOnSimultaneousInitiate() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void runProtocol(Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        try {
            switch (this.initiatedBy.ordinal()) {
                case 2: {
                    this.teacher(connection);
                    return;
                }
                case 1: {
                    this.learner(connection);
                    return;
                }
                default: {
                    throw new NetworkProtocolException("runProtocol() called but it is unclear who the teacher and who the learner is");
                }
            }
        }
        finally {
            this.initiatedBy = InitiatedBy.NO_ONE;
        }
    }

    private void learner(Connection connection) {
        try {
            MerkleNodeState consensusState = this.stateLifecycleManager.getMutableState();
            ReconnectStateLearner learner = new ReconnectStateLearner(this.platformContext, this.threadManager, connection, consensusState, this.reconnectSocketTimeout, this.reconnectMetrics, this.stateLifecycleManager);
            logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectStartPayload("Starting reconnect in role of the receiver.", true, connection.getSelfId().id(), connection.getOtherId().id(), PlatformStateUtils.roundOf((State)consensusState)).toString());
            ReservedSignedState reservedSignedState = learner.execute();
            logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectFinishPayload("Finished reconnect in the role of the receiver.", true, connection.getSelfId().id(), connection.getOtherId().id(), reservedSignedState.get().getRound()).toString());
            int debugHashDepth = ((StateConfig)this.platformContext.getConfiguration().getConfigData(StateConfig.class)).debugHashDepth();
            logger.info(LogMarker.RECONNECT.getMarker(), "Information for state received during reconnect:\n{}", new Supplier[]{() -> PlatformStateUtils.getInfoString((State)reservedSignedState.get().getState(), debugHashDepth)});
            this.reservedSignedStateResultProvider.provide((Object)new ReservedSignedStateResult(reservedSignedState, null));
        }
        catch (RuntimeException e) {
            if (!Utilities.isOrCausedBySocketException(e) && connection != null) {
                connection.disconnect();
            }
            try {
                this.reservedSignedStateResultProvider.provide((Object)new ReservedSignedStateResult(null, e));
            }
            catch (InterruptedException ie) {
                this.reservedSignedStateResultProvider.releaseProvidePermit();
            }
        }
        catch (InterruptedException e) {
            this.reservedSignedStateResultProvider.releaseProvidePermit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teacher(Connection connection) {
        try {
            ReconnectStateTeacher teacher;
            SignedState state = this.teacherState.get();
            try {
                teacher = new ReconnectStateTeacher(this.platformContext, this.time, this.threadManager, connection, this.reconnectSocketTimeout, connection.getSelfId(), connection.getOtherId(), state.getRound(), state, this.reconnectMetrics);
            }
            finally {
                this.teacherState.close();
            }
            teacher.execute();
        }
        finally {
            this.teacherThrottle.reconnectAttemptFinished();
            this.teacherState = null;
            this.reservedSignedStateResultProvider.releaseProvidePermit();
        }
    }

    private static enum InitiatedBy {
        NO_ONE,
        SELF,
        PEER;

    }
}

