/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.views;

import com.swirlds.base.time.Time;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.TeachingSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.NodeToSend;
import com.swirlds.common.merkle.synchronization.task.QueryResponse;
import com.swirlds.common.merkle.synchronization.task.TeacherPushReceiveTask;
import com.swirlds.common.merkle.synchronization.task.TeacherPushSendTask;
import com.swirlds.common.merkle.synchronization.task.TeacherSubtree;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.concurrent.pool.StandardWorkGroup;

public class TeacherPushMerkleTreeView
implements TeacherTreeView<NodeToSend> {
    private final ReconnectConfig reconnectConfig;
    private final Queue<NodeToSend> nodesToHandle;
    private final BlockingQueue<NodeToSend> expectedResponses;
    private final NodeToSend root;
    private final int maxAckDelayMilliseconds;

    public TeacherPushMerkleTreeView(@NonNull Configuration configuration, MerkleNode root) {
        this.reconnectConfig = (ReconnectConfig)configuration.getConfigData(ReconnectConfig.class);
        this.maxAckDelayMilliseconds = (int)this.reconnectConfig.maxAckDelay().toMillis();
        this.root = new NodeToSend(root, this.maxAckDelayMilliseconds);
        this.nodesToHandle = new LinkedList<NodeToSend>();
        this.expectedResponses = new LinkedBlockingDeque<NodeToSend>();
    }

    @Override
    public void startTeacherTasks(TeachingSynchronizer teachingSynchronizer, Time time, StandardWorkGroup workGroup, MerkleDataInputStream inputStream, MerkleDataOutputStream outputStream, Queue<TeacherSubtree> subtrees) {
        AsyncInputStream<QueryResponse> in = new AsyncInputStream<QueryResponse>(inputStream, workGroup, QueryResponse::new, this.reconnectConfig);
        AsyncOutputStream out = teachingSynchronizer.buildOutputStream(workGroup, outputStream);
        in.start();
        out.start();
        AtomicBoolean senderIsFinished = new AtomicBoolean(false);
        TeacherPushSendTask<NodeToSend> teacherPushSendTask = new TeacherPushSendTask<NodeToSend>(time, this.reconnectConfig, workGroup, in, out, subtrees, this, senderIsFinished);
        teacherPushSendTask.start();
        TeacherPushReceiveTask<NodeToSend> teacherPushReceiveTask = new TeacherPushReceiveTask<NodeToSend>(workGroup, in, this, senderIsFinished);
        teacherPushReceiveTask.start();
    }

    @Override
    public NodeToSend getRoot() {
        return this.root;
    }

    @Override
    public void addToHandleQueue(NodeToSend node) {
        this.nodesToHandle.add(node);
    }

    @Override
    public NodeToSend getNextNodeToHandle() {
        return this.nodesToHandle.remove();
    }

    @Override
    public boolean areThereNodesToHandle() {
        return !this.nodesToHandle.isEmpty();
    }

    @Override
    public NodeToSend getChildAndPrepareForQueryResponse(NodeToSend parent, int childIndex) {
        NodeToSend child = new NodeToSend(parent.getNode().asInternal().getChild(childIndex), this.maxAckDelayMilliseconds);
        parent.registerChild(child);
        if (!this.expectedResponses.add(child)) {
            throw new MerkleSynchronizationException("unable to add expected response to queue");
        }
        return child;
    }

    @Override
    public NodeToSend getNodeForNextResponse() {
        return (NodeToSend)this.expectedResponses.remove();
    }

    @Override
    public boolean isResponseExpected() {
        return !this.expectedResponses.isEmpty();
    }

    @Override
    public void registerResponseForNode(NodeToSend node, boolean learnerHasNode) {
        node.registerResponse(learnerHasNode);
    }

    @Override
    public boolean hasLearnerConfirmedFor(NodeToSend node) {
        node.waitForResponse();
        return node.getResponseStatus();
    }

    @Override
    public boolean isInternal(NodeToSend node, boolean isOriginal) {
        MerkleNode merkleNode = node.getNode();
        return merkleNode != null && !merkleNode.isLeaf();
    }

    @Override
    public long getClassId(NodeToSend node) {
        MerkleNode merkleNode = node.getNode();
        if (merkleNode == null) {
            throw new MerkleSynchronizationException("null has no class ID");
        }
        return merkleNode.getClassId();
    }

    @Override
    public MerkleNode getMerkleRoot(NodeToSend node) {
        return node.getNode();
    }

    @Override
    public int getNumberOfChildren(NodeToSend node) {
        MerkleNode merkleNode = node.getNode();
        if (merkleNode == null || merkleNode.isLeaf()) {
            throw new MerkleSynchronizationException("can not get number of children from node that is not internal");
        }
        return merkleNode.asInternal().getNumberOfChildren();
    }

    @Override
    public boolean isCustomReconnectRoot(NodeToSend node) {
        MerkleNode merkleNode = node.getNode();
        return merkleNode != null && merkleNode.hasCustomReconnectView();
    }

    private List<Hash> getChildHashes(NodeToSend parent) {
        MerkleNode node = parent.getNode();
        if (node == null || node.isLeaf()) {
            throw new MerkleSynchronizationException("can not get child hashes of null value");
        }
        if (node.isLeaf()) {
            throw new MerkleSynchronizationException("can not get child hashes of leaf");
        }
        MerkleInternal internal = node.asInternal();
        int childCount = internal.getNumberOfChildren();
        ArrayList<Hash> hashes = new ArrayList<Hash>(childCount);
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            MerkleNode child = internal.getChild(childIndex);
            if (child == null) {
                hashes.add(Cryptography.NULL_HASH);
                continue;
            }
            Hash hash = child.getHash();
            if (hash == null) {
                throw new MerkleSynchronizationException(child.getClass().getName() + " at position " + String.valueOf(child.getRoute()) + " is unhashed");
            }
            hashes.add(child.getHash());
        }
        return hashes;
    }

    @Override
    public void writeChildHashes(NodeToSend parent, SerializableDataOutputStream out) throws IOException {
        out.writeSerializableList(this.getChildHashes(parent), false, true);
    }

    @Override
    public void serializeLeaf(SerializableDataOutputStream out, NodeToSend leaf) throws IOException {
        MerkleNode merkleNode = leaf.getNode();
        if (merkleNode == null) {
            out.writeSerializable(null, true);
            return;
        }
        if (!merkleNode.isLeaf()) {
            throw new MerkleSynchronizationException("this method can not serialize an internal node");
        }
        out.writeSerializable((SelfSerializable)merkleNode.asLeaf(), true);
    }

    @Override
    public void serializeInternal(SerializableDataOutputStream out, NodeToSend internal) throws IOException {
        MerkleNode merkleNode = internal.getNode();
        if (merkleNode == null || merkleNode.isLeaf()) {
            throw new MerkleSynchronizationException("this method can not serialize a leaf node");
        }
        out.writeLong(merkleNode.getClassId());
    }
}

