/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.token.codec.TokenCreateTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.TokenCreateTransactionBodyProtoCodec;
import com.hedera.hapi.node.token.schema.TokenCreateTransactionBodySchema;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class TokenCreateTransactionBody {
    public static final Codec<TokenCreateTransactionBody> PROTOBUF = new TokenCreateTransactionBodyProtoCodec();
    public static final JsonCodec<TokenCreateTransactionBody> JSON = new TokenCreateTransactionBodyJsonCodec();
    public static final TokenCreateTransactionBody DEFAULT = TokenCreateTransactionBody.newBuilder().build();
    @NonNull
    private final String name;
    @NonNull
    private final String symbol;
    private final int decimals;
    private final long initialSupply;
    @Nullable
    private final AccountID treasury;
    @Nullable
    private final Key adminKey;
    @Nullable
    private final Key kycKey;
    @Nullable
    private final Key freezeKey;
    @Nullable
    private final Key wipeKey;
    @Nullable
    private final Key supplyKey;
    private final boolean freezeDefault;
    @Nullable
    private final Timestamp expiry;
    @Nullable
    private final AccountID autoRenewAccount;
    @Nullable
    private final Duration autoRenewPeriod;
    @NonNull
    private final String memo;
    private final TokenType tokenType;
    private final TokenSupplyType supplyType;
    private final long maxSupply;
    @Nullable
    private final Key feeScheduleKey;
    @NonNull
    private final List<CustomFee> customFees;
    @Nullable
    private final Key pauseKey;
    @NonNull
    private final Bytes metadata;
    @Nullable
    private final Key metadataKey;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public TokenCreateTransactionBody(String name, String symbol, int decimals, long initialSupply, AccountID treasury, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, boolean freezeDefault, Timestamp expiry, AccountID autoRenewAccount, Duration autoRenewPeriod, String memo, TokenType tokenType, TokenSupplyType supplyType, long maxSupply, Key feeScheduleKey, List<CustomFee> customFees, Key pauseKey, Bytes metadata, Key metadataKey) {
        this.$unknownFields = null;
        this.name = name != null ? name : "";
        this.symbol = symbol != null ? symbol : "";
        this.decimals = decimals;
        this.initialSupply = initialSupply;
        this.treasury = treasury;
        this.adminKey = adminKey;
        this.kycKey = kycKey;
        this.freezeKey = freezeKey;
        this.wipeKey = wipeKey;
        this.supplyKey = supplyKey;
        this.freezeDefault = freezeDefault;
        this.expiry = expiry;
        this.autoRenewAccount = autoRenewAccount;
        this.autoRenewPeriod = autoRenewPeriod;
        this.memo = memo != null ? memo : "";
        this.tokenType = tokenType;
        this.supplyType = supplyType;
        this.maxSupply = maxSupply;
        this.feeScheduleKey = feeScheduleKey;
        this.customFees = customFees == null ? Collections.emptyList() : customFees;
        this.pauseKey = pauseKey;
        this.metadata = metadata != null ? metadata : Bytes.EMPTY;
        this.metadataKey = metadataKey;
    }

    public TokenCreateTransactionBody(String name, String symbol, int decimals, long initialSupply, AccountID treasury, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, boolean freezeDefault, Timestamp expiry, AccountID autoRenewAccount, Duration autoRenewPeriod, String memo, TokenType tokenType, TokenSupplyType supplyType, long maxSupply, Key feeScheduleKey, List<CustomFee> customFees, Key pauseKey, Bytes metadata, Key metadataKey, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.name = name != null ? name : "";
        this.symbol = symbol != null ? symbol : "";
        this.decimals = decimals;
        this.initialSupply = initialSupply;
        this.treasury = treasury;
        this.adminKey = adminKey;
        this.kycKey = kycKey;
        this.freezeKey = freezeKey;
        this.wipeKey = wipeKey;
        this.supplyKey = supplyKey;
        this.freezeDefault = freezeDefault;
        this.expiry = expiry;
        this.autoRenewAccount = autoRenewAccount;
        this.autoRenewPeriod = autoRenewPeriod;
        this.memo = memo != null ? memo : "";
        this.tokenType = tokenType;
        this.supplyType = supplyType;
        this.maxSupply = maxSupply;
        this.feeScheduleKey = feeScheduleKey;
        this.customFees = customFees == null ? Collections.emptyList() : customFees;
        this.pauseKey = pauseKey;
        this.metadata = metadata != null ? metadata : Bytes.EMPTY;
        this.metadataKey = metadataKey;
    }

    public String name() {
        return this.name;
    }

    public String symbol() {
        return this.symbol;
    }

    public int decimals() {
        return this.decimals;
    }

    public long initialSupply() {
        return this.initialSupply;
    }

    public AccountID treasury() {
        return this.treasury;
    }

    public Key adminKey() {
        return this.adminKey;
    }

    public Key kycKey() {
        return this.kycKey;
    }

    public Key freezeKey() {
        return this.freezeKey;
    }

    public Key wipeKey() {
        return this.wipeKey;
    }

    public Key supplyKey() {
        return this.supplyKey;
    }

    public boolean freezeDefault() {
        return this.freezeDefault;
    }

    public Timestamp expiry() {
        return this.expiry;
    }

    public AccountID autoRenewAccount() {
        return this.autoRenewAccount;
    }

    public Duration autoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    public String memo() {
        return this.memo;
    }

    public TokenType tokenType() {
        return this.tokenType;
    }

    public TokenSupplyType supplyType() {
        return this.supplyType;
    }

    public long maxSupply() {
        return this.maxSupply;
    }

    public Key feeScheduleKey() {
        return this.feeScheduleKey;
    }

    public List<CustomFee> customFees() {
        return this.customFees;
    }

    public Key pauseKey() {
        return this.pauseKey;
    }

    public Bytes metadata() {
        return this.metadata;
    }

    public Key metadataKey() {
        return this.metadataKey;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenCreateTransactionBodySchema.NAME, (String)this.name, (boolean)true);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenCreateTransactionBodySchema.SYMBOL, (String)this.symbol, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)TokenCreateTransactionBodySchema.DECIMALS, (int)this.decimals, (boolean)true);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenCreateTransactionBodySchema.INITIAL_SUPPLY, (long)this.initialSupply, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.TREASURY, (Object)this.treasury, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.ADMIN_KEY, (Object)this.adminKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.KYC_KEY, (Object)this.kycKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.FREEZE_KEY, (Object)this.freezeKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.WIPE_KEY, (Object)this.wipeKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.SUPPLY_KEY, (Object)this.supplyKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenCreateTransactionBodySchema.FREEZE_DEFAULT, (boolean)this.freezeDefault, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.EXPIRY, (Object)this.expiry, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.AUTO_RENEW_ACCOUNT, (Object)this.autoRenewAccount, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.AUTO_RENEW_PERIOD, (Object)this.autoRenewPeriod, Duration.PROTOBUF);
            _size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenCreateTransactionBodySchema.MEMO, (String)this.memo, (boolean)true);
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenCreateTransactionBodySchema.TOKEN_TYPE, (EnumWithProtoMetadata)this.tokenType);
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenCreateTransactionBodySchema.SUPPLY_TYPE, (EnumWithProtoMetadata)this.supplyType);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenCreateTransactionBodySchema.MAX_SUPPLY, (long)this.maxSupply, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.FEE_SCHEDULE_KEY, (Object)this.feeScheduleKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TokenCreateTransactionBodySchema.CUSTOM_FEES, this.customFees, CustomFee.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.PAUSE_KEY, (Object)this.pauseKey, Key.PROTOBUF);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TokenCreateTransactionBodySchema.METADATA, (RandomAccessData)this.metadata, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenCreateTransactionBodySchema.METADATA_KEY, (Object)this.metadataKey, Key.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            List<CustomFee> list$customFees;
            int result = 1;
            if (this.name != null && !this.name.equals(TokenCreateTransactionBody.DEFAULT.name)) {
                result = 31 * result + this.name.hashCode();
            }
            if (this.symbol != null && !this.symbol.equals(TokenCreateTransactionBody.DEFAULT.symbol)) {
                result = 31 * result + this.symbol.hashCode();
            }
            if (this.decimals != TokenCreateTransactionBody.DEFAULT.decimals) {
                result = 31 * result + Integer.hashCode(this.decimals);
            }
            if (this.initialSupply != TokenCreateTransactionBody.DEFAULT.initialSupply) {
                result = 31 * result + Long.hashCode(this.initialSupply);
            }
            if (this.treasury != null && !this.treasury.equals(TokenCreateTransactionBody.DEFAULT.treasury)) {
                result = 31 * result + this.treasury.hashCode();
            }
            if (this.adminKey != null && !this.adminKey.equals(TokenCreateTransactionBody.DEFAULT.adminKey)) {
                result = 31 * result + this.adminKey.hashCode();
            }
            if (this.kycKey != null && !this.kycKey.equals(TokenCreateTransactionBody.DEFAULT.kycKey)) {
                result = 31 * result + this.kycKey.hashCode();
            }
            if (this.freezeKey != null && !this.freezeKey.equals(TokenCreateTransactionBody.DEFAULT.freezeKey)) {
                result = 31 * result + this.freezeKey.hashCode();
            }
            if (this.wipeKey != null && !this.wipeKey.equals(TokenCreateTransactionBody.DEFAULT.wipeKey)) {
                result = 31 * result + this.wipeKey.hashCode();
            }
            if (this.supplyKey != null && !this.supplyKey.equals(TokenCreateTransactionBody.DEFAULT.supplyKey)) {
                result = 31 * result + this.supplyKey.hashCode();
            }
            if (this.freezeDefault != TokenCreateTransactionBody.DEFAULT.freezeDefault) {
                result = 31 * result + Boolean.hashCode(this.freezeDefault);
            }
            if (this.expiry != null && !this.expiry.equals(TokenCreateTransactionBody.DEFAULT.expiry)) {
                result = 31 * result + this.expiry.hashCode();
            }
            if (this.autoRenewAccount != null && !this.autoRenewAccount.equals(TokenCreateTransactionBody.DEFAULT.autoRenewAccount)) {
                result = 31 * result + this.autoRenewAccount.hashCode();
            }
            if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(TokenCreateTransactionBody.DEFAULT.autoRenewPeriod)) {
                result = 31 * result + this.autoRenewPeriod.hashCode();
            }
            if (this.memo != null && !this.memo.equals(TokenCreateTransactionBody.DEFAULT.memo)) {
                result = 31 * result + this.memo.hashCode();
            }
            if (this.tokenType != null && !this.tokenType.equals((Object)TokenCreateTransactionBody.DEFAULT.tokenType)) {
                result = 31 * result + Integer.hashCode(this.tokenType.protoOrdinal());
            }
            if (this.supplyType != null && !this.supplyType.equals((Object)TokenCreateTransactionBody.DEFAULT.supplyType)) {
                result = 31 * result + Integer.hashCode(this.supplyType.protoOrdinal());
            }
            if (this.maxSupply != TokenCreateTransactionBody.DEFAULT.maxSupply) {
                result = 31 * result + Long.hashCode(this.maxSupply);
            }
            if (this.feeScheduleKey != null && !this.feeScheduleKey.equals(TokenCreateTransactionBody.DEFAULT.feeScheduleKey)) {
                result = 31 * result + this.feeScheduleKey.hashCode();
            }
            if ((list$customFees = this.customFees) != null) {
                for (CustomFee o : list$customFees) {
                    if (o != null) {
                        result = 31 * result + ((Object)o).hashCode();
                        continue;
                    }
                    result = 31 * result;
                }
            }
            if (this.pauseKey != null && !this.pauseKey.equals(TokenCreateTransactionBody.DEFAULT.pauseKey)) {
                result = 31 * result + this.pauseKey.hashCode();
            }
            if (this.metadata != null && !this.metadata.equals((Object)TokenCreateTransactionBody.DEFAULT.metadata)) {
                result = 31 * result + this.metadata.hashCode();
            }
            if (this.metadataKey != null && !this.metadataKey.equals(TokenCreateTransactionBody.DEFAULT.metadataKey)) {
                result = 31 * result + this.metadataKey.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenCreateTransactionBody thatObj = (TokenCreateTransactionBody)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.name == null && thatObj.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(thatObj.name)) {
            return false;
        }
        if (this.symbol == null && thatObj.symbol != null) {
            return false;
        }
        if (this.symbol != null && !this.symbol.equals(thatObj.symbol)) {
            return false;
        }
        if (this.decimals != thatObj.decimals) {
            return false;
        }
        if (this.initialSupply != thatObj.initialSupply) {
            return false;
        }
        if (this.treasury == null && thatObj.treasury != null) {
            return false;
        }
        if (this.treasury != null && !this.treasury.equals(thatObj.treasury)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.kycKey == null && thatObj.kycKey != null) {
            return false;
        }
        if (this.kycKey != null && !this.kycKey.equals(thatObj.kycKey)) {
            return false;
        }
        if (this.freezeKey == null && thatObj.freezeKey != null) {
            return false;
        }
        if (this.freezeKey != null && !this.freezeKey.equals(thatObj.freezeKey)) {
            return false;
        }
        if (this.wipeKey == null && thatObj.wipeKey != null) {
            return false;
        }
        if (this.wipeKey != null && !this.wipeKey.equals(thatObj.wipeKey)) {
            return false;
        }
        if (this.supplyKey == null && thatObj.supplyKey != null) {
            return false;
        }
        if (this.supplyKey != null && !this.supplyKey.equals(thatObj.supplyKey)) {
            return false;
        }
        if (this.freezeDefault != thatObj.freezeDefault) {
            return false;
        }
        if (this.expiry == null && thatObj.expiry != null) {
            return false;
        }
        if (this.expiry != null && !this.expiry.equals(thatObj.expiry)) {
            return false;
        }
        if (this.autoRenewAccount == null && thatObj.autoRenewAccount != null) {
            return false;
        }
        if (this.autoRenewAccount != null && !this.autoRenewAccount.equals(thatObj.autoRenewAccount)) {
            return false;
        }
        if (this.autoRenewPeriod == null && thatObj.autoRenewPeriod != null) {
            return false;
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(thatObj.autoRenewPeriod)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.tokenType == null && thatObj.tokenType != null) {
            return false;
        }
        if (this.tokenType != null && !this.tokenType.equals((Object)thatObj.tokenType)) {
            return false;
        }
        if (this.supplyType == null && thatObj.supplyType != null) {
            return false;
        }
        if (this.supplyType != null && !this.supplyType.equals((Object)thatObj.supplyType)) {
            return false;
        }
        if (this.maxSupply != thatObj.maxSupply) {
            return false;
        }
        if (this.feeScheduleKey == null && thatObj.feeScheduleKey != null) {
            return false;
        }
        if (this.feeScheduleKey != null && !this.feeScheduleKey.equals(thatObj.feeScheduleKey)) {
            return false;
        }
        if (this.customFees == null && thatObj.customFees != null) {
            return false;
        }
        if (this.customFees != null && !this.customFees.equals(thatObj.customFees)) {
            return false;
        }
        if (this.pauseKey == null && thatObj.pauseKey != null) {
            return false;
        }
        if (this.pauseKey != null && !this.pauseKey.equals(thatObj.pauseKey)) {
            return false;
        }
        if (this.metadata == null && thatObj.metadata != null) {
            return false;
        }
        if (this.metadata != null && !this.metadata.equals((Object)thatObj.metadata)) {
            return false;
        }
        if (this.metadataKey == null && thatObj.metadataKey != null) {
            return false;
        }
        if (this.metadataKey != null && !this.metadataKey.equals(thatObj.metadataKey)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "TokenCreateTransactionBody[name=" + this.name + ", symbol=" + this.symbol + ", decimals=" + this.decimals + ", initialSupply=" + this.initialSupply + ", treasury=" + String.valueOf(this.treasury) + ", adminKey=" + String.valueOf(this.adminKey) + ", kycKey=" + String.valueOf(this.kycKey) + ", freezeKey=" + String.valueOf(this.freezeKey) + ", wipeKey=" + String.valueOf(this.wipeKey) + ", supplyKey=" + String.valueOf(this.supplyKey) + ", freezeDefault=" + this.freezeDefault + ", expiry=" + String.valueOf(this.expiry) + ", autoRenewAccount=" + String.valueOf(this.autoRenewAccount) + ", autoRenewPeriod=" + String.valueOf(this.autoRenewPeriod) + ", memo=" + this.memo + ", tokenType=" + String.valueOf((Object)this.tokenType) + ", supplyType=" + String.valueOf((Object)this.supplyType) + ", maxSupply=" + this.maxSupply + ", feeScheduleKey=" + String.valueOf(this.feeScheduleKey) + ", customFees=" + String.valueOf(this.customFees) + ", pauseKey=" + String.valueOf(this.pauseKey) + ", metadata=" + String.valueOf(this.metadata) + ", metadataKey=" + String.valueOf(this.metadataKey) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasTreasury() {
        return this.treasury != null;
    }

    public AccountID treasuryOrElse(@NonNull AccountID defaultValue) {
        return this.hasTreasury() ? this.treasury : defaultValue;
    }

    @NonNull
    public AccountID treasuryOrThrow() {
        return Objects.requireNonNull(this.treasury, "Field treasury is null");
    }

    public void ifTreasury(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasTreasury()) {
            ifPresent.accept(this.treasury);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasKycKey() {
        return this.kycKey != null;
    }

    public Key kycKeyOrElse(@NonNull Key defaultValue) {
        return this.hasKycKey() ? this.kycKey : defaultValue;
    }

    @NonNull
    public Key kycKeyOrThrow() {
        return Objects.requireNonNull(this.kycKey, "Field kycKey is null");
    }

    public void ifKycKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKycKey()) {
            ifPresent.accept(this.kycKey);
        }
    }

    public boolean hasFreezeKey() {
        return this.freezeKey != null;
    }

    public Key freezeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFreezeKey() ? this.freezeKey : defaultValue;
    }

    @NonNull
    public Key freezeKeyOrThrow() {
        return Objects.requireNonNull(this.freezeKey, "Field freezeKey is null");
    }

    public void ifFreezeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFreezeKey()) {
            ifPresent.accept(this.freezeKey);
        }
    }

    public boolean hasWipeKey() {
        return this.wipeKey != null;
    }

    public Key wipeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasWipeKey() ? this.wipeKey : defaultValue;
    }

    @NonNull
    public Key wipeKeyOrThrow() {
        return Objects.requireNonNull(this.wipeKey, "Field wipeKey is null");
    }

    public void ifWipeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasWipeKey()) {
            ifPresent.accept(this.wipeKey);
        }
    }

    public boolean hasSupplyKey() {
        return this.supplyKey != null;
    }

    public Key supplyKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSupplyKey() ? this.supplyKey : defaultValue;
    }

    @NonNull
    public Key supplyKeyOrThrow() {
        return Objects.requireNonNull(this.supplyKey, "Field supplyKey is null");
    }

    public void ifSupplyKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSupplyKey()) {
            ifPresent.accept(this.supplyKey);
        }
    }

    public boolean hasExpiry() {
        return this.expiry != null;
    }

    public Timestamp expiryOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpiry() ? this.expiry : defaultValue;
    }

    @NonNull
    public Timestamp expiryOrThrow() {
        return Objects.requireNonNull(this.expiry, "Field expiry is null");
    }

    public void ifExpiry(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpiry()) {
            ifPresent.accept(this.expiry);
        }
    }

    public boolean hasAutoRenewAccount() {
        return this.autoRenewAccount != null;
    }

    public AccountID autoRenewAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccount() ? this.autoRenewAccount : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccount, "Field autoRenewAccount is null");
    }

    public void ifAutoRenewAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccount()) {
            ifPresent.accept(this.autoRenewAccount);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasFeeScheduleKey() {
        return this.feeScheduleKey != null;
    }

    public Key feeScheduleKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFeeScheduleKey() ? this.feeScheduleKey : defaultValue;
    }

    @NonNull
    public Key feeScheduleKeyOrThrow() {
        return Objects.requireNonNull(this.feeScheduleKey, "Field feeScheduleKey is null");
    }

    public void ifFeeScheduleKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFeeScheduleKey()) {
            ifPresent.accept(this.feeScheduleKey);
        }
    }

    public boolean hasPauseKey() {
        return this.pauseKey != null;
    }

    public Key pauseKeyOrElse(@NonNull Key defaultValue) {
        return this.hasPauseKey() ? this.pauseKey : defaultValue;
    }

    @NonNull
    public Key pauseKeyOrThrow() {
        return Objects.requireNonNull(this.pauseKey, "Field pauseKey is null");
    }

    public void ifPauseKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasPauseKey()) {
            ifPresent.accept(this.pauseKey);
        }
    }

    public boolean hasMetadataKey() {
        return this.metadataKey != null;
    }

    public Key metadataKeyOrElse(@NonNull Key defaultValue) {
        return this.hasMetadataKey() ? this.metadataKey : defaultValue;
    }

    @NonNull
    public Key metadataKeyOrThrow() {
        return Objects.requireNonNull(this.metadataKey, "Field metadataKey is null");
    }

    public void ifMetadataKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasMetadataKey()) {
            ifPresent.accept(this.metadataKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.name, this.symbol, this.decimals, this.initialSupply, this.treasury, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.freezeDefault, this.expiry, this.autoRenewAccount, this.autoRenewPeriod, this.memo, this.tokenType, this.supplyType, this.maxSupply, this.feeScheduleKey, this.customFees, this.pauseKey, this.metadata, this.metadataKey, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @NonNull
        private String name = "";
        @NonNull
        private String symbol = "";
        private int decimals = 0;
        private long initialSupply = 0L;
        @Nullable
        private AccountID treasury = null;
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Key kycKey = null;
        @Nullable
        private Key freezeKey = null;
        @Nullable
        private Key wipeKey = null;
        @Nullable
        private Key supplyKey = null;
        private boolean freezeDefault = false;
        @Nullable
        private Timestamp expiry = null;
        @Nullable
        private AccountID autoRenewAccount = null;
        @Nullable
        private Duration autoRenewPeriod = null;
        @NonNull
        private String memo = "";
        private TokenType tokenType = TokenType.fromProtobufOrdinal(0);
        private TokenSupplyType supplyType = TokenSupplyType.fromProtobufOrdinal(0);
        private long maxSupply = 0L;
        @Nullable
        private Key feeScheduleKey = null;
        @NonNull
        private List<CustomFee> customFees = Collections.emptyList();
        @Nullable
        private Key pauseKey = null;
        @NonNull
        private Bytes metadata = Bytes.EMPTY;
        @Nullable
        private Key metadataKey = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(String name, String symbol, int decimals, long initialSupply, AccountID treasury, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, boolean freezeDefault, Timestamp expiry, AccountID autoRenewAccount, Duration autoRenewPeriod, String memo, TokenType tokenType, TokenSupplyType supplyType, long maxSupply, Key feeScheduleKey, List<CustomFee> customFees, Key pauseKey, Bytes metadata, Key metadataKey) {
            this.$unknownFields = null;
            this.name = name != null ? name : "";
            this.symbol = symbol != null ? symbol : "";
            this.decimals = decimals;
            this.initialSupply = initialSupply;
            this.treasury = treasury;
            this.adminKey = adminKey;
            this.kycKey = kycKey;
            this.freezeKey = freezeKey;
            this.wipeKey = wipeKey;
            this.supplyKey = supplyKey;
            this.freezeDefault = freezeDefault;
            this.expiry = expiry;
            this.autoRenewAccount = autoRenewAccount;
            this.autoRenewPeriod = autoRenewPeriod;
            this.memo = memo != null ? memo : "";
            this.tokenType = tokenType;
            this.supplyType = supplyType;
            this.maxSupply = maxSupply;
            this.feeScheduleKey = feeScheduleKey;
            this.customFees = customFees == null ? Collections.emptyList() : customFees;
            this.pauseKey = pauseKey;
            this.metadata = metadata != null ? metadata : Bytes.EMPTY;
            this.metadataKey = metadataKey;
        }

        public Builder(String name, String symbol, int decimals, long initialSupply, AccountID treasury, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, boolean freezeDefault, Timestamp expiry, AccountID autoRenewAccount, Duration autoRenewPeriod, String memo, TokenType tokenType, TokenSupplyType supplyType, long maxSupply, Key feeScheduleKey, List<CustomFee> customFees, Key pauseKey, Bytes metadata, Key metadataKey, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.name = name != null ? name : "";
            this.symbol = symbol != null ? symbol : "";
            this.decimals = decimals;
            this.initialSupply = initialSupply;
            this.treasury = treasury;
            this.adminKey = adminKey;
            this.kycKey = kycKey;
            this.freezeKey = freezeKey;
            this.wipeKey = wipeKey;
            this.supplyKey = supplyKey;
            this.freezeDefault = freezeDefault;
            this.expiry = expiry;
            this.autoRenewAccount = autoRenewAccount;
            this.autoRenewPeriod = autoRenewPeriod;
            this.memo = memo != null ? memo : "";
            this.tokenType = tokenType;
            this.supplyType = supplyType;
            this.maxSupply = maxSupply;
            this.feeScheduleKey = feeScheduleKey;
            this.customFees = customFees == null ? Collections.emptyList() : customFees;
            this.pauseKey = pauseKey;
            this.metadata = metadata != null ? metadata : Bytes.EMPTY;
            this.metadataKey = metadataKey;
        }

        public TokenCreateTransactionBody build() {
            return new TokenCreateTransactionBody(this.name, this.symbol, this.decimals, this.initialSupply, this.treasury, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.freezeDefault, this.expiry, this.autoRenewAccount, this.autoRenewPeriod, this.memo, this.tokenType, this.supplyType, this.maxSupply, this.feeScheduleKey, this.customFees, this.pauseKey, this.metadata, this.metadataKey);
        }

        public Builder name(@NonNull String name) {
            this.name = name != null ? name : "";
            return this;
        }

        public Builder symbol(@NonNull String symbol) {
            this.symbol = symbol != null ? symbol : "";
            return this;
        }

        public Builder decimals(int decimals) {
            this.decimals = decimals;
            return this;
        }

        public Builder initialSupply(long initialSupply) {
            this.initialSupply = initialSupply;
            return this;
        }

        public Builder treasury(@Nullable AccountID treasury) {
            this.treasury = treasury;
            return this;
        }

        public Builder treasury(AccountID.Builder builder) {
            this.treasury = builder.build();
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder kycKey(@Nullable Key kycKey) {
            this.kycKey = kycKey;
            return this;
        }

        public Builder kycKey(Key.Builder builder) {
            this.kycKey = builder.build();
            return this;
        }

        public Builder freezeKey(@Nullable Key freezeKey) {
            this.freezeKey = freezeKey;
            return this;
        }

        public Builder freezeKey(Key.Builder builder) {
            this.freezeKey = builder.build();
            return this;
        }

        public Builder wipeKey(@Nullable Key wipeKey) {
            this.wipeKey = wipeKey;
            return this;
        }

        public Builder wipeKey(Key.Builder builder) {
            this.wipeKey = builder.build();
            return this;
        }

        public Builder supplyKey(@Nullable Key supplyKey) {
            this.supplyKey = supplyKey;
            return this;
        }

        public Builder supplyKey(Key.Builder builder) {
            this.supplyKey = builder.build();
            return this;
        }

        public Builder freezeDefault(boolean freezeDefault) {
            this.freezeDefault = freezeDefault;
            return this;
        }

        public Builder expiry(@Nullable Timestamp expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder expiry(Timestamp.Builder builder) {
            this.expiry = builder.build();
            return this;
        }

        public Builder autoRenewAccount(@Nullable AccountID autoRenewAccount) {
            this.autoRenewAccount = autoRenewAccount;
            return this;
        }

        public Builder autoRenewAccount(AccountID.Builder builder) {
            this.autoRenewAccount = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(@Nullable Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder memo(@NonNull String memo) {
            this.memo = memo != null ? memo : "";
            return this;
        }

        public Builder tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder supplyType(TokenSupplyType supplyType) {
            this.supplyType = supplyType;
            return this;
        }

        public Builder maxSupply(long maxSupply) {
            this.maxSupply = maxSupply;
            return this;
        }

        public Builder feeScheduleKey(@Nullable Key feeScheduleKey) {
            this.feeScheduleKey = feeScheduleKey;
            return this;
        }

        public Builder feeScheduleKey(Key.Builder builder) {
            this.feeScheduleKey = builder.build();
            return this;
        }

        public Builder customFees(@NonNull List<CustomFee> customFees) {
            this.customFees = customFees != null ? customFees : Collections.emptyList();
            return this;
        }

        public Builder customFees(CustomFee ... values) {
            this.customFees = values == null ? Collections.emptyList() : List.of(values);
            return this;
        }

        public Builder pauseKey(@Nullable Key pauseKey) {
            this.pauseKey = pauseKey;
            return this;
        }

        public Builder pauseKey(Key.Builder builder) {
            this.pauseKey = builder.build();
            return this;
        }

        public Builder metadata(@NonNull Bytes metadata) {
            this.metadata = metadata != null ? metadata : Bytes.EMPTY;
            return this;
        }

        public Builder metadataKey(@Nullable Key metadataKey) {
            this.metadataKey = metadataKey;
            return this;
        }

        public Builder metadataKey(Key.Builder builder) {
            this.metadataKey = builder.build();
            return this;
        }

        public String name() {
            return this.name;
        }

        public String symbol() {
            return this.symbol;
        }

        public int decimals() {
            return this.decimals;
        }

        public long initialSupply() {
            return this.initialSupply;
        }

        public AccountID treasury() {
            return this.treasury;
        }

        public Key adminKey() {
            return this.adminKey;
        }

        public Key kycKey() {
            return this.kycKey;
        }

        public Key freezeKey() {
            return this.freezeKey;
        }

        public Key wipeKey() {
            return this.wipeKey;
        }

        public Key supplyKey() {
            return this.supplyKey;
        }

        public boolean freezeDefault() {
            return this.freezeDefault;
        }

        public Timestamp expiry() {
            return this.expiry;
        }

        public AccountID autoRenewAccount() {
            return this.autoRenewAccount;
        }

        public Duration autoRenewPeriod() {
            return this.autoRenewPeriod;
        }

        public String memo() {
            return this.memo;
        }

        public TokenType tokenType() {
            return this.tokenType;
        }

        public TokenSupplyType supplyType() {
            return this.supplyType;
        }

        public long maxSupply() {
            return this.maxSupply;
        }

        public Key feeScheduleKey() {
            return this.feeScheduleKey;
        }

        public List<CustomFee> customFees() {
            return this.customFees;
        }

        public Key pauseKey() {
            return this.pauseKey;
        }

        public Bytes metadata() {
            return this.metadata;
        }

        public Key metadataKey() {
            return this.metadataKey;
        }
    }
}

