/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SidecarMetadata;
import com.hedera.hapi.streams.SidecarType;
import com.hedera.hapi.streams.schema.SidecarMetadataSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SidecarMetadataJsonCodec
implements JsonCodec<SidecarMetadata> {
    @NonNull
    public SidecarMetadata parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            HashObject temp_hash = null;
            int temp_id = 0;
            List<SidecarType> temp_types = Collections.emptyList();
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "hash": {
                        temp_hash = (HashObject)HashObject.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1, maxSize);
                        continue block12;
                    }
                    case "id": {
                        temp_id = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                    case "types": {
                        temp_types = JsonTools.checkSize((String)"types", (List)kvPair.value().arr().value(), (int)maxSize).stream().map(v -> SidecarType.fromString(v.STRING().getText())).toList();
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new SidecarMetadata(temp_hash, temp_id, temp_types);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull SidecarMetadata data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.hash() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"hash", HashObject.JSON, (Object)data.hash()));
        }
        if (data.id() != 0) {
            fieldLines.add(JsonTools.field((String)"id", (int)data.id()));
        }
        if (!data.types().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"types", (FieldDefinition)SidecarMetadataSchema.TYPES, data.types()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

