/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.node.app.spi.fees.ExchangeRateInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;

public class ExchangeRateInfoImpl
implements ExchangeRateInfo {
    private final ExchangeRateSet exchangeRateSet;
    private final ExchangeRate currentRate;
    private final ExchangeRate nextRate;
    private final long expirationSeconds;

    public ExchangeRateInfoImpl(@NonNull ExchangeRateSet exchangeRateSet) {
        this.exchangeRateSet = Objects.requireNonNull(exchangeRateSet, "exchangeRateSet must not be null");
        this.currentRate = exchangeRateSet.currentRateOrThrow();
        this.nextRate = exchangeRateSet.nextRateOrThrow();
        this.expirationSeconds = this.currentRate.expirationTimeOrThrow().seconds();
    }

    @NonNull
    public ExchangeRateSet exchangeRates() {
        return this.exchangeRateSet;
    }

    @NonNull
    public ExchangeRate activeRate(@NonNull Instant consensusTime) {
        return consensusTime.getEpochSecond() >= this.expirationSeconds ? this.nextRate : this.currentRate;
    }
}

