/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl.handlers;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.scheduled.ScheduleGetInfoQuery;
import com.hedera.hapi.node.scheduled.ScheduleGetInfoResponse;
import com.hedera.hapi.node.scheduled.ScheduleInfo;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.fees.usage.schedule.ExtantScheduleContext;
import com.hedera.node.app.hapi.fees.usage.schedule.ScheduleOpsUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.schedule.impl.handlers.HandlerUtility;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.LedgerConfig;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Query;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScheduleGetInfoHandler
extends PaidQueryHandler {
    private final ScheduleOpsUsage legacyUsage;

    @Inject
    public ScheduleGetInfoHandler(ScheduleOpsUsage legacyUsage) {
        this.legacyUsage = legacyUsage;
    }

    public QueryHeader extractHeader(@NonNull com.hedera.hapi.node.transaction.Query query) {
        Objects.requireNonNull(query);
        ScheduleGetInfoQuery expectedQuery = query.scheduleGetInfo();
        return expectedQuery != null ? expectedQuery.header() : null;
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        ScheduleGetInfoResponse.Builder response = ScheduleGetInfoResponse.newBuilder().header(header);
        return Response.newBuilder().scheduleGetInfo(response).build();
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext context) {
        Schedule found = this.findSchedule(context);
        if (found != null) {
            LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
            ScheduleInfo.Builder builder = ScheduleInfo.newBuilder();
            this.buildFromSchedule(builder, found, ledgerConfig);
            return context.feeCalculator().legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.Query)context.query()), CommonPbjConverters.fromPbj((ScheduleInfo)builder.build())));
        }
        return context.feeCalculator().calculate();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ScheduleGetInfoQuery request = context.query().scheduleGetInfo();
        if (request != null && request.hasHeader()) {
            if (this.findSchedule(context) == null) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_SCHEDULE_ID);
            }
        } else {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION);
        }
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        ScheduleGetInfoResponse.Builder infoBuilder = ScheduleGetInfoResponse.newBuilder();
        infoBuilder.header(header);
        if (this.shouldHandle(context, header)) {
            Schedule scheduleFound = this.findSchedule(context);
            if (scheduleFound != null) {
                ScheduleInfo.Builder builder = ScheduleInfo.newBuilder();
                this.buildFromSchedule(builder, scheduleFound, ledgerConfig);
                infoBuilder.scheduleInfo(builder);
            } else {
                infoBuilder.header(header.copyBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.INVALID_SCHEDULE_ID));
            }
        }
        return Response.newBuilder().scheduleGetInfo(infoBuilder).build();
    }

    private boolean shouldHandle(QueryContext context, ResponseHeader header) {
        ScheduleGetInfoQuery query = context.query().scheduleGetInfo();
        return query != null && query.header() != null && query.hasScheduleID() && query.header().responseType() != ResponseType.COST_ANSWER && header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK;
    }

    private void buildFromSchedule(ScheduleInfo.Builder builder, Schedule scheduleFound, LedgerConfig config) {
        builder.adminKey(scheduleFound.adminKey());
        builder.creatorAccountID(scheduleFound.schedulerAccountId());
        builder.waitForExpiry(scheduleFound.waitForExpiry());
        builder.scheduleID(scheduleFound.scheduleId());
        builder.memo(scheduleFound.memo());
        builder.payerAccountID(scheduleFound.payerAccountId());
        builder.ledgerId(config.id());
        if (scheduleFound.executed()) {
            builder.executionTime(scheduleFound.resolutionTime());
        }
        if (scheduleFound.deleted()) {
            builder.deletionTime(scheduleFound.resolutionTime());
        }
        builder.scheduledTransactionID(HandlerUtility.transactionIdForScheduled(scheduleFound));
        builder.expirationTime(this.timestampFromSeconds(scheduleFound.calculatedExpirationSecond()));
        builder.signers(this.makeKeyList(scheduleFound.signatories()));
        builder.scheduledTransactionBody(scheduleFound.scheduledTransaction());
    }

    private KeyList makeKeyList(List<Key> signatories) {
        return KeyList.newBuilder().keys(signatories).build();
    }

    private Schedule findSchedule(QueryContext context) {
        com.hedera.hapi.node.transaction.Query contextQuery = context.query();
        ReadableScheduleStore queryStore = (ReadableScheduleStore)context.createStore(ReadableScheduleStore.class);
        ScheduleGetInfoQuery scheduleQuery = contextQuery.scheduleGetInfoOrThrow();
        ScheduleID idToQuery = scheduleQuery.scheduleID();
        return idToQuery != null ? queryStore.get(idToQuery) : null;
    }

    private Timestamp.Builder timestampFromSeconds(long secondsSinceEpoch) {
        return Timestamp.newBuilder().seconds(secondsSinceEpoch).nanos(0);
    }

    public FeeData usageGiven(Query query, com.hederahashgraph.api.proto.java.ScheduleInfo info) {
        if (info != null) {
            ExtantScheduleContext.Builder scheduleCtxBuilder = ExtantScheduleContext.newBuilder().setScheduledTxn(info.getScheduledTransactionBody()).setMemo(info.getMemo()).setNumSigners(info.getSigners().getKeysCount()).setResolved(info.hasExecutionTime() || info.hasDeletionTime());
            if (info.hasAdminKey()) {
                scheduleCtxBuilder.setAdminKey(info.getAdminKey());
            } else {
                scheduleCtxBuilder.setNoAdminKey();
            }
            return this.legacyUsage.scheduleInfoUsage(query, scheduleCtxBuilder.build());
        }
        return Fees.CONSTANT_FEE_DATA;
    }
}

