/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.util.Comparator;
import java.util.stream.Stream;

public interface HardforkId {
    public String name();

    public boolean finalized();

    public String description();

    public static enum ClassicHardforkId implements HardforkId
    {
        FRONTIER(true, "Frontier"),
        HOMESTEAD(true, "Homestead"),
        CLASSIC_TANGERINE_WHISTLE(true, "Classic Tangerine Whistle"),
        DIE_HARD(true, "Die Hard"),
        GOTHAM(true, "Gotham"),
        DEFUSE_DIFFICULTY_BOMB(true, "Defuse Difficulty Bomb"),
        ATLANTIS(true, "Atlantis"),
        AGHARTA(true, "Agharta"),
        PHOENIX(true, "Phoenix"),
        THANOS(true, "Thanos"),
        MAGNETO(true, "Magneto"),
        MYSTIQUE(true, "Mystique"),
        SPIRAL(true, "Spiral");

        final boolean finalized;
        final String description;

        private ClassicHardforkId(boolean finalized, String description) {
            this.finalized = finalized;
            this.description = description;
        }

        @Override
        public boolean finalized() {
            return this.finalized;
        }

        @Override
        public String description() {
            return this.description;
        }
    }

    public static enum MainnetHardforkId implements HardforkId
    {
        FRONTIER(true, "Frontier"),
        HOMESTEAD(true, "Homestead"),
        DAO_FORK(true, "DAO Fork"),
        TANGERINE_WHISTLE(true, "Tangerine Whistle"),
        SPURIOUS_DRAGON(true, "Spurious Dragon"),
        BYZANTIUM(true, "Byzantium"),
        CONSTANTINOPLE(true, "Constantinople"),
        PETERSBURG(true, "Petersburg"),
        ISTANBUL(true, "Istanbul"),
        MUIR_GLACIER(true, "Muir Glacier"),
        BERLIN(true, "Berlin"),
        LONDON(true, "London"),
        ARROW_GLACIER(true, "Arrow Glacier"),
        GRAY_GLACIER(true, "Gray Glacier"),
        PARIS(true, "Paris"),
        SHANGHAI(true, "Shanghai"),
        CANCUN(true, "Cancun"),
        CANCUN_EOF(false, "Cancun + EOF"),
        PRAGUE(false, "Prague"),
        OSAKA(false, "Osaka"),
        AMSTERDAM(false, "Amsterdam"),
        BOGOTA(false, "Bogota"),
        POLIS(false, "Polis"),
        BANGKOK(false, "Bangkok"),
        FUTURE_EIPS(false, "Development, for accepted and unscheduled EIPs"),
        EXPERIMENTAL_EIPS(false, "Developmental, for experimental EIPs");

        final boolean finalized;
        final String description;

        private MainnetHardforkId(boolean finalized, String description) {
            this.finalized = finalized;
            this.description = description;
        }

        @Override
        public boolean finalized() {
            return this.finalized;
        }

        @Override
        public String description() {
            return this.description;
        }

        public static MainnetHardforkId mostRecent() {
            return Stream.of(MainnetHardforkId.values()).filter(MainnetHardforkId::finalized).max(Comparator.naturalOrder()).orElseThrow();
        }
    }
}

