/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.platform;

import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.hiero.consensus.metrics.DurationGauge;

public class PlatformDurationGauge
extends AbstractMetric
implements DurationGauge {
    private final AtomicLong nanos;
    private final ChronoUnit unit;

    public PlatformDurationGauge(@NonNull DurationGauge.Config config) {
        super((MetricConfig)config);
        this.unit = config.getTimeUnit();
        this.nanos = new AtomicLong();
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, (Object)this.get()));
    }

    private double getAsDouble() {
        return this.nanos.get();
    }

    @Override
    public long getNanos() {
        return this.nanos.get();
    }

    @Override
    public void set(Duration duration) {
        if (duration == null) {
            return;
        }
        this.nanos.set(duration.toNanos());
    }

    @Override
    public double get() {
        return this.getAsDouble() / (double)this.unit.getDuration().toNanos();
    }
}

