/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.common.uri.UriValidator;
import java.util.Objects;

public class UriValidationException
extends IllegalArgumentException {
    private final Segment segment;
    private final char[] invalidValue;

    public UriValidationException(Segment segment, char[] invalidValue, String message) {
        super(UriValidationException.toMessage(invalidValue, message));
        this.segment = segment;
        this.invalidValue = invalidValue;
    }

    UriValidationException(Segment segment, char[] invalidValue, char[] validated, String message) {
        super(UriValidationException.toMessage(invalidValue, validated, message));
        this.segment = segment;
        this.invalidValue = invalidValue;
    }

    UriValidationException(Segment segment, char[] invalidValue, char[] validated, String message, int index, char c) {
        super(UriValidationException.toMessage(invalidValue, validated, message, index, c));
        this.segment = segment;
        this.invalidValue = invalidValue;
    }

    UriValidationException(Segment segment, char[] invalidValue, String message, int index, char c) {
        super(UriValidationException.toMessage(invalidValue, message, index, c));
        this.segment = segment;
        this.invalidValue = invalidValue;
    }

    public char[] invalidValue() {
        return this.invalidValue;
    }

    public Segment segment() {
        return this.segment;
    }

    private static String toMessage(char[] value, String message) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(message);
        if (value.length == 0) {
            return message;
        }
        return message + ": " + UriValidator.encode(value);
    }

    private static String toMessage(char[] value, char[] validated, String message) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(message);
        Objects.requireNonNull(validated);
        if (validated.length == 0) {
            if (value.length == 0) {
                return message;
            }
            return message + ". Value: " + UriValidator.encode(value);
        }
        if (value.length == 0) {
            return message + ": " + UriValidator.encode(validated);
        }
        return message + ": " + UriValidator.encode(validated) + ". Value: " + UriValidator.encode(value);
    }

    private static String toMessage(char[] value, char[] validated, String message, int index, char c) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(validated);
        Objects.requireNonNull(message);
        return message + ": " + UriValidator.encode(validated) + ", index: " + index + ", char: " + UriValidator.print(c) + ". Value: " + UriValidator.encode(value);
    }

    private static String toMessage(char[] value, String message, int index, char c) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(message);
        return message + ": " + UriValidator.encode(value) + ", index: " + index + ", char: " + UriValidator.print(c);
    }

    public static enum Segment {
        SCHEME("Scheme"),
        HOST("Host"),
        PATH("Path"),
        QUERY("Query"),
        FRAGMENT("Fragment");

        private final String name;

        private Segment(String name) {
            this.name = name;
        }

        public String text() {
            return this.name;
        }
    }
}

