/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.state.token.AccountPendingAirdrop;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.token.TokenClaimAirdropTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableAirdropStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableAirdropStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContextImpl;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferExecutor;
import com.hedera.node.app.service.token.impl.handlers.transfer.hooks.HookCallsFactory;
import com.hedera.node.app.service.token.impl.util.AirdropHandlerHelper;
import com.hedera.node.app.service.token.impl.util.PendingAirdropUpdater;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.CryptoTransferValidator;
import com.hedera.node.app.service.token.impl.validators.TokenAirdropValidator;
import com.hedera.node.app.service.token.records.CryptoTransferStreamBuilder;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenClaimAirdropHandler
extends TransferExecutor
implements TransactionHandler {
    private final TokenAirdropValidator validator;
    private final PendingAirdropUpdater pendingAirdropUpdater;

    @Inject
    public TokenClaimAirdropHandler(@NonNull TokenAirdropValidator validator, @NonNull CryptoTransferValidator cryptoTransferValidator, @NonNull PendingAirdropUpdater pendingAirdropUpdater, @NonNull HookCallsFactory hookCallsFactory, @NonNull EntityIdFactory entityIdFactory) {
        super(cryptoTransferValidator, hookCallsFactory, entityIdFactory);
        this.validator = validator;
        this.pendingAirdropUpdater = pendingAirdropUpdater;
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenClaimAirdropTransactionBody op = Objects.requireNonNull(context.body().tokenClaimAirdrop());
        List pendingAirdrops = op.pendingAirdrops();
        for (PendingAirdropId pendingAirdrop : pendingAirdrops) {
            AccountID receiverId = pendingAirdrop.receiverIdOrThrow();
            context.requireAliasedKeyOrThrow(receiverId, ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        TokenClaimAirdropTransactionBody op = txn.tokenClaimAirdrop();
        Objects.requireNonNull(op);
        List pendingAirdrops = op.pendingAirdrops();
        PreCheckException.validateTruePreCheck((!pendingAirdrops.isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.EMPTY_PENDING_AIRDROP_ID_LIST);
        Set uniqueAirdrops = Set.copyOf(pendingAirdrops);
        PreCheckException.validateTruePreCheck((pendingAirdrops.size() == uniqueAirdrops.size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.PENDING_AIRDROP_ID_REPEATED);
        PreCheckException.validateTruePreCheck((boolean)pendingAirdrops.stream().allMatch(PendingAirdropId::hasSenderId), (ResponseCodeEnum)ResponseCodeEnum.INVALID_PENDING_AIRDROP_ID);
        PreCheckException.validateTruePreCheck((boolean)pendingAirdrops.stream().allMatch(PendingAirdropId::hasReceiverId), (ResponseCodeEnum)ResponseCodeEnum.INVALID_PENDING_AIRDROP_ID);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        TokenClaimAirdropTransactionBody op = context.body().tokenClaimAirdropOrThrow();
        WritableAirdropStore pendingAirdropStore = (WritableAirdropStore)context.storeFactory().writableStore(WritableAirdropStore.class);
        WritableAccountStore accountStore = (WritableAccountStore)context.storeFactory().writableStore(WritableAccountStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.storeFactory().readableStore(ReadableTokenStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)context.storeFactory().writableStore(WritableTokenRelationStore.class);
        CryptoTransferStreamBuilder recordBuilder = (CryptoTransferStreamBuilder)context.savepointStack().getBaseBuilder(CryptoTransferStreamBuilder.class);
        Set<PendingAirdropId> validatedAirdropIds = this.validateSemantics(context, op, accountStore);
        HashMap<TokenID, TokenTransferList> transfers = new HashMap<TokenID, TokenTransferList>();
        LinkedHashMap<AccountID, Set> tokensToAssociate = new LinkedHashMap<AccountID, Set>();
        for (PendingAirdropId pendingAirdropId : validatedAirdropIds) {
            TokenID tokenId = pendingAirdropId.hasFungibleTokenType() ? pendingAirdropId.fungibleTokenTypeOrThrow() : pendingAirdropId.nonFungibleTokenOrThrow().tokenIdOrThrow();
            AccountID senderId = pendingAirdropId.senderIdOrThrow();
            AccountID receiverId = pendingAirdropId.receiverIdOrThrow();
            this.createOrUpdateTransfers(pendingAirdropId, pendingAirdropStore, tokenId, senderId, receiverId, transfers);
            if (tokenRelStore.get(receiverId, tokenId) != null) continue;
            tokensToAssociate.computeIfAbsent(receiverId, k -> new LinkedHashSet()).add(TokenHandlerHelper.getIfUsable(tokenId, tokenStore));
        }
        for (Map.Entry entry : tokensToAssociate.entrySet()) {
            this.associateForFree(((Set)entry.getValue()).stream().toList(), (AccountID)entry.getKey(), accountStore, tokenRelStore);
        }
        this.transferForFree(new ArrayList<TokenTransferList>(transfers.values()), context, recordBuilder);
        this.pendingAirdropUpdater.removePendingAirdrops(validatedAirdropIds, pendingAirdropStore, accountStore);
    }

    private Set<PendingAirdropId> validateSemantics(@NonNull HandleContext context, @NonNull TokenClaimAirdropTransactionBody op, @NonNull ReadableAccountStore accountStore) throws HandleException {
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        HandleException.validateTrue((op.pendingAirdrops().size() <= tokensConfig.maxAllowedPendingAirdropsToClaim() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.PENDING_AIRDROP_ID_LIST_TOO_LONG);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.storeFactory().readableStore(ReadableTokenStore.class);
        ReadableAirdropStore pendingAirdropStore = (ReadableAirdropStore)context.storeFactory().readableStore(ReadableAirdropStore.class);
        Set<PendingAirdropId> standardAirdropIds = AirdropHandlerHelper.standardizeAirdropIds(accountStore, pendingAirdropStore, op.pendingAirdrops(), EnumSet.of(AirdropHandlerHelper.IdType.RECEIVER));
        for (PendingAirdropId airdrop : standardAirdropIds) {
            TokenID tokenId = airdrop.hasFungibleTokenType() ? airdrop.fungibleTokenTypeOrThrow() : airdrop.nonFungibleTokenOrThrow().tokenIdOrThrow();
            TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
            HandleException.validateTrue((boolean)this.validator.tokenHasNoRoyaltyWithFallbackFee(tokenId, tokenStore), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_AIRDROP_WITH_FALLBACK_ROYALTY);
        }
        return standardAirdropIds;
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TokensConfig tokensConfig = (TokensConfig)feeContext.configuration().getConfigData(TokensConfig.class);
        HandleException.validateTrue((boolean)tokensConfig.airdropsClaimEnabled(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        FeeCalculator feeCalculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        feeCalculator.resetUsage();
        return feeCalculator.addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1)).calculate();
    }

    private void createOrUpdateTransfers(@NonNull PendingAirdropId airdrop, @NonNull WritableAirdropStore airdropStore, @NonNull TokenID tokenId, @NonNull AccountID senderId, @NonNull AccountID receiverId, @NonNull Map<TokenID, TokenTransferList> transfers) {
        AccountPendingAirdrop accountPendingAirdrop = Objects.requireNonNull(airdropStore.get(airdrop));
        TokenTransferList soFar = transfers.computeIfAbsent(tokenId, k -> TokenTransferList.newBuilder().token(tokenId).build());
        if (airdrop.hasFungibleTokenType()) {
            AccountAmount senderAccountAmount = TokenClaimAirdropHandler.asAccountAmount(senderId, -accountPendingAirdrop.pendingAirdropValueOrThrow().amount());
            AccountAmount receiverAccountAmount = TokenClaimAirdropHandler.asAccountAmount(receiverId, accountPendingAirdrop.pendingAirdropValueOrThrow().amount());
            ArrayList<AccountAmount> newTransfers = new ArrayList<AccountAmount>(soFar.transfers());
            this.mergeTransfer(newTransfers, senderAccountAmount);
            this.mergeTransfer(newTransfers, receiverAccountAmount);
            transfers.put(tokenId, soFar.copyBuilder().transfers(newTransfers).build());
        } else {
            NftTransfer nftTransfer = NftTransfer.newBuilder().senderAccountID(senderId).receiverAccountID(receiverId).serialNumber(airdrop.nonFungibleTokenOrThrow().serialNumber()).build();
            ArrayList<NftTransfer> newTransfers = new ArrayList<NftTransfer>(soFar.nftTransfers());
            newTransfers.add(nftTransfer);
            transfers.put(tokenId, soFar.copyBuilder().nftTransfers(newTransfers).build());
        }
    }

    private void mergeTransfer(@NonNull List<AccountAmount> transfers, @NonNull AccountAmount newTransfer) {
        AccountID accountId = newTransfer.accountIDOrThrow();
        int n = transfers.size();
        for (int i = 0; i < n; ++i) {
            if (!transfers.get(i).accountIDOrThrow().equals((Object)accountId)) continue;
            AccountAmount updatedTransfer = transfers.get(i).copyBuilder().amount(transfers.get(i).amount() + newTransfer.amount()).build();
            transfers.set(i, updatedTransfer);
            return;
        }
        transfers.add(newTransfer);
    }

    private void associateForFree(@NonNull List<Token> tokensToAssociate, @NonNull AccountID receiverId, @NonNull WritableAccountStore accountStore, @NonNull WritableTokenRelationStore tokenRelStore) {
        this.createAndLinkTokenRels(Objects.requireNonNull(accountStore.getAccountById(receiverId)), tokensToAssociate, accountStore, tokenRelStore);
    }

    private void transferForFree(@NonNull List<TokenTransferList> transfers, @NonNull HandleContext context, @NonNull CryptoTransferStreamBuilder recordBuilder) {
        CryptoTransferTransactionBody cryptoTransferBody = CryptoTransferTransactionBody.newBuilder().tokenTransfers(transfers).build();
        TransactionBody syntheticCryptoTransferTxn = TransactionBody.newBuilder().cryptoTransfer(cryptoTransferBody).build();
        TransferContextImpl transferContext = new TransferContextImpl(context, cryptoTransferBody, true);
        this.executeCryptoTransferWithoutCustomFee(syntheticCryptoTransferTxn, transferContext, context, recordBuilder);
    }

    public static AccountAmount asAccountAmount(AccountID account, long amount) {
        return AccountAmount.newBuilder().accountID(account).amount(amount).build();
    }
}

