/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.cryptography.wraps;

import com.hedera.common.nativesupport.SingletonLoader;
import com.hedera.cryptography.wraps.Proof;
import com.hedera.cryptography.wraps.SchnorrKeys;
import java.util.Arrays;

public class WRAPSLibraryBridge {
    private static final SingletonLoader<WRAPSLibraryBridge> INSTANCE_HOLDER = new SingletonLoader("wraps", (Object)new WRAPSLibraryBridge());
    private static final long MAX_SUM_OF_WEIGHTS = Long.MAX_VALUE;
    public static final int ENTROPY_SIZE = 32;
    private static final byte[][] EMPTY_BYTE_ARRAY_2;

    private WRAPSLibraryBridge() {
    }

    public static WRAPSLibraryBridge getInstance() {
        return (WRAPSLibraryBridge)INSTANCE_HOLDER.getInstance();
    }

    public static boolean isProofSupported() {
        String path = System.getenv("TSS_LIB_WRAPS_ARTIFACTS_PATH");
        return path != null && !path.isBlank();
    }

    public SchnorrKeys generateSchnorrKeys(byte[] seed) {
        if (seed == null || seed.length != 32) {
            return null;
        }
        return this.generateSchnorrKeysImpl(seed);
    }

    private native SchnorrKeys generateSchnorrKeysImpl(byte[] var1);

    public byte[] runSigningProtocolPhase(SigningProtocolPhase phase, byte[] instanceEntropy, byte[] messageToSign, byte[] schnorrPrivateKey, byte[][] schnorrPublicKeys, byte[][] round1Messages, byte[][] round2Messages, byte[][] round3Messages) {
        if (phase == null || messageToSign == null) {
            return null;
        }
        if (schnorrPublicKeys == null) {
            schnorrPublicKeys = EMPTY_BYTE_ARRAY_2;
        }
        if (round1Messages == null) {
            round1Messages = EMPTY_BYTE_ARRAY_2;
        }
        if (round2Messages == null) {
            round2Messages = EMPTY_BYTE_ARRAY_2;
        }
        if (round3Messages == null) {
            round3Messages = EMPTY_BYTE_ARRAY_2;
        }
        if (phase != SigningProtocolPhase.Aggregate && (schnorrPrivateKey == null || instanceEntropy == null || instanceEntropy.length != 32)) {
            return null;
        }
        if (phase == SigningProtocolPhase.R1) {
            if (!(Arrays.equals((Object[])schnorrPublicKeys, (Object[])EMPTY_BYTE_ARRAY_2) && Arrays.equals((Object[])round1Messages, (Object[])EMPTY_BYTE_ARRAY_2) && Arrays.equals((Object[])round2Messages, (Object[])EMPTY_BYTE_ARRAY_2) && Arrays.equals((Object[])round3Messages, (Object[])EMPTY_BYTE_ARRAY_2))) {
                return null;
            }
        } else if (phase == SigningProtocolPhase.R2) {
            if (!Arrays.equals((Object[])round2Messages, (Object[])EMPTY_BYTE_ARRAY_2) || !Arrays.equals((Object[])round3Messages, (Object[])EMPTY_BYTE_ARRAY_2)) {
                return null;
            }
            if (schnorrPublicKeys.length == 0 || schnorrPublicKeys.length != round1Messages.length || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys)) {
                return null;
            }
        } else if (phase == SigningProtocolPhase.R3) {
            if (!Arrays.equals((Object[])round3Messages, (Object[])EMPTY_BYTE_ARRAY_2)) {
                return null;
            }
            if (schnorrPublicKeys.length == 0 || schnorrPublicKeys.length != round1Messages.length || schnorrPublicKeys.length != round2Messages.length || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys)) {
                return null;
            }
        } else if (phase == SigningProtocolPhase.Aggregate) {
            if (schnorrPrivateKey != null || instanceEntropy != null) {
                return null;
            }
            if (schnorrPublicKeys.length == 0 || schnorrPublicKeys.length != round1Messages.length || schnorrPublicKeys.length != round2Messages.length || schnorrPublicKeys.length != round3Messages.length || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys)) {
                return null;
            }
        } else {
            throw new IllegalArgumentException("Unknown phase: " + String.valueOf((Object)phase));
        }
        return this.runSigningProtocolPhaseImpl(phase.ordinal(), instanceEntropy, messageToSign, schnorrPrivateKey, schnorrPublicKeys, round1Messages, round2Messages, round3Messages);
    }

    private native byte[] runSigningProtocolPhaseImpl(int var1, byte[] var2, byte[] var3, byte[] var4, byte[][] var5, byte[][] var6, byte[][] var7, byte[][] var8);

    public boolean verifySignature(byte[][] schnorrPublicKeys, byte[] messageToSign, byte[] signature) {
        if (schnorrPublicKeys == null || messageToSign == null || signature == null || schnorrPublicKeys.length == 0 || messageToSign.length == 0 || signature.length == 0 || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys)) {
            return false;
        }
        return this.verifySignatureImpl(schnorrPublicKeys, messageToSign, signature);
    }

    private native boolean verifySignatureImpl(byte[][] var1, byte[] var2, byte[] var3);

    public byte[] hashAddressBook(byte[][] schnorrPublicKeys, long[] weights) {
        if (schnorrPublicKeys == null || weights == null || schnorrPublicKeys.length != weights.length || !WRAPSLibraryBridge.validateWeightsSum(weights) || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys)) {
            return null;
        }
        return this.hashAddressBookImpl(schnorrPublicKeys, weights);
    }

    private native byte[] hashAddressBookImpl(byte[][] var1, long[] var2);

    public byte[] formatRotationMessage(byte[][] schnorrPublicKeys, long[] weights, byte[] hintsVerificationKey) {
        if (schnorrPublicKeys == null || weights == null || schnorrPublicKeys.length != weights.length || !WRAPSLibraryBridge.validateWeightsSum(weights) || hintsVerificationKey == null || hintsVerificationKey.length == 0 || !WRAPSLibraryBridge.validateSchnorrPublicKeys(schnorrPublicKeys)) {
            return null;
        }
        return this.formatRotationMessageImpl(schnorrPublicKeys, weights, hintsVerificationKey);
    }

    private native byte[] formatRotationMessageImpl(byte[][] var1, long[] var2, byte[] var3);

    public Proof constructWrapsProof(byte[] genesisAddressBookHash, byte[][] prevSchnorrPublicKeys, long[] prevWeights, byte[][] nextSchnorrPublicKeys, long[] nextWeights, byte[] prevProof, byte[] tssVerificationKey, byte[] aggregateSignature, boolean[] signers) {
        if (!WRAPSLibraryBridge.isProofSupported()) {
            return null;
        }
        if (!(genesisAddressBookHash != null && genesisAddressBookHash.length != 0 && prevSchnorrPublicKeys != null && prevWeights != null && prevSchnorrPublicKeys.length != 0 && prevSchnorrPublicKeys.length == prevWeights.length && WRAPSLibraryBridge.validateWeightsSum(prevWeights) && nextSchnorrPublicKeys != null && nextWeights != null && nextSchnorrPublicKeys.length != 0 && nextSchnorrPublicKeys.length == nextWeights.length && WRAPSLibraryBridge.validateWeightsSum(nextWeights) && tssVerificationKey != null && tssVerificationKey.length != 0 && aggregateSignature != null && aggregateSignature.length != 0 && signers != null && signers.length == prevSchnorrPublicKeys.length && WRAPSLibraryBridge.validateSchnorrPublicKeys(prevSchnorrPublicKeys) && WRAPSLibraryBridge.validateSchnorrPublicKeys(nextSchnorrPublicKeys))) {
            return null;
        }
        return this.constructWrapsProofImpl(genesisAddressBookHash, prevSchnorrPublicKeys, prevWeights, nextSchnorrPublicKeys, nextWeights, prevProof, tssVerificationKey, aggregateSignature, signers);
    }

    private native Proof constructWrapsProofImpl(byte[] var1, byte[][] var2, long[] var3, byte[][] var4, long[] var5, byte[] var6, byte[] var7, byte[] var8, boolean[] var9);

    public boolean verifyCompressedProof(byte[] compressedProof) {
        if (!WRAPSLibraryBridge.isProofSupported()) {
            return false;
        }
        if (compressedProof == null || compressedProof.length == 0) {
            return false;
        }
        return this.verifyCompressedProofImpl(compressedProof);
    }

    private native boolean verifyCompressedProofImpl(byte[] var1);

    private static boolean validateWeightsSum(long[] weights) {
        try {
            long sum = 0L;
            for (int i = 0; i < weights.length; ++i) {
                if (weights[i] < 0L) {
                    return false;
                }
                sum = Math.addExact(sum, weights[i]);
            }
            return sum <= Long.MAX_VALUE;
        }
        catch (ArithmeticException e) {
            return false;
        }
    }

    private static boolean validateSchnorrPublicKeys(byte[][] schnorrPublicKeys) {
        for (int i = 0; i < schnorrPublicKeys.length; ++i) {
            if (schnorrPublicKeys[i] != null && schnorrPublicKeys[i].length != 0) continue;
            return false;
        }
        return true;
    }

    static {
        WRAPSLibraryBridge.class.getModule().addOpens(INSTANCE_HOLDER.getNativeLibraryPackageName(), SingletonLoader.class.getModule());
        EMPTY_BYTE_ARRAY_2 = new byte[0][];
    }

    public static enum SigningProtocolPhase {
        R1,
        R2,
        R3,
        Aggregate;

    }
}

