/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeInvalid;
import org.hyperledger.besu.evm.code.CodeV0;
import org.hyperledger.besu.evm.code.CodeV1;
import org.hyperledger.besu.evm.code.CodeV1Validation;
import org.hyperledger.besu.evm.code.EOFLayout;
import org.hyperledger.besu.evm.code.EOFValidator;

public class CodeFactory {
    public static final byte EOF_LEAD_BYTE = -17;
    protected final int maxEofVersion;
    protected final int maxContainerSize;
    EOFValidator eofValidator;

    public CodeFactory(int maxEofVersion, int maxContainerSize) {
        this.maxEofVersion = maxEofVersion;
        this.maxContainerSize = maxContainerSize;
        this.eofValidator = new CodeV1Validation(maxContainerSize);
    }

    public Code createCode(Bytes bytes) {
        return this.createCode(bytes, false);
    }

    public Code createCode(Bytes bytes, boolean createTransaction) {
        return switch (this.maxEofVersion) {
            case 0 -> new CodeV0(bytes);
            case 1 -> this.createV1Code(bytes, createTransaction);
            default -> new CodeInvalid(bytes, "Unsupported max code version " + this.maxEofVersion);
        };
    }

    @Nonnull
    private Code createV1Code(Bytes bytes, boolean createTransaction) {
        int codeSize = bytes.size();
        if (codeSize > 0 && bytes.get(0) == -17) {
            if (codeSize < 3) {
                return new CodeInvalid(bytes, "EOF Container too short");
            }
            if (bytes.get(1) != 0) {
                if (createTransaction) {
                    return new CodeInvalid(bytes, "Incorrect second byte");
                }
                return new CodeV0(bytes);
            }
            byte version = bytes.get(2);
            if (version != 1) {
                return new CodeInvalid(bytes, "Unsupported EOF Version: " + version);
            }
            EOFLayout layout = EOFLayout.parseEOF(bytes, !createTransaction);
            if (createTransaction) {
                layout.containerMode().set(EOFLayout.EOFContainerMode.INITCODE);
            }
            return this.createCode(layout);
        }
        return new CodeV0(bytes);
    }

    @Nonnull
    Code createCode(EOFLayout layout) {
        if (!layout.isValid()) {
            return new CodeInvalid(layout.container(), "Invalid EOF Layout: " + layout.invalidReason());
        }
        String validationError = this.eofValidator.validate(layout);
        if (validationError != null) {
            return new CodeInvalid(layout.container(), "EOF Code Invalid : " + validationError);
        }
        return new CodeV1(layout);
    }
}

