/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class MCopyOperation
extends AbstractOperation {
    public MCopyOperation(GasCalculator gasCalculator) {
        super(94, "MCOPY", 3, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long dst = Words.clampedToLong(frame.popStackItem());
        long src = Words.clampedToLong(frame.popStackItem());
        long length = Words.clampedToLong(frame.popStackItem());
        long cost = this.gasCalculator().dataCopyOperationGasCost(frame, Math.max(src, dst), length);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        frame.copyMemory(dst, src, length, true);
        return new Operation.OperationResult(cost, null);
    }
}

